/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.springboot.utility.tasks;

import com.ibm.ws.springboot.utility.SpringBootUtilityReturnCodes;
import com.ibm.ws.springboot.utility.SpringBootUtilityTask;
import com.ibm.ws.springboot.utility.tasks.BaseCommandTask;
import com.ibm.ws.springboot.utility.utils.ConsoleWrapper;
import java.io.PrintStream;
import java.util.List;

public class HelpTask
extends BaseCommandTask {
    private final List<SpringBootUtilityTask> tasks;

    public HelpTask(String scriptName, List<SpringBootUtilityTask> tasks) {
        super(scriptName);
        this.tasks = tasks;
    }

    @Override
    public String getTaskName() {
        return "help";
    }

    @Override
    public String getTaskHelp() {
        return this.getTaskHelp("help.desc", "help.usage.options", null, null, null, null, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("help.desc", true, new Object[0]);
    }

    public String getScriptUsage() {
        StringBuffer scriptUsage = new StringBuffer(NL);
        scriptUsage.append(this.getMessage("usage", this.scriptName));
        scriptUsage.append(" {");
        for (int i = 0; i < this.tasks.size(); ++i) {
            SpringBootUtilityTask task = this.tasks.get(i);
            scriptUsage.append(task.getTaskName());
            if (i == this.tasks.size() - 1) continue;
            scriptUsage.append("|");
        }
        scriptUsage.append("} [options]");
        scriptUsage.append(NL);
        return scriptUsage.toString();
    }

    public String getTaskUsage(SpringBootUtilityTask task) {
        StringBuffer taskUsage = new StringBuffer(NL);
        taskUsage.append(NL);
        taskUsage.append(task.getTaskHelp());
        return taskUsage.toString();
    }

    private String verboseHelp() {
        StringBuffer verboseHelp = new StringBuffer(this.getScriptUsage());
        if (this.tasks.size() > 0) {
            verboseHelp.append(NL);
            verboseHelp.append(this.getOption("global.actions", true, new Object[0]));
            verboseHelp.append(NL);
            for (SpringBootUtilityTask task : this.tasks) {
                verboseHelp.append(NL);
                verboseHelp.append("    ");
                verboseHelp.append(task.getTaskName());
                verboseHelp.append(NL);
                verboseHelp.append(task.getTaskDescription());
                verboseHelp.append(NL);
            }
            verboseHelp.append(NL);
            verboseHelp.append(this.getOption("global.options", true, new Object[0]));
            verboseHelp.append(NL);
            verboseHelp.append(this.getOption("global.options.statement", true, new Object[0]));
        }
        return verboseHelp.toString();
    }

    private String taskHelp(SpringBootUtilityTask task) {
        StringBuffer taskUsage = new StringBuffer(NL);
        taskUsage.append(task.getTaskHelp());
        taskUsage.append(NL);
        return taskUsage.toString();
    }

    private SpringBootUtilityTask getTask(String taskName) {
        SpringBootUtilityTask task = null;
        for (SpringBootUtilityTask availTask : this.tasks) {
            if (!availTask.getTaskName().equals(taskName)) continue;
            task = availTask;
        }
        return task;
    }

    @Override
    public SpringBootUtilityReturnCodes handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) {
        if (args.length == 1) {
            stdout.println(this.verboseHelp());
        } else {
            SpringBootUtilityTask task = this.getTask(args[1]);
            if (task == null) {
                stderr.println(NL + this.getMessage("task.unknown", args[1]) + NL);
            } else {
                stdout.println(this.taskHelp(task));
            }
        }
        return SpringBootUtilityReturnCodes.OK;
    }

    @Override
    boolean isKnownArgument(String arg) {
        return false;
    }

    @Override
    void checkRequiredArguments(String[] args) {
    }
}

