/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.internal.archive.liberty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.internal.interfaces.ArchiveType;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ContainerInfoTypeUtils {
    private static final TraceComponent tc = Tr.register(ContainerInfoTypeUtils.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    static final long serialVersionUID = 6511626136677847983L;

    static ArchiveType getType(ContainerInfo.Type ciType) {
        switch (ciType) {
            case MANIFEST_CLASSPATH: {
                return ArchiveType.MANIFEST_CLASSPATH;
            }
            case WEB_INF_LIB: {
                return ArchiveType.WEB_INF_LIB;
            }
            case EAR_LIB: {
                return ArchiveType.EAR_LIB;
            }
            case WEB_MODULE: {
                return ArchiveType.WEB_MODULE;
            }
            case EJB_MODULE: {
                return ArchiveType.EJB_MODULE;
            }
            case CLIENT_MODULE: {
                return ArchiveType.CLIENT_MODULE;
            }
            case RAR_MODULE: {
                return ArchiveType.RAR_MODULE;
            }
            case JAR_MODULE: {
                return ArchiveType.JAR_MODULE;
            }
            case SHARED_LIB: {
                return ArchiveType.SHARED_LIB;
            }
        }
        throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"unknown.container.type.CWOWB1004E", (Object[])new Object[]{ciType}));
    }
}

