/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs20.JaxRsConstants;
import com.ibm.ws.jaxrs20.cache.LibertyJaxRsResourceMethodCache;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfoStack;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JAXRSInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(JAXRSInInterceptor.class, null, null);
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSInInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSInInterceptor.class);
    private static final String RESOURCE_OPERATION_NAME = "org.apache.cxf.resource.operation.name";
    static final long serialVersionUID = 7577875911788703035L;

    public JAXRSInInterceptor() {
        super("unmarshal");
    }

    @FFDCIgnore(value={Fault.class, RuntimeException.class})
    public void handleMessage(Message message) {
        Exchange exchange = message.getExchange();
        exchange.put((Object)"org.apache.cxf.rest.message", (Object)Boolean.TRUE);
        Response response = (Response)exchange.get(Response.class);
        if (response == null) {
            try {
                this.processRequest(message, exchange);
                if (exchange.isOneWay()) {
                    ServerProviderFactory.getInstance(message).clearThreadLocalProxies();
                }
            }
            catch (Fault ex) {
                this.convertExceptionToResponseIfPossible(ex.getCause(), message);
            }
            catch (RuntimeException ex) {
                this.convertExceptionToResponseIfPossible(ex, message);
            }
            catch (IOException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", (String)"95", (Object)((Object)this), (Object[])new Object[]{message});
                this.convertExceptionToResponseIfPossible(ex, message);
            }
        }
        if ((response = (Response)exchange.get(Response.class)) != null) {
            this.createOutMessage(message, response);
            message.getInterceptorChain().doInterceptStartingAt(message, OutgoingChainInterceptor.class.getName());
        }
    }

    @FFDCIgnore(value={WebApplicationException.class})
    private void processRequest(Message message, Exchange exchange) throws IOException {
        String mediaType;
        LibertyJaxRsResourceMethodCache.ResourceMethodCache rmCache;
        ServerProviderFactory providerFactory = ServerProviderFactory.getInstance(message);
        RequestPreprocessor rp = providerFactory.getRequestPreprocessor();
        if (rp != null) {
            rp.preprocess(message, new UriInfoImpl(message, null));
        }
        if (!JaxRsConstants.JAXRS_CONTAINER_FILTER_DISABLED.booleanValue() && JAXRSUtils.runContainerRequestFilters(providerFactory, message, true, null)) {
            return;
        }
        String httpMethod = ((MessageImpl)message).getHttpRequestMethod();
        if (httpMethod == null) {
            httpMethod = HttpUtils.getFromHeaders(message, "org.apache.cxf.request.method", "POST", true);
        }
        String rawPath = HttpUtils.getPathToMatch(message, true);
        Map protocolHeaders = ((MessageImpl)message).getProtocolHeaders();
        String requestContentType = null;
        List ctHeaderValues = (List)protocolHeaders.get("Content-Type");
        if (ctHeaderValues != null && !ctHeaderValues.isEmpty()) {
            requestContentType = (String)ctHeaderValues.get(0);
            ((MessageImpl)message).setContentType(requestContentType);
        }
        if (requestContentType == null && (requestContentType = ((MessageImpl)message).getContentType()) == null) {
            requestContentType = "*/*";
        }
        String acceptTypes = null;
        List acceptHeaderValues = (List)protocolHeaders.get("Accept");
        if (acceptHeaderValues != null && !acceptHeaderValues.isEmpty()) {
            acceptTypes = (String)acceptHeaderValues.get(0);
            ((MessageImpl)message).setAccept((Object)acceptTypes);
        }
        if (acceptTypes == null && (acceptTypes = HttpUtils.getProtocolHeader(message, "Accept", null)) == null) {
            acceptTypes = "*/*";
            ((MessageImpl)message).setAccept((Object)acceptTypes);
        }
        List<MediaType> acceptContentTypes = null;
        try {
            acceptContentTypes = JAXRSUtils.sortMediaTypes(acceptTypes, "q");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", (String)"175", (Object)((Object)this), (Object[])new Object[]{message, exchange});
            throw ExceptionUtils.toNotAcceptableException(null, null);
        }
        exchange.put((Object)"Accept", acceptContentTypes);
        List<ClassResourceInfo> resources = JAXRSUtils.getRootResources(message);
        LibertyJaxRsResourceMethodCache resourceMethodCache = (LibertyJaxRsResourceMethodCache)exchange.getBus().getExtension(LibertyJaxRsResourceMethodCache.class);
        MetadataMap<String, String> matchedValues = null;
        OperationResourceInfo ori = null;
        OperationResourceInfoStack oriStack = null;
        boolean shouldFind = true;
        String ckey = ((MessageImpl)message).getBasePath() + ":" + rawPath + ":" + httpMethod + ":" + requestContentType + ":" + acceptTypes;
        if (resourceMethodCache != null && (rmCache = resourceMethodCache.get(ckey)) != null) {
            ori = rmCache.getOperationResourceInfo();
            matchedValues = rmCache.getValues();
            mediaType = rmCache.getMediaType();
            if (!ori.isSubResourceLocator() && mediaType != null) {
                message.getExchange().put((Object)"Content-Type", (Object)mediaType);
            }
            this.setExchangeProperties(message, exchange, ori, matchedValues, resources.size());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("OperationResourceInfoStack on message: " + ((MessageImpl)message).getOperationResourceInfoStack()), (Object[])new Object[0]);
            }
            if (((MessageImpl)message).getOperationResourceInfoStack() == null && (oriStack = rmCache.getOperationResourceInfoStack()) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Setting OperationResourceInfoStack on message: " + oriStack), (Object[])new Object[0]);
                }
                ((MessageImpl)message).setOperationResourceInfoStack((Object)oriStack);
            }
            shouldFind = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("shouldFind = " + shouldFind), (Object[])new Object[0]);
        }
        if (shouldFind) {
            matchedValues = new MetadataMap<String, String>();
            Map<ClassResourceInfo, MultivaluedMap<String, String>> matchedResources = JAXRSUtils.selectResourceClass(resources, rawPath, message);
            if (matchedResources == null) {
                org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("NO_ROOT_EXC", BUNDLE, new Object[]{((MessageImpl)message).getRequestUri(), rawPath});
                Level logLevel = JAXRSUtils.getExceptionLogLevel(message, NotFoundException.class);
                LOG.log(logLevel == null ? Level.FINE : logLevel, errorMsg.toString());
                Response resp = JAXRSUtils.createResponse(resources, message, errorMsg.toString(), Response.Status.NOT_FOUND.getStatusCode(), false);
                throw ExceptionUtils.toNotFoundException(null, resp);
            }
            try {
                ori = JAXRSUtils.findTargetMethod(matchedResources, message, httpMethod, matchedValues, requestContentType, acceptContentTypes, true, true);
                this.setExchangeProperties(message, exchange, ori, matchedValues, resources.size());
                oriStack = (OperationResourceInfoStack)((MessageImpl)message).getOperationResourceInfoStack();
                if (resourceMethodCache != null) {
                    mediaType = (String)message.getExchange().get((Object)"Content-Type");
                    resourceMethodCache.put(ckey, ori, matchedValues, mediaType, oriStack);
                }
            }
            catch (WebApplicationException ex) {
                if (JAXRSUtils.noResourceMethodForOptions(ex.getResponse(), httpMethod)) {
                    Response response = JAXRSUtils.createResponse(resources, null, null, 200, true);
                    exchange.put(Response.class, (Object)response);
                    return;
                }
                throw ex;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Request path is: " + rawPath), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Request HTTP method is: " + httpMethod), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Request contentType is: " + requestContentType), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Accept contentType is: " + acceptTypes), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Found operation: " + ori.getMethodToInvoke().getName()), (Object[])new Object[0]);
            }
        }
        if (!JaxRsConstants.JAXRS_CONTAINER_FILTER_DISABLED.booleanValue() && !ori.isSubResourceLocator() && JAXRSUtils.runContainerRequestFilters(providerFactory, message, false, ori.getNameBindings())) {
            return;
        }
        List<Object> params = JAXRSUtils.processParameters(ori, matchedValues, message);
        message.setContent(List.class, params);
    }

    private void convertExceptionToResponseIfPossible(Throwable ex, Message message) {
        Response excResponse = JAXRSUtils.convertFaultToResponse(ex, message);
        if (excResponse == null) {
            ServerProviderFactory.getInstance(message).clearThreadLocalProxies();
            message.getExchange().put((Object)Message.PROPOGATE_EXCEPTION, (Object)ExceptionUtils.propogateException(message));
            throw ex instanceof RuntimeException ? (RuntimeException)ex : JAXRSUtils.toJaxRsRuntimeException(ex);
        }
        message.getExchange().put(Response.class, (Object)excResponse);
        message.getExchange().put(Throwable.class, (Object)ex);
    }

    private void setExchangeProperties(Message message, Exchange exchange, OperationResourceInfo ori, MultivaluedMap<String, String> values, int numberOfResources) {
        ClassResourceInfo cri = ori.getClassResourceInfo();
        exchange.put(OperationResourceInfo.class, (Object)ori);
        exchange.put((Object)"root.resource.class", (Object)cri);
        ((MessageImpl)message).setResourceMethod((Object)ori.getMethodToInvoke());
        ((MessageImpl)message).setTemplateParameters(values);
        String plainOperationName = ori.getMethodToInvoke().getName();
        if (numberOfResources > 1) {
            plainOperationName = cri.getServiceClass().getSimpleName() + "#" + plainOperationName;
        }
        exchange.put((Object)RESOURCE_OPERATION_NAME, (Object)plainOperationName);
        if (ori.isOneway()) {
            exchange.setOneWay(true);
        } else {
            Object oneWay = ((MessageImpl)message).getOneWayRequest();
            if (oneWay == null) {
                oneWay = HttpUtils.getFromHeaders(message, "OnewayRequest", null, false);
            }
            if (oneWay != null && PropertyUtils.isTrue((Object)oneWay)) {
                exchange.setOneWay(true);
            }
        }
        ResourceProvider rp = cri.getResourceProvider();
        if (rp instanceof SingletonResourceProvider) {
            exchange.put((Object)"org.apache.cxf.service.object", rp.getInstance(message));
        }
    }

    private Message createOutMessage(Message inMessage, Response r) {
        Endpoint e = inMessage.getExchange().getEndpoint();
        Message mout = e.getBinding().createMessage();
        mout.setContent(List.class, (Object)new MessageContentsList(new Object[]{r}));
        mout.setExchange(inMessage.getExchange());
        mout.setInterceptorChain(OutgoingChainInterceptor.getOutInterceptorChain((Exchange)inMessage.getExchange()));
        inMessage.getExchange().setOutMessage(mout);
        if (r.getStatus() >= Response.Status.BAD_REQUEST.getStatusCode()) {
            inMessage.getExchange().put((Object)"cxf.io.cacheinput", (Object)Boolean.FALSE);
        }
        return mout;
    }
}

