/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.cache.DistributedObjectCache;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.DCEventSource;
import com.ibm.ws.cache.DistributedMapImpl;
import com.ibm.ws.cache.DistributedNioMapImpl;
import com.ibm.ws.cache.DistributedObjectCacheAdapter;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.intf.ObjectCacheUnit;
import com.ibm.wsspi.cache.EventSource;

public class ObjectCacheUnitImpl
implements ObjectCacheUnit {
    private static TraceComponent tc = Tr.register(ObjectCacheUnitImpl.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createObjectCache(String reference) {
        CacheConfig config;
        String methodName = "createCacheInstance()";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createCacheInstance() cacheName=" + reference), (Object[])new Object[0]);
        }
        if ((config = ServerCache.getCacheService().getCacheInstanceConfig(reference)) == null) {
            Tr.error((TraceComponent)tc, (String)"DYNA1004E", (Object[])new Object[]{reference});
        }
        DistributedObjectCache dCache = null;
        CacheConfig cacheConfig = config;
        synchronized (cacheConfig) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Entered synchronized (config) for " + config.getCacheName()), (Object[])new Object[0]);
            }
            if ((dCache = config.getDistributedObjectCache()) == null) {
                dCache = this.createDistributedObjectCache(config);
                config.setDistributedObjectCache(dCache);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createCacheInstance() cacheName in=" + reference + " out=" + reference), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createCacheInstance()  distributedObjectCache=" + dCache));
        }
        return dCache;
    }

    private DistributedObjectCache createDistributedObjectCache(CacheConfig config) {
        String methodName = "createDistributedObjectCache()";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createDistributedObjectCache() cacheName=" + (config != null ? config.getCacheName() : "null")), (Object[])new Object[0]);
        }
        DCache dCache = ServerCache.createCache(config.getCacheName(), config);
        config.setCache(dCache);
        DistributedObjectCacheAdapter distributedObjectCache = null;
        distributedObjectCache = config.isEnableNioSupport() ? new DistributedNioMapImpl(dCache) : new DistributedMapImpl(dCache);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createDistributedObjectCache() distributedObjectCache=" + distributedObjectCache));
        }
        return distributedObjectCache;
    }

    @Override
    public EventSource createEventSource(boolean createAsyncEventSource, String cacheName) {
        DCEventSource eventSource = new DCEventSource(cacheName, createAsyncEventSource);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Using caller thread context for callback - cacheName= " + cacheName), (Object[])new Object[0]);
        }
        return eventSource;
    }
}

