/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.persistence.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import org.apache.geronimo.osgi.locator.ProviderLocator;
import org.apache.geronimo.specs.jpa.PersistenceActivator;

public class HybridPersistenceActivator
extends PersistenceActivator {
    private volatile WeakHashMap<ClassLoader, List<PersistenceProvider>> providerCache = new WeakHashMap();

    public List<PersistenceProvider> getPersistenceProviders() {
        List<PersistenceProvider> nonOSGiProviders;
        ClassLoader cl = PrivClassLoader.get(null);
        if (cl == null) {
            cl = PrivClassLoader.get(HybridPersistenceActivator.class);
        }
        if ((nonOSGiProviders = this.providerCache.get(cl)) == null) {
            nonOSGiProviders = new ArrayList<PersistenceProvider>();
            try {
                List providers = ProviderLocator.getServices((String)PersistenceProvider.class.getName(), ((Object)((Object)this)).getClass(), (ClassLoader)cl);
                for (Object o : providers) {
                    if (!(o instanceof PersistenceProvider)) continue;
                    nonOSGiProviders.add((PersistenceProvider)o);
                }
                this.providerCache.put(cl, nonOSGiProviders);
            }
            catch (Exception e) {
                throw new PersistenceException("Failed to load provider from META-INF/services", e);
            }
        }
        ArrayList<PersistenceProvider> combinedProviders = new ArrayList<PersistenceProvider>(nonOSGiProviders);
        combinedProviders.addAll(super.getPersistenceProviders());
        return combinedProviders;
    }

    public void clearCachedProviders() {
        this.providerCache.clear();
        super.clearCachedProviders();
    }

    private static class PrivClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final Class<?> c;

        public static ClassLoader get(Class<?> c) {
            PrivClassLoader action = new PrivClassLoader(c);
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(action);
            }
            return action.run();
        }

        private PrivClassLoader(Class<?> c) {
            this.c = c;
        }

        @Override
        public ClassLoader run() {
            if (this.c != null) {
                return this.c.getClassLoader();
            }
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

