/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal;

import com.ibm.ws.kernel.boot.LaunchException;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;

public class KernelUtils {
    private static File launchHome = null;
    private static URL launchURL = null;
    private static File libDir = null;

    public static File getBootstrapJar() {
        if (launchHome == null) {
            if (launchURL == null) {
                launchURL = KernelUtils.getLocationFromClass(KernelUtils.class);
            }
            launchHome = FileUtils.getFile(launchURL);
        }
        return launchHome;
    }

    public static URL getLocationFromClass(Class<?> cls) {
        ProtectionDomain domain = cls.getProtectionDomain();
        CodeSource source = null;
        if (domain != null) {
            source = domain.getCodeSource();
        }
        if (domain == null || source == null) {
            throw new LaunchException("Can not automatically set the security manager. Please use a policy file.", MessageFormat.format(BootstrapConstants.messages.getString("error.secPermission"), null));
        }
        URL home = source.getLocation();
        if (!home.getProtocol().equals("file")) {
            throw new LaunchException("Launch location is not a local file (launch location=" + home + ")", MessageFormat.format(BootstrapConstants.messages.getString("error.unsupportedLaunch"), home));
        }
        return home;
    }

    public static URL getBootstrapJarURL() {
        if (launchURL == null) {
            KernelUtils.getBootstrapJar();
        }
        return launchURL;
    }

    public static File getBootstrapLibDir() {
        if (libDir == null) {
            libDir = KernelUtils.getBootstrapJar().getParentFile();
        }
        return libDir;
    }

    public static void setBootStrapLibDir(File libDir) {
        KernelUtils.libDir = libDir;
    }

    public static void cleanStart(File workareaFile) {
        KernelUtils.cleanDirectory(workareaFile, "workarea");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(InputStream is) throws IOException {
        Properties p = new Properties();
        try {
            if (is != null) {
                p.load(is);
                for (Map.Entry<Object, Object> entry : p.entrySet()) {
                    String s = ((String)entry.getValue()).trim();
                    if (s.length() <= 1 || !s.startsWith("\"") || !s.endsWith("\"")) continue;
                    entry.setValue(s.substring(1, s.length() - 1));
                }
            }
        }
        finally {
            Utils.tryToClose(is);
        }
        return p;
    }

    public static String getServiceClass(BufferedReader reader) throws IOException {
        String line = null;
        while ((line = reader.readLine()) != null) {
            String className = KernelUtils.getClassFromLine(line);
            if (className == null) continue;
            return className;
        }
        return null;
    }

    private static String getClassFromLine(String line) {
        if ((line = line.trim()).length() == 0 || line.startsWith("#")) {
            return null;
        }
        String[] className = line.split("[\\s#]");
        if (className.length >= 1) {
            return className[0];
        }
        return null;
    }

    public static void cleanDirectory(File dir, String dirType) {
        boolean cleaned = true;
        if (dir.exists() && dir.isDirectory()) {
            cleaned = FileUtils.recursiveClean(dir);
        }
        if (!cleaned) {
            throw new IllegalStateException("The " + dirType + " could not be cleaned. " + dirType + "=" + dir);
        }
        boolean created = dir.mkdirs();
        if (!dir.exists() && !created) {
            throw new IllegalStateException("The " + dirType + "  could not be created. " + dirType + "=" + dir);
        }
    }
}

