/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.ws.logging.collector.CollectorJsonHelpers;
import com.ibm.ws.logging.collector.CollectorJsonUtils_JSON;
import com.ibm.ws.logging.data.AccessLogData;
import com.ibm.ws.logging.data.FFDCData;
import com.ibm.ws.logging.data.GCData;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.LogTraceData;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;

public class CollectorJsonUtils {
    public static final int MAX_USER_AGENT_LENGTH = 2048;

    public static String getEventType(String source, String location) {
        return CollectorJsonHelpers.getEventType(source, location);
    }

    public static String jsonifyEvent(Object event, String eventType, String serverName, String wlpUserDir, String serverHostName, String collectorVersion, String[] tags, int maxFieldLength) {
        if (!collectorVersion.startsWith("1.0")) {
            if (collectorVersion.startsWith("JSON")) {
                return CollectorJsonUtils_JSON.jsonifyEvent(event, eventType, serverName, wlpUserDir, serverHostName, tags, maxFieldLength);
            }
        } else {
            if (eventType.equals("liberty_gc")) {
                return CollectorJsonUtils.jsonifyGCEvent(wlpUserDir, serverName, serverHostName, event, tags);
            }
            if (eventType.equals("liberty_message")) {
                return CollectorJsonUtils.jsonifyTraceAndMessage(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_message", event, tags);
            }
            if (eventType.equals("liberty_trace")) {
                return CollectorJsonUtils.jsonifyTraceAndMessage(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_trace", event, tags);
            }
            if (eventType.equals("liberty_ffdc")) {
                return CollectorJsonUtils.jsonifyFFDC(maxFieldLength, wlpUserDir, serverName, serverHostName, event, tags);
            }
            if (eventType.equals("liberty_accesslog")) {
                return CollectorJsonUtils.jsonifyAccess(wlpUserDir, serverName, serverHostName, event, tags);
            }
            if (eventType.equals("liberty_audit")) {
                return CollectorJsonUtils.jsonifyAudit(wlpUserDir, serverName, serverHostName, event, tags);
            }
        }
        return "";
    }

    private static String jsonifyGCEvent(String wlpUserDir, String serverName, String hostName, Object event, String[] tags) {
        GCData gcData = (GCData)event;
        StringBuilder sb = CollectorJsonHelpers.startGCJson(hostName, wlpUserDir, serverName);
        CollectorJsonHelpers.addToJSON(sb, gcData.getHeapKey(), Long.toString(gcData.getHeap()), false, false, false, false, true);
        CollectorJsonHelpers.addToJSON(sb, gcData.getUsedHeapKey(), Long.toString(gcData.getUsedHeap()), false, false, false, false, true);
        CollectorJsonHelpers.addToJSON(sb, gcData.getMaxHeapKey(), Long.toString(gcData.getMaxHeap()), false, false, false, false, true);
        long duration = gcData.getDuration() * 1000L;
        CollectorJsonHelpers.addToJSON(sb, gcData.getDurationKey(), Long.toString(duration), false, false, false, false, true);
        CollectorJsonHelpers.addToJSON(sb, gcData.getGcTypeKey(), gcData.getGcType(), false, false, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, gcData.getReasonKey(), gcData.getReason(), false, false, false, false, false);
        String datetime = CollectorJsonHelpers.dateFormatTL.get().format(gcData.getDatetime());
        CollectorJsonHelpers.addToJSON(sb, gcData.getDatetimeKey(), datetime, false, false, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, gcData.getSequenceKey(), gcData.getSequence(), false, false, false, false, false);
        if (tags != null) {
            CollectorJsonUtils.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String jsonifyTraceAndMessage(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        LogTraceData logData = (LogTraceData)event;
        StringBuilder sb = null;
        if (eventType.equals("liberty_message")) {
            sb = CollectorJsonHelpers.startMessageJson(hostName, wlpUserDir, serverName);
        }
        if (eventType.equals("liberty_trace")) {
            sb = CollectorJsonHelpers.startTraceJson(hostName, wlpUserDir, serverName);
        }
        String message = logData.getMessage();
        String loglevel = logData.getLoglevel();
        if (loglevel != null && (loglevel.equals("ENTRY") || loglevel.equals("EXIT"))) {
            message = CollectorJsonHelpers.jsonRemoveSpace(message);
        }
        StringBuilder formattedValue = new StringBuilder(CollectorJsonHelpers.formatMessage(message, maxFieldLength));
        String throwable = logData.getThrowable();
        if (throwable != null) {
            formattedValue.append(CollectorJsonHelpers.LINE_SEPARATOR).append(throwable);
        }
        CollectorJsonHelpers.addToJSON(sb, logData.getMessageKey(), formattedValue.toString(), false, true, false, false);
        CollectorJsonHelpers.addToJSON(sb, logData.getThreadIdKey(), DataFormatHelper.padHexString(logData.getThreadId(), 8), false, true, false, false);
        String datetime = CollectorJsonHelpers.dateFormatTL.get().format(logData.getDatetime());
        CollectorJsonHelpers.addToJSON(sb, logData.getDatetimeKey(), datetime, false, true, false, false);
        CollectorJsonHelpers.addToJSON(sb, logData.getModuleKey(), logData.getModule(), false, true, false, false);
        CollectorJsonHelpers.addToJSON(sb, logData.getMessageIdKey(), logData.getMessageId(), false, true, false, false);
        CollectorJsonHelpers.addToJSON(sb, logData.getSeverityKey(), logData.getSeverity(), false, true, false, false);
        CollectorJsonHelpers.addToJSON(sb, logData.getMethodNameKey(), logData.getMethodName(), false, true, false, false);
        CollectorJsonHelpers.addToJSON(sb, logData.getClassNameKey(), logData.getClassName(), false, true, false, false);
        CollectorJsonHelpers.addToJSON(sb, logData.getSequenceKey(), logData.getSequence(), false, true, false, false);
        KeyValuePairList kvpl = logData.getExtensions();
        if (kvpl != null && kvpl.getKey().equals("extensions")) {
            ArrayList<KeyValuePair> extensions = kvpl.getList();
            for (KeyValuePair k : extensions) {
                String extKey = k.getKey();
                if (extKey.endsWith("_int")) {
                    CollectorJsonHelpers.addToJSON(sb, extKey, Integer.toString(k.getIntValue()), false, true, false, false, true);
                    continue;
                }
                if (extKey.endsWith("_float")) {
                    CollectorJsonHelpers.addToJSON(sb, extKey, Float.toString(k.getFloatValue()), false, true, false, false, true);
                    continue;
                }
                if (extKey.endsWith("_long")) {
                    CollectorJsonHelpers.addToJSON(sb, extKey, Long.toString(k.getLongValue()), false, true, false, false, true);
                    continue;
                }
                if (extKey.endsWith("_bool")) {
                    CollectorJsonHelpers.addToJSON(sb, extKey, Boolean.toString(k.getBooleanValue()), false, true, false, false, true);
                    continue;
                }
                CollectorJsonHelpers.addToJSON(sb, extKey, k.getStringValue(), false, true, false, false, false);
            }
        }
        if (tags != null) {
            CollectorJsonUtils.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String jsonifyFFDC(int maxFieldLength, String wlpUserDir, String serverName, String hostName, Object event, String[] tags) {
        FFDCData ffdcData = (FFDCData)event;
        StringBuilder sb = CollectorJsonHelpers.startFFDCJson(hostName, wlpUserDir, serverName);
        String datetime = CollectorJsonHelpers.dateFormatTL.get().format(ffdcData.getDatetime());
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getDatetimeKey(), datetime, false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getMessageKey(), ffdcData.getMessage(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getClassNameKey(), ffdcData.getClassName(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getExceptionNameKey(), ffdcData.getExceptionName(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getProbeIdKey(), ffdcData.getProbeId(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getThreadIdKey(), DataFormatHelper.padHexString((int)ffdcData.getThreadId(), 8), false, true, false, false, false);
        String formattedValue = CollectorJsonHelpers.formatMessage(ffdcData.getStacktrace(), maxFieldLength);
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getStacktraceKey(), formattedValue, false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getObjectDetailsKey(), ffdcData.getObjectDetails(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, ffdcData.getSequenceKey(), ffdcData.getSequence(), false, true, false, false, false);
        if (tags != null) {
            CollectorJsonUtils.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String jsonifyAccess(String wlpUserDir, String serverName, String hostName, Object event, String[] tags) {
        AccessLogData accessLogData = (AccessLogData)event;
        StringBuilder sb = CollectorJsonHelpers.startAccessLogJson(hostName, wlpUserDir, serverName);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getUriPathKey(), accessLogData.getUriPath(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getRequestMethodKey(), accessLogData.getRequestMethod(), false, true, false, false, false);
        String jsonQueryString = accessLogData.getQueryString();
        if (jsonQueryString != null) {
            try {
                jsonQueryString = URLDecoder.decode(jsonQueryString, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getQueryStringKey(), jsonQueryString, false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getRequestHostKey(), accessLogData.getRequestHost(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getRequestPortKey(), accessLogData.getRequestPort(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getRemoteHostKey(), accessLogData.getRemoteHost(), false, true, false, false, false);
        String userAgent = accessLogData.getUserAgent();
        if (userAgent != null && userAgent.length() > 2048) {
            userAgent = userAgent.substring(0, 2048);
        }
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getUserAgentKey(), userAgent, false, false, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getRequestProtocolKey(), accessLogData.getRequestProtocol(), false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getBytesReceivedKey(), Long.toString(accessLogData.getBytesReceived()), false, true, false, false, true);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getResponseCodeKey(), Integer.toString(accessLogData.getResponseCode()), false, true, false, false, true);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getElapsedTimeKey(), Long.toString(accessLogData.getElapsedTime()), false, true, false, false, true);
        String datetime = CollectorJsonHelpers.dateFormatTL.get().format(accessLogData.getDatetime());
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getDatetimeKey(), datetime, false, true, false, false, false);
        CollectorJsonHelpers.addToJSON(sb, accessLogData.getSequenceKey(), accessLogData.getSequence(), false, true, false, false, false);
        if (tags != null) {
            CollectorJsonUtils.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    public static String jsonifyAudit(String wlpUserDir, String serverName, String hostName, Object event, String[] tags) {
        GenericData genData = (GenericData)event;
        KeyValuePair[] pairs = genData.getPairs();
        String key = null;
        StringBuilder sb = CollectorJsonHelpers.startAuditJson(hostName, wlpUserDir, serverName);
        for (KeyValuePair kvp : pairs) {
            if (kvp == null || kvp.isList()) continue;
            key = kvp.getKey();
            if (key.equals("ibm_datetime") || key.equals("loggingEventTime")) {
                String datetime = CollectorJsonHelpers.dateFormatTL.get().format(kvp.getLongValue());
                CollectorJsonHelpers.addToJSON(sb, "datetime", datetime, false, true, false, false, false);
                continue;
            }
            if (key.equals("ibm_sequence") || key.equals("loggingSequenceNumber")) {
                CollectorJsonHelpers.addToJSON(sb, "sequence", kvp.getStringValue(), false, false, false, false, !kvp.isString());
                continue;
            }
            if (key.equals("ibm_threadId")) {
                CollectorJsonHelpers.addToJSON(sb, "threadId", DataFormatHelper.padHexString(kvp.getIntValue(), 8), false, true, false, false, false);
                continue;
            }
            CollectorJsonHelpers.addToJSON(sb, "ibm_audit_" + key, kvp.getStringValue(), false, false, false, false, !kvp.isString());
        }
        sb.append("}");
        return sb.toString();
    }

    private static StringBuilder addTagNameForVersion(StringBuilder sb) {
        sb.append(",\"tags\":");
        return sb;
    }
}

