/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.ws.logging.collector.CollectorJsonHelpers;
import com.ibm.ws.logging.data.AccessLogData;
import com.ibm.ws.logging.data.AuditData;
import com.ibm.ws.logging.data.FFDCData;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.JSONObject;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.LogTraceData;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;

public class CollectorJsonUtils_JSON {
    public static final int MAX_USER_AGENT_LENGTH = 2048;

    public static String getEventType(String source, String location) {
        return CollectorJsonHelpers.getEventType(source, location);
    }

    public static String jsonifyEvent(Object event, String eventType, String serverName, String wlpUserDir, String serverHostName, String[] tags, int maxFieldLength) {
        if (eventType.equals("liberty_message")) {
            return CollectorJsonUtils_JSON.jsonifyTraceAndMessage(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_message", event, tags);
        }
        if (eventType.equals("liberty_trace")) {
            return CollectorJsonUtils_JSON.jsonifyTraceAndMessage(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_trace", event, tags);
        }
        if (eventType.equals("liberty_ffdc")) {
            return CollectorJsonUtils_JSON.jsonifyFFDC(maxFieldLength, wlpUserDir, serverName, serverHostName, event, tags);
        }
        if (eventType.equals("liberty_accesslog")) {
            return CollectorJsonUtils_JSON.jsonifyAccess(wlpUserDir, serverName, serverHostName, event, tags);
        }
        if (eventType.equals("liberty_audit")) {
            return CollectorJsonUtils_JSON.jsonifyAudit(wlpUserDir, serverName, serverHostName, event, tags);
        }
        return "";
    }

    private static String jsonifyFFDC(int maxFieldLength, String wlpUserDir, String serverName, String hostName, Object event, String[] tags) {
        FFDCData ffdcData = (FFDCData)event;
        JSONObject.JSONObjectBuilder jsonBuilder = CollectorJsonHelpers.startFFDCJsonFields(hostName, wlpUserDir, serverName);
        String datetime = CollectorJsonHelpers.dateFormatTL.get().format(ffdcData.getDatetime());
        String formattedValue = CollectorJsonHelpers.formatMessage(ffdcData.getStacktrace(), maxFieldLength);
        jsonBuilder.addField(FFDCData.getDatetimeKeyJSON(), datetime, false, true).addField(FFDCData.getMessageKeyJSON(), ffdcData.getMessage(), false, true).addField(FFDCData.getClassNameKeyJSON(), ffdcData.getClassName(), false, true).addField(FFDCData.getExceptionNameKeyJSON(), ffdcData.getExceptionName(), false, true).addField(FFDCData.getProbeIdKeyJSON(), ffdcData.getProbeId(), false, true).addField(FFDCData.getThreadIdKeyJSON(), DataFormatHelper.padHexString((int)ffdcData.getThreadId(), 8), false, true).addField(FFDCData.getStacktraceKeyJSON(), formattedValue, false, true).addField(FFDCData.getObjectDetailsKeyJSON(), ffdcData.getObjectDetails(), false, true).addField(FFDCData.getSequenceKeyJSON(), ffdcData.getSequence(), false, true);
        if (tags != null) {
            jsonBuilder.addPreformattedField("ibm_tags", CollectorJsonHelpers.jsonifyTags(tags));
        }
        return jsonBuilder.build().toString();
    }

    public static String jsonifyAccess(String wlpUserDir, String serverName, String hostName, Object event, String[] tags) {
        String userAgent;
        AccessLogData accessLogData = (AccessLogData)event;
        JSONObject.JSONObjectBuilder jsonBuilder = CollectorJsonHelpers.startAccessLogJsonFields(hostName, wlpUserDir, serverName);
        String jsonQueryString = accessLogData.getQueryString();
        if (jsonQueryString != null) {
            try {
                jsonQueryString = URLDecoder.decode(jsonQueryString, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if ((userAgent = accessLogData.getUserAgent()) != null && userAgent.length() > 2048) {
            userAgent = userAgent.substring(0, 2048);
        }
        String datetime = CollectorJsonHelpers.dateFormatTL.get().format(accessLogData.getDatetime());
        jsonBuilder.addField(AccessLogData.getUriPathKeyJSON(), accessLogData.getUriPath(), false, true).addField(AccessLogData.getRequestMethodKeyJSON(), accessLogData.getRequestMethod(), false, true).addField(AccessLogData.getQueryStringKeyJSON(), jsonQueryString, false, true).addField(AccessLogData.getRequestHostKeyJSON(), accessLogData.getRequestHost(), false, true).addField(AccessLogData.getRequestPortKeyJSON(), accessLogData.getRequestPort(), false, true).addField(AccessLogData.getRemoteHostKeyJSON(), accessLogData.getRemoteHost(), false, true).addField(AccessLogData.getUserAgentKeyJSON(), userAgent, false, false).addField(AccessLogData.getRequestProtocolKeyJSON(), accessLogData.getRequestProtocol(), false, true).addField(AccessLogData.getBytesReceivedKeyJSON(), accessLogData.getBytesReceived(), false).addField(AccessLogData.getResponseCodeKeyJSON(), accessLogData.getResponseCode(), false).addField(AccessLogData.getElapsedTimeKeyJSON(), accessLogData.getElapsedTime(), false).addField(AccessLogData.getDatetimeKeyJSON(), datetime, false, true).addField(AccessLogData.getSequenceKeyJSON(), accessLogData.getSequence(), false, true);
        if (tags != null) {
            jsonBuilder.addPreformattedField("ibm_tags", CollectorJsonHelpers.jsonifyTags(tags));
        }
        return jsonBuilder.build().toString();
    }

    private static String jsonifyTraceAndMessage(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        LogTraceData logData = (LogTraceData)event;
        JSONObject.JSONObjectBuilder jsonBuilder = null;
        boolean isMessageEvent = eventType.equals("liberty_message");
        ArrayList<KeyValuePair> extensions = null;
        KeyValuePairList kvpl = null;
        if (isMessageEvent) {
            jsonBuilder = CollectorJsonHelpers.startMessageJsonFields(hostName, wlpUserDir, serverName);
        }
        if (!isMessageEvent) {
            jsonBuilder = CollectorJsonHelpers.startTraceJsonFields(hostName, wlpUserDir, serverName);
        }
        String message = logData.getMessage();
        String loglevel = logData.getLoglevel();
        if (loglevel != null && (loglevel.equals("ENTRY") || loglevel.equals("EXIT"))) {
            message = CollectorJsonHelpers.jsonRemoveSpace(message);
        }
        StringBuilder formattedValue = new StringBuilder(CollectorJsonHelpers.formatMessage(message, maxFieldLength));
        String throwable = logData.getThrowable();
        if (throwable != null) {
            formattedValue.append(CollectorJsonHelpers.LINE_SEPARATOR).append(throwable);
        }
        String datetime = CollectorJsonHelpers.dateFormatTL.get().format(logData.getDatetime());
        jsonBuilder.addField(LogTraceData.getMessageKeyJSON(isMessageEvent), formattedValue.toString(), false, true).addField(LogTraceData.getThreadIdKeyJSON(isMessageEvent), DataFormatHelper.padHexString(logData.getThreadId(), 8), false, true).addField(LogTraceData.getDatetimeKeyJSON(isMessageEvent), datetime, false, true).addField(LogTraceData.getMessageIdKeyJSON(isMessageEvent), logData.getMessageId(), false, true).addField(LogTraceData.getModuleKeyJSON(isMessageEvent), logData.getModule(), false, true).addField(LogTraceData.getLoglevelKeyJSON(isMessageEvent), logData.getLoglevel(), false, true).addField(LogTraceData.getMethodNameKeyJSON(isMessageEvent), logData.getMethodName(), false, true).addField(LogTraceData.getClassNameKeyJSON(isMessageEvent), logData.getClassName(), false, true).addField(LogTraceData.getSequenceKeyJSON(isMessageEvent), logData.getSequence(), false, true);
        kvpl = logData.getExtensions();
        if (kvpl != null && kvpl.getKey().equals("extensions")) {
            extensions = kvpl.getList();
            for (KeyValuePair k : extensions) {
                String extKey = k.getKey();
                if (extKey.endsWith("_int")) {
                    jsonBuilder.addField(LogTraceData.getExtensionNameKeyJSON(isMessageEvent, extKey), k.getIntValue(), false);
                    continue;
                }
                if (extKey.endsWith("_float")) {
                    jsonBuilder.addField(LogTraceData.getExtensionNameKeyJSON(isMessageEvent, extKey), k.getFloatValue(), false);
                    continue;
                }
                if (extKey.endsWith("_long")) {
                    jsonBuilder.addField(LogTraceData.getExtensionNameKeyJSON(isMessageEvent, extKey), k.getLongValue(), false);
                    continue;
                }
                if (extKey.endsWith("_bool")) {
                    jsonBuilder.addField(LogTraceData.getExtensionNameKeyJSON(isMessageEvent, extKey), k.getBooleanValue(), false);
                    continue;
                }
                jsonBuilder.addField(LogTraceData.getExtensionNameKeyJSON(isMessageEvent, extKey), k.getStringValue(), false, true);
            }
        }
        if (tags != null) {
            jsonBuilder.addPreformattedField("ibm_tags", CollectorJsonHelpers.jsonifyTags(tags));
        }
        return jsonBuilder.build().toString();
    }

    public static String jsonifyAudit(String wlpUserDir, String serverName, String hostName, Object event, String[] tags) {
        GenericData genData = (GenericData)event;
        KeyValuePair[] pairs = genData.getPairs();
        String key = null;
        JSONObject.JSONObjectBuilder jsonBuilder = CollectorJsonHelpers.startAuditJsonFields(hostName, wlpUserDir, serverName);
        for (KeyValuePair kvp : pairs) {
            if (kvp == null || kvp.isList()) continue;
            key = kvp.getKey();
            if (key.equals("ibm_datetime") || key.equals("loggingEventTime") || AuditData.getDatetimeKeyJSON().equals(key)) {
                String datetime = CollectorJsonHelpers.dateFormatTL.get().format(kvp.getLongValue());
                jsonBuilder.addField(AuditData.getDatetimeKeyJSON(), datetime, false, true);
                continue;
            }
            if (key.equals("ibm_sequence") || key.equals("loggingSequenceNumber") || AuditData.getSequenceKeyJSON().equals(key)) {
                jsonBuilder.addField(AuditData.getSequenceKeyJSON(), kvp.getStringValue(), false, false);
                continue;
            }
            if (key.equals("ibm_threadId") || AuditData.getThreadIDKeyJSON().equals(key)) {
                jsonBuilder.addField(AuditData.getThreadIDKeyJSON(), DataFormatHelper.padHexString(kvp.getIntValue(), 8), false, true);
                continue;
            }
            jsonBuilder.addField("ibm_audit_" + key, kvp.getStringValue(), false, false);
        }
        return jsonBuilder.build().toString();
    }
}

