/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.persistence.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.persistence.PersistenceServiceUnitConfig;
import com.ibm.wsspi.persistence.internal.PUInfoImpl;
import com.ibm.wsspi.persistence.internal.eclipselink.PsSessionEventListener;
import com.ibm.wsspi.persistence.internal.eclipselink.TraceLog;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.DBPlatformHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.SessionEventManager;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DatabaseManager {
    private static final TraceComponent tc = Tr.register(DatabaseManager.class, (String)"persistenceService", (String)"com.ibm.wsspi.persistence.internal.PersistenceServiceMessages");
    private static Set<Pattern> _noUnicodeSupportPlatform = Collections.newSetFromMap(new ConcurrentHashMap());
    private static Set<Pattern> _unicodeSupportPlatform;
    static final long serialVersionUID = 4117873021064295225L;

    public DatabasePlatform getPlatform(EntityManagerFactory emf) {
        return ((DatabaseSessionImpl)emf.unwrap(DatabaseSessionImpl.class)).getPlatform();
    }

    public boolean isOracle(EntityManagerFactory emf) {
        return this.getPlatform(emf).isOracle();
    }

    @FFDCIgnore(value={Exception.class})
    public void processUnicodeSettings(EntityManagerFactory emf, PersistenceServiceUnitConfig conf) {
        DataSource ds = conf.getJtaDataSource();
        if (conf.getAllowUnicode() != null || ds == null) {
            return;
        }
        org.eclipse.persistence.platform.database.DatabasePlatform db = null;
        AbstractSession session = null;
        try {
            db = ((DatabaseSessionImpl)emf.unwrap(DatabaseSessionImpl.class)).getPlatform();
            session = (AbstractSession)emf.unwrap(AbstractSession.class);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"caught an exception trying to unwrap an emf. Possibly no connection?", (Object[])new Object[]{e});
            }
            return;
        }
        Boolean supports = this.supportsUnicodeStaticCheck(ds);
        if (supports == null && db.shouldUseGetSetNString()) {
            supports = Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(supports)) {
            SessionEventManager sem = session.getEventManager();
            for (SessionEventListener sel : new ArrayList(sem.getListeners())) {
                if (!(sel instanceof PsSessionEventListener)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"removing unicode filter", (Object[])new Object[]{sel});
                }
                ((PsSessionEventListener)sel).removeWrappingConnector(session);
                sem.removeListener(sel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    public String getDatabasePlatformClassName(PUInfoImpl pui) {
        String majorVersion;
        String minorVersion;
        String vendorName;
        TraceLog traceLogger;
        block19: {
            traceLogger = new TraceLog();
            Properties properties = pui.getProperties();
            vendorName = null;
            minorVersion = null;
            majorVersion = null;
            if (properties.containsKey("javax.persistence.database-product-name")) {
                vendorName = properties.getProperty("javax.persistence.database-product-name");
                minorVersion = properties.getProperty("javax.persistence.database-minor-version");
                majorVersion = properties.getProperty("javax.persistence.database-major-version");
            } else {
                DataSource ds = pui.getJtaDataSource();
                if (ds == null) {
                    ds = pui.getNonJtaDataSource();
                }
                if (ds != null) {
                    Connection conn = null;
                    conn = ds.getConnection();
                    DatabaseMetaData dmd2333333332 = conn.getMetaData();
                    vendorName = dmd2333333332.getDatabaseProductName();
                    minorVersion = dmd2333333332.getDatabaseProductVersion();
                    majorVersion = Integer.toString(dmd2333333332.getDatabaseMajorVersion());
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        break block19;
                    }
                    catch (SQLException dmd2333333332) {
                        FFDCFilter.processException((Throwable)dmd2333333332, (String)"com.ibm.wsspi.persistence.internal.DatabaseManager", (String)"176", (Object)this, (Object[])new Object[]{pui});
                        if (tc.isDebugEnabled()) {
                            void sqlee;
                            Tr.debug((TraceComponent)tc, (String)"Unable to retrieve connection in getDatabasePlatformClassName", (Object[])new Object[]{sqlee});
                        }
                        break block19;
                    }
                    catch (SQLException sqlee) {
                        block20: {
                            try {
                                void sqle;
                                FFDCFilter.processException((Throwable)sqlee, (String)"com.ibm.wsspi.persistence.internal.DatabaseManager", (String)"167", (Object)this, (Object[])new Object[]{pui});
                                if (!tc.isDebugEnabled()) break block20;
                                Tr.debug((TraceComponent)tc, (String)"Unable to retrieve connection in getDatabasePlatformClassName", (Object[])new Object[]{sqle});
                            }
                            catch (Throwable throwable) {
                                block21: {
                                    try {
                                        if (conn != null) {
                                            conn.close();
                                        }
                                    }
                                    catch (SQLException sQLException) {
                                        void sqlee2;
                                        FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.wsspi.persistence.internal.DatabaseManager", (String)"176", (Object)this, (Object[])new Object[]{pui});
                                        if (!tc.isDebugEnabled()) break block21;
                                        Tr.debug((TraceComponent)tc, (String)"Unable to retrieve connection in getDatabasePlatformClassName", (Object[])new Object[]{sqlee2});
                                    }
                                }
                                throw throwable;
                            }
                        }
                        try {
                            if (conn != null) {
                                conn.close();
                            }
                        }
                        catch (SQLException sqle) {
                            FFDCFilter.processException((Throwable)sqle, (String)"com.ibm.wsspi.persistence.internal.DatabaseManager", (String)"176", (Object)this, (Object[])new Object[]{pui});
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Unable to retrieve connection in getDatabasePlatformClassName", (Object[])new Object[]{sqlee});
                            }
                        }
                    }
                }
            }
        }
        return DBPlatformHelper.getDBPlatform((String)vendorName, (String)minorVersion, (String)majorVersion, (SessionLog)traceLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={SQLException.class})
    private Boolean supportsUnicodeStaticCheck(DataSource ds) {
        Boolean res;
        block11: {
            res = null;
            try {
                String product = null;
                try (Connection conn = ds.getConnection();){
                    DatabaseMetaData dmd = conn.getMetaData();
                    product = dmd.getDatabaseProductName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("supportsUnicodeStaticCheck : getDatabaseProductName = " + product), (Object[])new Object[0]);
                    }
                }
                for (Pattern supportedPattern : _unicodeSupportPlatform) {
                    if (!supportedPattern.matcher(product).matches()) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("matched _unicodeSupportPlatform=" + supportedPattern.pattern()), (Object[])new Object[0]);
                    }
                    return Boolean.TRUE;
                }
                for (Pattern unsupported : _noUnicodeSupportPlatform) {
                    if (!unsupported.matcher(product).matches()) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("matched _noUnicodeSupportPlatform=" + unsupported.pattern()), (Object[])new Object[0]);
                    }
                    return Boolean.FALSE;
                }
            }
            catch (SQLException e) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug((TraceComponent)tc, (String)"Something went wrong in supportsUnicodeStaticCheck() -- ", (Object[])new Object[]{e});
            }
        }
        return res;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        _noUnicodeSupportPlatform.add(Pattern.compile("(?i)(.)*informix(.)*"));
        _unicodeSupportPlatform = Collections.newSetFromMap(new ConcurrentHashMap());
        _unicodeSupportPlatform.add(Pattern.compile("(?i)(.)*db2(.)*"));
        _unicodeSupportPlatform.add(Pattern.compile("(?i)(.)*derby(.)*"));
    }
}

