/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.injectionengine.AbstractInjectionEngine;
import com.ibm.ws.javaee.dd.common.JNDIEnvironmentRef;
import com.ibm.ws.javaee.dd.common.PersistenceContextRef;
import com.ibm.ws.javaee.dd.common.PersistenceUnitRef;
import com.ibm.ws.resource.ResourceRefConfig;
import com.ibm.ws.resource.ResourceRefConfigList;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfigurationProvider;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionProcessorContextImpl;
import com.ibm.wsspi.injectionengine.InjectionScope;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.InternalInjectionEngineAccessor;
import com.ibm.wsspi.injectionengine.JNDIEnvironmentRefType;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;

public class ReferenceContextImpl
implements ReferenceContext {
    private static final String CLASS_NAME = ReferenceContextImpl.class.getName();
    private static final TraceComponent tc = Tr.register(ReferenceContextImpl.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    private final AbstractInjectionEngine ivInjectionEngine;
    private final List<ComponentNameSpaceConfigurationProvider> ivProviders = new ArrayList<ComponentNameSpaceConfigurationProvider>();
    private Context ivComponentJavaContext = null;
    private Object ivComponentNameSpace = null;
    private HashMap<String, InjectionBinding<?>> ivJavaColonCompEnvMap;
    private Properties ivEjbContext10 = null;
    private ResourceRefConfigList ivResourceRefConfigList = null;
    private boolean isAlreadyProcessed = false;
    private InjectionException ivProcessFailure;
    private final Map<Class<?>, InjectionTarget[]> ivInjectionTargetMap = new ConcurrentHashMap();
    private static final int svInjTarMapCacheSize = 256;
    private Map<Class<?>, List<InjectionTarget>> ivDeclaredInjectionTargets;
    private final Set<Class<?>> ivProcessedInjectionClasses = new HashSet();
    private static final int svInjClassMapCacheSize = 512;
    private Collection<InjectionBinding<?>> ivProcessedInjectionBindings;
    private boolean ivAnyProcessDynamic;
    private boolean ivCheckAppConfig = false;

    public ReferenceContextImpl(AbstractInjectionEngine injectionEngine) {
        this.ivInjectionEngine = injectionEngine;
    }

    public String toString() {
        return super.toString() + this.ivProviders;
    }

    @Override
    public Context getJavaCompContext() {
        return this.ivComponentJavaContext;
    }

    @Override
    public Object getComponentNameSpace() {
        return this.ivComponentNameSpace;
    }

    @Override
    public HashMap<String, InjectionBinding<?>> getJavaColonCompEnvMap() {
        return this.ivJavaColonCompEnvMap;
    }

    @Override
    public Properties getEJBContext10Properties() {
        return this.ivEjbContext10;
    }

    @Override
    public ResourceRefConfigList getResolvedResourceRefs() {
        return this.ivResourceRefConfigList;
    }

    @Override
    public void add(final ComponentNameSpaceConfiguration compNSConfig) {
        this.add(new ComponentNameSpaceConfigurationProvider(){

            public String toString() {
                return super.toString() + '[' + compNSConfig.getJ2EEName() + ']';
            }

            @Override
            public ComponentNameSpaceConfiguration getComponentNameSpaceConfiguration() {
                return compNSConfig;
            }
        });
    }

    @Override
    public synchronized void add(ComponentNameSpaceConfigurationProvider compNSConfigProvider) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("add: " + this + ", " + compNSConfigProvider), (Object[])new Object[0]);
        }
        if (this.isAlreadyProcessed) {
            throw new IllegalStateException("Unable to add a new ComponentNameSpaceConfiguration info object because this ReferenceContext instance has already been processed.");
        }
        this.ivProviders.add(compNSConfigProvider);
    }

    @Override
    public synchronized void process() throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("process: " + this), (Object[])new Object[0]);
        }
        if (this.isAlreadyProcessed) {
            if (this.ivProcessFailure != null) {
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("rethrowing " + this.ivProcessFailure));
                }
                throw new InjectionException(this.ivProcessFailure.getMessage(), this.ivProcessFailure);
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"No-opping the .process() method because this ReferenceContext instance has already been processed.");
            }
            return;
        }
        if (this.ivProviders.isEmpty()) {
            throw new IllegalStateException("Unable to perform reference processing.  The list of input components was empty.");
        }
        boolean complete = false;
        try {
            this.processImpl();
            complete = true;
        }
        catch (InjectionException ex) {
            this.ivProcessFailure = ex;
            complete = true;
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("process: " + ex));
            }
            throw ex;
        }
        finally {
            if (complete) {
                this.isAlreadyProcessed = true;
                this.ivProviders.clear();
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"process");
        }
    }

    private void processImpl() throws InjectionException {
        List injectionBindings;
        ArrayList annotatedClasses;
        ComponentNameSpaceConfiguration masterCompNSConfig;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        int numProviders = this.ivProviders.size();
        ArrayList<ComponentNameSpaceConfiguration> compNSConfigs = new ArrayList<ComponentNameSpaceConfiguration>(numProviders);
        ComponentNameSpaceConfiguration primaryCompNSConfig = null;
        for (int i = 0; i < numProviders; ++i) {
            ComponentNameSpaceConfigurationProvider provider = this.ivProviders.get(i);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("config " + i + " from " + provider), (Object[])new Object[0]);
            }
            ComponentNameSpaceConfiguration compNSConfig = provider.getComponentNameSpaceConfiguration();
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("config " + i + " = " + compNSConfig.toDumpString()), (Object[])new Object[0]);
            }
            compNSConfigs.add(compNSConfig);
            if (compNSConfig.getOwningFlow() == ComponentNameSpaceConfiguration.ReferenceFlowKind.WEB) {
                primaryCompNSConfig = compNSConfig;
            }
            this.ivCheckAppConfig |= compNSConfig.isCheckApplicationConfiguration();
        }
        if (primaryCompNSConfig == null) {
            primaryCompNSConfig = (ComponentNameSpaceConfiguration)compNSConfigs.get(0);
        }
        J2EEName j2eeName = primaryCompNSConfig.getJ2EEName();
        String logicalModuleName = null;
        String logicalAppName = null;
        if (primaryCompNSConfig.getOwningFlow() != ComponentNameSpaceConfiguration.ReferenceFlowKind.MANAGED_BEAN) {
            logicalModuleName = primaryCompNSConfig.getLogicalModuleName();
            logicalAppName = primaryCompNSConfig.getLogicalApplicationName();
            String componentName = numProviders > 1 ? null : j2eeName.getComponent();
            try {
                this.ivComponentNameSpace = this.ivInjectionEngine.createJavaNameSpace(logicalAppName != null ? logicalAppName : logicalModuleName, j2eeName.getModule(), logicalModuleName, componentName);
                this.ivComponentJavaContext = this.ivInjectionEngine.createComponentNameSpaceContext(this.ivComponentNameSpace);
            }
            catch (NamingException nex) {
                FFDCFilter.processException((Throwable)nex, (String)(CLASS_NAME + ".process"), (String)"517", (Object)this);
                InjectionException iex = new InjectionException("Failed to create the JNDI component name space for the " + primaryCompNSConfig.getDisplayName() + " component in the " + primaryCompNSConfig.getModuleName() + " module of the " + primaryCompNSConfig.getApplicationName() + " application : " + nex.getMessage(), nex);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("process: " + iex));
                }
                throw iex;
            }
            this.ivJavaColonCompEnvMap = new LinkedHashMap();
            this.ivEjbContext10 = new Properties();
        }
        if (numProviders == 1) {
            masterCompNSConfig = primaryCompNSConfig;
            masterCompNSConfig.setJavaColonContext(this.ivComponentJavaContext);
            masterCompNSConfig.setJavaColonCompEnvMap(this.ivJavaColonCompEnvMap);
            masterCompNSConfig.setEnvironmentProperties(this.ivEjbContext10);
            this.ivResourceRefConfigList = masterCompNSConfig.getResourceRefConfigList();
            annotatedClasses = null;
        } else {
            HashSet totalInjectionClasses = new HashSet();
            HashSet totalAnnotatedClasses = new HashSet();
            EnumMap<JNDIEnvironmentRefType, List<? extends JNDIEnvironmentRef>> totalRefs = new EnumMap<JNDIEnvironmentRefType, List<? extends JNDIEnvironmentRef>>(JNDIEnvironmentRefType.class);
            ClassLoader classLoader = null;
            boolean usesActivitySessions = false;
            boolean isSFSB = false;
            for (int componentIndex = 0; componentIndex < numProviders; ++componentIndex) {
                List<Class<?>> classesInPlay;
                ComponentNameSpaceConfiguration compNSConfig = (ComponentNameSpaceConfiguration)compNSConfigs.get(componentIndex);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("merging component " + componentIndex + ": " + compNSConfig.getJ2EEName()), (Object[])new Object[0]);
                }
                if ((classesInPlay = compNSConfig.getInjectionClasses()) != null) {
                    totalInjectionClasses.addAll(classesInPlay);
                    if (!compNSConfig.isMetaDataComplete()) {
                        totalAnnotatedClasses.addAll(classesInPlay);
                    }
                }
                JNDIEnvironmentRefType.addAllRefs(totalRefs, compNSConfig);
                ClassLoader currentClassLoader = compNSConfig.getClassLoader();
                if (classLoader == null) {
                    classLoader = currentClassLoader;
                } else if (classLoader != currentClassLoader) {
                    throw new IllegalStateException("Unable to perform reference processing. The input components are not using the same classloader.");
                }
                if (!usesActivitySessions && compNSConfig.usesActivitySessions()) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Setting the usesActivitySessions flag to true for hybrid module.", (Object[])new Object[0]);
                    }
                    usesActivitySessions = true;
                }
                if (isSFSB || !compNSConfig.isSFSB()) continue;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Setting SFSB flag to true because at least one bean module is a SFSB.", (Object[])new Object[0]);
                }
                isSFSB = true;
            }
            annotatedClasses = new ArrayList(totalAnnotatedClasses);
            masterCompNSConfig = new ComponentNameSpaceConfiguration(primaryCompNSConfig.getModuleName(), primaryCompNSConfig.getJ2EEName());
            masterCompNSConfig.setLogicalModuleName(logicalAppName, logicalModuleName);
            masterCompNSConfig.setOwningFlow(ComponentNameSpaceConfiguration.ReferenceFlowKind.HYBRID);
            masterCompNSConfig.setCheckApplicationConfiguration(this.ivCheckAppConfig);
            masterCompNSConfig.setJavaColonContext(this.ivComponentJavaContext);
            masterCompNSConfig.setJavaColonCompEnvMap(this.ivJavaColonCompEnvMap);
            masterCompNSConfig.setClassLoader(classLoader);
            masterCompNSConfig.setModuleMetaData(primaryCompNSConfig.getModuleMetaData());
            masterCompNSConfig.setModuleLoadStrategy(primaryCompNSConfig.getModuleLoadStrategy());
            masterCompNSConfig.setInjectionClasses(new ArrayList(totalInjectionClasses));
            masterCompNSConfig.setSFSB(isSFSB);
            masterCompNSConfig.setUsesActivitySessions(usesActivitySessions);
            masterCompNSConfig.setEnvironmentProperties(this.ivEjbContext10);
            JNDIEnvironmentRefType.setAllRefs(masterCompNSConfig, totalRefs);
            ReferenceContextImpl.mergeResRefsAndBindings(masterCompNSConfig, compNSConfigs, null);
            this.ivResourceRefConfigList = masterCompNSConfig.getResourceRefConfigList();
            this.createPersistenceMaps(masterCompNSConfig, compNSConfigs);
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("annotatedClasses=" + annotatedClasses), (Object[])new Object[0]);
        }
        InjectionProcessorContextImpl context = this.ivInjectionEngine.createInjectionProcessorContext();
        masterCompNSConfig.setInjectionProcessorContext(context);
        List<Class<?>> injectionClasses = masterCompNSConfig.getInjectionClasses();
        if (injectionClasses != null) {
            this.ivProcessedInjectionClasses.addAll(injectionClasses);
        }
        this.ivInjectionEngine.processInjectionMetaData(masterCompNSConfig, annotatedClasses);
        this.ivProcessedInjectionBindings = injectionBindings = context.ivProcessedInjectionBindings;
        this.ivDeclaredInjectionTargets = this.ivInjectionEngine.getDeclaredInjectionTargets(injectionBindings);
        context.metadataProcessingComplete();
        this.ivInjectionEngine.notifyInjectionMetaDataListeners(this, masterCompNSConfig);
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Output component context:", (Object[])new Object[]{this.ivComponentJavaContext});
            if (this.ivJavaColonCompEnvMap != null) {
                Tr.debug((TraceComponent)tc, (String)"Output java:comp/env map: ", (Object[])new Object[]{this.dumpJavaColonCompEnvMap()});
            }
            Tr.debug((TraceComponent)tc, (String)"Output EJB context 1.0: ", (Object[])new Object[]{this.ivEjbContext10});
            Tr.debug((TraceComponent)tc, (String)"Output ResourceRefs: ", (Object[])new Object[]{this.ivResourceRefConfigList});
            Tr.debug((TraceComponent)tc, (String)"Output InjectionBindings: ", (Object[])new Object[]{injectionBindings});
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createPersistenceMaps(ComponentNameSpaceConfiguration masterCompNSConfig, List<ComponentNameSpaceConfiguration> compNSConfigs) {
        HashMap classesToComponents = new HashMap();
        HashMap<String, Collection<String>> persistenceRefsToComponents = new HashMap<String, Collection<String>>();
        for (ComponentNameSpaceConfiguration compNSConfig : compNSConfigs) {
            List<? extends PersistenceUnitRef> puRefs;
            List<? extends PersistenceContextRef> pcRefs;
            List<Class<?>> classesToScan;
            ComponentMetaData cmd = compNSConfig.getComponentMetaData();
            if (cmd == null) continue;
            String name = cmd.getJ2EEName().getComponent();
            if (!compNSConfig.isMetaDataComplete() && (classesToScan = compNSConfig.getInjectionClasses()) != null) {
                Iterator<Class<?>> iterator = classesToScan.iterator();
                while (iterator.hasNext()) {
                    void var12_17;
                    Class<?> clazz;
                    Class<?> clazz2 = clazz = iterator.next();
                    while (var12_17 != null && var12_17 != Object.class) {
                        this.addComponentToPersistenceMap(classesToComponents, var12_17, name);
                        Class clazz3 = var12_17.getSuperclass();
                    }
                }
            }
            if ((pcRefs = compNSConfig.getPersistenceContextRefs()) != null) {
                for (PersistenceContextRef persistenceContextRef : pcRefs) {
                    this.addComponentToPersistenceMap(persistenceRefsToComponents, persistenceContextRef.getName(), name);
                }
            }
            if ((puRefs = compNSConfig.getPersistenceUnitRefs()) == null) continue;
            for (PersistenceUnitRef persistenceUnitRef : puRefs) {
                this.addComponentToPersistenceMap(persistenceRefsToComponents, persistenceUnitRef.getName(), name);
            }
        }
        masterCompNSConfig.setPersistenceMaps(classesToComponents, persistenceRefsToComponents);
    }

    private <T> void addComponentToPersistenceMap(Map<T, Collection<String>> map, T key, String name) {
        Collection<String> components = map.get(key);
        if (components == null) {
            components = new LinkedHashSet<String>();
            map.put(key, components);
        }
        components.add(name);
    }

    private String dumpJavaColonCompEnvMap() {
        StringBuffer buffer = new StringBuffer("");
        buffer.append("EJBContext.lookup data structure contents:\n");
        buffer.append("   Contains **" + this.ivJavaColonCompEnvMap.size() + "** bindings.\n");
        if (!this.ivJavaColonCompEnvMap.isEmpty()) {
            Set<Map.Entry<String, InjectionBinding<?>>> entries = this.ivJavaColonCompEnvMap.entrySet();
            Iterator<Map.Entry<String, InjectionBinding<?>>> entryIterator = entries.iterator();
            int count = 0;
            while (entryIterator.hasNext()) {
                Map.Entry<String, InjectionBinding<?>> oneEntry = entryIterator.next();
                buffer.append("     Entry " + count + "\n");
                buffer.append("            Key: **" + oneEntry.getKey() + "**\n");
                buffer.append("            Value: **" + oneEntry.getValue() + "**\n");
                buffer.append("\n");
                ++count;
            }
        }
        return buffer.toString();
    }

    static void mergeResRefsAndBindings(ComponentNameSpaceConfiguration masterCompNSConfig, List<ComponentNameSpaceConfiguration> compNSConfigs, InjectionScope scope) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mergeResRefsAndBindings", (Object[])new Object[0]);
        }
        LinkedHashMap<String, ResourceRefConfig[]> resRefMap = new LinkedHashMap<String, ResourceRefConfig[]>();
        EnumMap allBindingComps = new EnumMap(JNDIEnvironmentRefType.class);
        for (JNDIEnvironmentRefType refType : JNDIEnvironmentRefType.VALUES) {
            if (refType.getBindingElementName() == null) continue;
            masterCompNSConfig.setJNDIEnvironmentRefBindings(refType.getType(), new HashMap<String, String>());
            allBindingComps.put(refType, new HashMap());
        }
        HashMap<String, String> envEntryValues = new HashMap<String, String>();
        HashMap<String, ComponentNameSpaceConfiguration> envEntryValueComps = new HashMap<String, ComponentNameSpaceConfiguration>();
        masterCompNSConfig.setEnvEntryValues(envEntryValues);
        boolean refMergeSuccess = true;
        for (int componentIndex = 0; componentIndex < compNSConfigs.size(); ++componentIndex) {
            ResourceRefConfigList resRefs;
            ComponentNameSpaceConfiguration compNSConfig = compNSConfigs.get(componentIndex);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("merging component " + componentIndex + ": " + compNSConfig.getJ2EEName()), (Object[])new Object[0]);
            }
            if ((resRefs = compNSConfig.getResourceRefConfigList()) != null) {
                int size = resRefs.size();
                for (int i = 0; i < size; ++i) {
                    ResourceRefConfig resRef = resRefs.getResourceRefConfig(i);
                    String resRefName = resRef.getName();
                    if (scope != null && scope != InjectionScope.match(resRefName)) continue;
                    ResourceRefConfig[] resRefArray = (ResourceRefConfig[])resRefMap.get(resRefName);
                    if (resRefArray == null) {
                        resRefArray = new ResourceRefConfig[compNSConfigs.size()];
                        resRefMap.put(resRefName, resRefArray);
                    }
                    if (resRefArray[componentIndex] != null) continue;
                    resRefArray[componentIndex] = resRef;
                }
            }
            for (JNDIEnvironmentRefType refType : JNDIEnvironmentRefType.VALUES) {
                if (refType.getBindingElementName() == null) continue;
                refMergeSuccess &= ReferenceContextImpl.mergeBindings(compNSConfig, scope, refType.getBindingElementName(), refType.getBindingAttributeName(), compNSConfig.getJNDIEnvironmentRefBindings(refType.getType()), masterCompNSConfig.getJNDIEnvironmentRefBindings(refType.getType()), (Map)allBindingComps.get((Object)refType));
            }
            refMergeSuccess &= ReferenceContextImpl.mergeBindings(compNSConfig, scope, "env-entry", "value", compNSConfig.getEnvEntryValues(), envEntryValues, envEntryValueComps);
        }
        if (!(refMergeSuccess &= ReferenceContextImpl.mergeResRefs(masterCompNSConfig, compNSConfigs, resRefMap))) {
            throw new InjectionConfigurationException("There were conflicting references.  See CWNEN0061E messages in log for details.");
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mergeResRefsAndBindings");
        }
    }

    private static boolean mergeBindings(ComponentNameSpaceConfiguration compNSConfig, InjectionScope scope, String whatType, String whatAttribute, Map<String, String> bindings, Map<String, String> allBindings, Map<String, ComponentNameSpaceConfiguration> allComps) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("mergeBindings: " + whatType), (Object[])new Object[0]);
        }
        boolean success = true;
        if (bindings != null) {
            for (Map.Entry<String, String> entry : bindings.entrySet()) {
                String refName = entry.getKey();
                if (scope != null && scope != InjectionScope.match(refName)) continue;
                String binding = entry.getValue();
                String oldBinding = allBindings.get(refName);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("merging " + refName + ": " + binding + " and " + oldBinding), (Object[])new Object[0]);
                }
                if (oldBinding == null) {
                    allBindings.put(refName, binding);
                    allComps.put(refName, compNSConfig);
                    continue;
                }
                if (binding.equals(oldBinding)) continue;
                ComponentNameSpaceConfiguration oldCompNSConfig = allComps.get(refName);
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_REFERENCES_CWNEN0062E", (Object[])new Object[]{oldCompNSConfig.getDisplayName(), compNSConfig.getDisplayName(), compNSConfig.getModuleName(), compNSConfig.getApplicationName(), whatAttribute, refName, oldBinding, binding});
                success = false;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("mergeBindings: " + success));
        }
        return success;
    }

    private static boolean mergeResRefs(ComponentNameSpaceConfiguration masterCompNSConfig, List<ComponentNameSpaceConfiguration> compNSConfigs, Map<String, ResourceRefConfig[]> totalResRefs) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mergeResRefs", (Object[])new Object[0]);
        }
        ResourceRefConfigList resRefList = InternalInjectionEngineAccessor.getInstance().createResourceRefConfigList();
        masterCompNSConfig.setResourceRefConfigList(resRefList);
        ArrayList conflicts = new ArrayList();
        for (Map.Entry<String, ResourceRefConfig[]> entry : totalResRefs.entrySet()) {
            ResourceRefConfig mergedResRef = resRefList.findOrAddByName(entry.getKey());
            mergedResRef.mergeBindingsAndExtensions(entry.getValue(), conflicts);
        }
        boolean success = conflicts.isEmpty();
        if (!success) {
            for (ResourceRefConfig.MergeConflict conflict : conflicts) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_REFERENCES_CWNEN0062E", (Object[])new Object[]{compNSConfigs.get(conflict.getIndex1()).getDisplayName(), compNSConfigs.get(conflict.getIndex2()).getDisplayName(), masterCompNSConfig.getModuleName(), masterCompNSConfig.getApplicationName(), conflict.getAttributeName(), conflict.getResourceRefConfig().getName(), conflict.getValue1(), conflict.getValue2()});
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("mergeResRefs: " + success));
        }
        return success;
    }

    @Override
    public synchronized void processDynamic(final ComponentNameSpaceConfiguration compNSConfig) throws InjectionException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws InjectionException {
                    ReferenceContextImpl.this.processDynamicPrivileged(compNSConfig);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException paex) {
            Throwable cause = paex.getCause();
            if (cause instanceof InjectionException) {
                throw (InjectionException)cause;
            }
            throw new Error(cause);
        }
    }

    private void processDynamicPrivileged(ComponentNameSpaceConfiguration compNSConfig) throws InjectionException {
        List<Class<?>> injectionClasses;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processDynamic", (Object[])new Object[0]);
        }
        if (this.isProcessDynamicNeeded(injectionClasses = compNSConfig.getInjectionClasses())) {
            HashMap completedInjectionBindings = new HashMap();
            for (InjectionBinding<?> binding : this.ivProcessedInjectionBindings) {
                completedInjectionBindings.put(binding.getJndiName(), binding);
            }
            InjectionProcessorContextImpl context = this.ivInjectionEngine.createInjectionProcessorContext();
            context.ivCompletedInjectionBindings = completedInjectionBindings;
            compNSConfig.setInjectionProcessorContext(context);
            this.ivInjectionEngine.processInjectionMetaData(compNSConfig, injectionClasses);
            if (!this.ivAnyProcessDynamic) {
                this.ivAnyProcessDynamic = true;
                this.ivProcessedInjectionBindings = new LinkedHashSet(this.ivProcessedInjectionBindings);
            }
            this.ivProcessedInjectionBindings.addAll(context.ivProcessedInjectionBindings);
            Map<Class<?>, List<InjectionTarget>> declaredTargets = this.ivInjectionEngine.getDeclaredInjectionTargets(context.ivProcessedInjectionBindings);
            this.ivDeclaredInjectionTargets.putAll(declaredTargets);
            for (Class<?> injectionClass : injectionClasses) {
                this.ivInjectionTargetMap.remove(injectionClass);
            }
            context.metadataProcessingComplete();
            if (this.ivProcessedInjectionClasses.size() <= 512) {
                this.ivProcessedInjectionClasses.addAll(injectionClasses);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processDynamic: added to processed classes; size = " + this.ivProcessedInjectionClasses.size()), (Object[])new Object[0]);
                }
            } else if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processDynamic: not added to processed classes; size = " + this.ivProcessedInjectionClasses.size()), (Object[])new Object[0]);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processDynamic");
        }
    }

    @Override
    public boolean isProcessDynamicNeeded(List<Class<?>> injectionClasses) {
        for (Class<?> klass : injectionClasses) {
            if (this.ivProcessedInjectionClasses.contains(klass)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InjectionTarget[] getInjectionTargets(final Class<?> classToInjectInto) throws InjectionException {
        InjectionTarget[] injectionTargetsForClass;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInjectionTargets: " + classToInjectInto + ", " + this), (Object[])new Object[0]);
        }
        if ((injectionTargetsForClass = this.ivInjectionTargetMap.get(classToInjectInto)) == null) {
            Map<Class<?>, InjectionTarget[]> map = this.ivInjectionTargetMap;
            synchronized (map) {
                injectionTargetsForClass = this.ivInjectionTargetMap.get(classToInjectInto);
                if (injectionTargetsForClass == null) {
                    try {
                        injectionTargetsForClass = AccessController.doPrivileged(new PrivilegedExceptionAction<InjectionTarget[]>(){

                            @Override
                            public InjectionTarget[] run() throws Exception {
                                return ReferenceContextImpl.this.ivInjectionEngine.getInjectionTargets(ReferenceContextImpl.this.ivDeclaredInjectionTargets, classToInjectInto, ReferenceContextImpl.this.ivCheckAppConfig);
                            }
                        });
                    }
                    catch (PrivilegedActionException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof InjectionException) {
                            throw (InjectionException)cause;
                        }
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        throw new InjectionException(cause);
                    }
                    if (this.ivInjectionTargetMap.size() <= 256 || injectionTargetsForClass.length > 0) {
                        this.ivInjectionTargetMap.put(classToInjectInto, injectionTargetsForClass);
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("getInjectionTargets: added to cache; size = " + this.ivInjectionTargetMap.size()), (Object[])new Object[0]);
                        }
                    } else if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getInjectionTargets: not added to cache; size = " + this.ivInjectionTargetMap.size()), (Object[])new Object[0]);
                    }
                } else if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getInjectionTargets: found in cache; size = " + this.ivInjectionTargetMap.size()), (Object[])new Object[0]);
                }
            }
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getInjectionTargets: found in cache; size = " + this.ivInjectionTargetMap.size()), (Object[])new Object[0]);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInjectionTargets", Arrays.asList(injectionTargetsForClass));
        }
        return injectionTargetsForClass;
    }

    @Override
    public synchronized Set<Class<?>> getProcessedInjectionClasses() {
        return new HashSet(this.ivProcessedInjectionClasses);
    }
}

