/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.session.store.cache.BuiltinSerializationInfo;
import com.ibm.ws.session.store.cache.TypeConversion;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SerializationInfoCache {
    public static final byte LONG = 0;
    public static final BuiltinSerializationInfo<Long> LONG_INFO;
    public static final byte INTEGER = 1;
    public static final BuiltinSerializationInfo<Integer> INTEGER_INFO;
    public static final byte SHORT = 2;
    public static final BuiltinSerializationInfo<Short> SHORT_INFO;
    public static final byte BYTE = 3;
    public static final BuiltinSerializationInfo<Byte> BYTE_INFO;
    public static final byte FLOAT = 4;
    public static final BuiltinSerializationInfo<Float> FLOAT_INFO;
    public static final byte DOUBLE = 5;
    public static final BuiltinSerializationInfo<Double> DOUBLE_INFO;
    public static final byte CHARACTER = 6;
    public static final BuiltinSerializationInfo<Character> CHARACTER_INFO;
    public static final byte BOOLEAN = 7;
    public static final BuiltinSerializationInfo<Boolean> BOOLEAN_INFO;
    public static final byte DATE = 8;
    public static final BuiltinSerializationInfo<java.util.Date> DATE_INFO;
    public static final byte SQL_DATE = 9;
    public static final BuiltinSerializationInfo<Date> SQL_DATE_INFO;
    public static final byte SQL_TIMESTAMP = 10;
    public static final BuiltinSerializationInfo<Timestamp> SQL_TIMESTAMP_INFO;
    public static final byte SQL_TIME = 11;
    public static final BuiltinSerializationInfo<Time> SQL_TIME_INFO;
    public static final byte BIG_DECIMAL = 12;
    public static final BuiltinSerializationInfo<BigDecimal> BIG_DECIMAL_INFO;
    public static final byte BIG_INTEGER = 13;
    public static final BuiltinSerializationInfo<BigInteger> BIG_INTEGER_INFO;
    public static final byte BYTE_ARRAY = 14;
    public static final BuiltinSerializationInfo<byte[]> BYTE_ARRAY_INFO;
    public static final byte ATOMIC_INTEGER = 15;
    public static final BuiltinSerializationInfo<AtomicInteger> ATOMIC_INTEGER_INFO;
    public static final byte ATOMIC_LONG = 16;
    public static final BuiltinSerializationInfo<AtomicLong> ATOMIC_LONG_INFO;
    public static final byte BUILTIN_SIZE = 17;
    public static final byte BUILTIN_SERIALIZATION = 0;
    private static final Map<Class<?>, BuiltinSerializationInfo<?>> BUILTIN_MAPPINGS;
    private static final BuiltinSerializationInfo<?>[] BUILTIN_ARRAY;
    static final long serialVersionUID = -5695946753367435169L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static BuiltinSerializationInfo<?> lookupByClass(Class<?> c) {
        return BUILTIN_MAPPINGS.get(c);
    }

    public static BuiltinSerializationInfo<?> lookupByIndex(byte index) {
        BuiltinSerializationInfo<?> returnValue = null;
        if (index < 17 && index > -1) {
            returnValue = BUILTIN_ARRAY[index];
        }
        return returnValue;
    }

    private static void addBuiltinSerializationInfo(BuiltinSerializationInfo<?> info) {
        BUILTIN_MAPPINGS.put(info.getObjectClass(), info);
        SerializationInfoCache.BUILTIN_ARRAY[info.getIndex()] = info;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.session.store.cache.SerializationInfoCache", SerializationInfoCache.class, null, (String)"com.ibm.ws.session.store.cache.resources.WASSessionCache");
        LONG_INFO = new LongInfo();
        INTEGER_INFO = new IntegerInfo();
        SHORT_INFO = new ShortInfo();
        BYTE_INFO = new ByteInfo();
        FLOAT_INFO = new FloatInfo();
        DOUBLE_INFO = new DoubleInfo();
        CHARACTER_INFO = new CharacterInfo();
        BOOLEAN_INFO = new BooleanInfo();
        DATE_INFO = new DateInfo();
        SQL_DATE_INFO = new SqlDateInfo();
        SQL_TIMESTAMP_INFO = new SqlTimestampInfo();
        SQL_TIME_INFO = new SqlTimeInfo();
        BIG_DECIMAL_INFO = new BigDecimalInfo();
        BIG_INTEGER_INFO = new BigIntegerInfo();
        BYTE_ARRAY_INFO = new ByteArrayInfo();
        ATOMIC_INTEGER_INFO = new AtomicIntegerInfo();
        ATOMIC_LONG_INFO = new AtomicLongInfo();
        BUILTIN_MAPPINGS = new HashMap();
        BUILTIN_ARRAY = new BuiltinSerializationInfo[17];
        SerializationInfoCache.addBuiltinSerializationInfo(LONG_INFO);
        SerializationInfoCache.addBuiltinSerializationInfo(INTEGER_INFO);
        SerializationInfoCache.addBuiltinSerializationInfo(SHORT_INFO);
        SerializationInfoCache.addBuiltinSerializationInfo(BYTE_INFO);
        SerializationInfoCache.addBuiltinSerializationInfo(FLOAT_INFO);
        SerializationInfoCache.addBuiltinSerializationInfo(DOUBLE_INFO);
        SerializationInfoCache.addBuiltinSerializationInfo(CHARACTER_INFO);
        SerializationInfoCache.addBuiltinSerializationInfo(BOOLEAN_INFO);
        SerializationInfoCache.addBuiltinSerializationInfo(DATE_INFO);
        SerializationInfoCache.addBuiltinSerializationInfo(SQL_DATE_INFO);
        SerializationInfoCache.addBuiltinSerializationInfo(SQL_TIMESTAMP_INFO);
        SerializationInfoCache.addBuiltinSerializationInfo(SQL_TIME_INFO);
        SerializationInfoCache.addBuiltinSerializationInfo(BIG_DECIMAL_INFO);
        SerializationInfoCache.addBuiltinSerializationInfo(BIG_INTEGER_INFO);
        SerializationInfoCache.addBuiltinSerializationInfo(BYTE_ARRAY_INFO);
        SerializationInfoCache.addBuiltinSerializationInfo(ATOMIC_INTEGER_INFO);
        SerializationInfoCache.addBuiltinSerializationInfo(ATOMIC_LONG_INFO);
    }

    @Trivial
    public static final class AtomicLongInfo
    implements BuiltinSerializationInfo<AtomicLong> {
        @Override
        public byte getIndex() {
            return 16;
        }

        @Override
        public Class<AtomicLong> getObjectClass() {
            return AtomicLong.class;
        }

        @Override
        public AtomicLong bytesToObject(byte[] bytes) {
            long atomicLongValue = TypeConversion.varIntBytesToLong(bytes, 2);
            return new AtomicLong(atomicLongValue);
        }

        @Override
        public byte[] objectToBytes(Object object) {
            byte[] bytes = new byte[]{0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            int numWritten = TypeConversion.writeLongAsVarIntBytes(((AtomicLong)object).get(), bytes, 2);
            if (numWritten < 12) {
                byte[] smallArray = new byte[numWritten];
                System.arraycopy(bytes, 0, smallArray, 0, numWritten);
                return smallArray;
            }
            return bytes;
        }
    }

    @Trivial
    public static final class AtomicIntegerInfo
    implements BuiltinSerializationInfo<AtomicInteger> {
        @Override
        public byte getIndex() {
            return 15;
        }

        @Override
        public Class<AtomicInteger> getObjectClass() {
            return AtomicInteger.class;
        }

        @Override
        public AtomicInteger bytesToObject(byte[] bytes) {
            int atomicIntValue = TypeConversion.varIntBytesToInt(bytes, 2);
            return new AtomicInteger(atomicIntValue);
        }

        @Override
        public byte[] objectToBytes(Object object) {
            byte[] bytes = new byte[]{0, 15, 0, 0, 0, 0, 0};
            int numWritten = TypeConversion.writeIntAsVarIntBytes(((AtomicInteger)object).get(), bytes, 2);
            if (numWritten < 7) {
                byte[] smallArray = new byte[numWritten];
                System.arraycopy(bytes, 0, smallArray, 0, numWritten);
                return smallArray;
            }
            return bytes;
        }
    }

    @Trivial
    public static final class ByteArrayInfo
    implements BuiltinSerializationInfo<byte[]> {
        @Override
        public byte getIndex() {
            return 14;
        }

        @Override
        public Class<byte[]> getObjectClass() {
            return byte[].class;
        }

        @Override
        public byte[] bytesToObject(byte[] bytes) {
            int length = TypeConversion.bytesToInt(bytes, 2);
            byte[] returnBytes = new byte[length];
            System.arraycopy(bytes, 6, returnBytes, 0, length);
            return returnBytes;
        }

        @Override
        public byte[] objectToBytes(Object object) {
            byte[] bytes = (byte[])object;
            int length = bytes.length;
            byte[] returnBytes = new byte[length + 6];
            returnBytes[0] = 0;
            returnBytes[1] = 14;
            TypeConversion.intToBytes(length, returnBytes, 2);
            System.arraycopy(bytes, 0, returnBytes, 6, length);
            return returnBytes;
        }
    }

    @Trivial
    public static final class BigIntegerInfo
    implements BuiltinSerializationInfo<BigInteger> {
        @Override
        public byte getIndex() {
            return 13;
        }

        @Override
        public Class<BigInteger> getObjectClass() {
            return BigInteger.class;
        }

        @Override
        public BigInteger bytesToObject(byte[] bytes) {
            int length = TypeConversion.bytesToInt(bytes, 2);
            byte[] integerBytes = new byte[length];
            System.arraycopy(bytes, 6, integerBytes, 0, length);
            return new BigInteger(integerBytes);
        }

        @Override
        public byte[] objectToBytes(Object object) {
            BigInteger bi = (BigInteger)object;
            byte[] integerBytes = bi.toByteArray();
            int length = integerBytes.length;
            byte[] bytes = new byte[length + 6];
            bytes[0] = 0;
            bytes[1] = 13;
            TypeConversion.intToBytes(length, bytes, 2);
            System.arraycopy(integerBytes, 0, bytes, 6, length);
            return bytes;
        }
    }

    @Trivial
    public static final class BigDecimalInfo
    implements BuiltinSerializationInfo<BigDecimal> {
        @Override
        public byte getIndex() {
            return 12;
        }

        @Override
        public Class<BigDecimal> getObjectClass() {
            return BigDecimal.class;
        }

        @Override
        public BigDecimal bytesToObject(byte[] bytes) {
            int length = TypeConversion.bytesToInt(bytes, 2);
            byte[] decimalBytes = new byte[length];
            System.arraycopy(bytes, 6, decimalBytes, 0, length);
            int scale = TypeConversion.bytesToInt(bytes, length + 6);
            return new BigDecimal(new BigInteger(decimalBytes), scale);
        }

        @Override
        public byte[] objectToBytes(Object object) {
            BigDecimal bd = (BigDecimal)object;
            BigInteger bi = bd.unscaledValue();
            byte[] decimalBytes = bi.toByteArray();
            int length = decimalBytes.length;
            byte[] bytes = new byte[length + 10];
            bytes[0] = 0;
            bytes[1] = 12;
            TypeConversion.intToBytes(length, bytes, 2);
            System.arraycopy(decimalBytes, 0, bytes, 6, length);
            TypeConversion.intToBytes(bd.scale(), bytes, length + 6);
            return bytes;
        }
    }

    @Trivial
    public static final class SqlTimeInfo
    implements BuiltinSerializationInfo<Time> {
        @Override
        public byte getIndex() {
            return 11;
        }

        @Override
        public Class<Time> getObjectClass() {
            return Time.class;
        }

        @Override
        public Time bytesToObject(byte[] bytes) {
            long l = TypeConversion.varIntBytesToLong(bytes, 2);
            return new Time(l);
        }

        @Override
        public byte[] objectToBytes(Object object) {
            long l = ((Time)object).getTime();
            byte[] bytes = new byte[]{0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            int numWritten = TypeConversion.writeLongAsVarIntBytes(l, bytes, 2);
            if (numWritten < 12) {
                byte[] smallArray = new byte[numWritten];
                System.arraycopy(bytes, 0, smallArray, 0, numWritten);
                return smallArray;
            }
            return bytes;
        }
    }

    @Trivial
    public static final class SqlTimestampInfo
    implements BuiltinSerializationInfo<Timestamp> {
        @Override
        public byte getIndex() {
            return 10;
        }

        @Override
        public Class<Timestamp> getObjectClass() {
            return Timestamp.class;
        }

        @Override
        public Timestamp bytesToObject(byte[] bytes) {
            long l = TypeConversion.bytesToLong(bytes, 2);
            int nanos = TypeConversion.bytesToInt(bytes, 10);
            Timestamp returnValue = new Timestamp(l);
            returnValue.setNanos(nanos);
            return returnValue;
        }

        @Override
        public byte[] objectToBytes(Object object) {
            Timestamp time = (Timestamp)object;
            long l = time.getTime();
            int nanos = time.getNanos();
            byte[] bytes = new byte[]{0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            TypeConversion.longToBytes(l, bytes, 2);
            TypeConversion.intToBytes(nanos, bytes, 10);
            return bytes;
        }
    }

    @Trivial
    public static final class SqlDateInfo
    implements BuiltinSerializationInfo<Date> {
        @Override
        public byte getIndex() {
            return 9;
        }

        @Override
        public Class<Date> getObjectClass() {
            return Date.class;
        }

        @Override
        public Date bytesToObject(byte[] bytes) {
            long l = TypeConversion.varIntBytesToLong(bytes, 2);
            return new Date(l);
        }

        @Override
        public byte[] objectToBytes(Object object) {
            long l = ((Date)object).getTime();
            byte[] bytes = new byte[]{0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            int numWritten = TypeConversion.writeLongAsVarIntBytes(l, bytes, 2);
            if (numWritten < 12) {
                byte[] smallArray = new byte[numWritten];
                System.arraycopy(bytes, 0, smallArray, 0, numWritten);
                return smallArray;
            }
            return bytes;
        }
    }

    @Trivial
    public static final class DateInfo
    implements BuiltinSerializationInfo<java.util.Date> {
        @Override
        public byte getIndex() {
            return 8;
        }

        @Override
        public Class<java.util.Date> getObjectClass() {
            return java.util.Date.class;
        }

        @Override
        public java.util.Date bytesToObject(byte[] bytes) {
            long l = TypeConversion.varIntBytesToLong(bytes, 2);
            return new java.util.Date(l);
        }

        @Override
        public byte[] objectToBytes(Object object) {
            long l = ((java.util.Date)object).getTime();
            byte[] bytes = new byte[]{0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            int numWritten = TypeConversion.writeLongAsVarIntBytes(l, bytes, 2);
            if (numWritten < 12) {
                byte[] smallArray = new byte[numWritten];
                System.arraycopy(bytes, 0, smallArray, 0, numWritten);
                return smallArray;
            }
            return bytes;
        }
    }

    @Trivial
    public static final class BooleanInfo
    implements BuiltinSerializationInfo<Boolean> {
        private static final byte[] TRUE_BYTES = new byte[]{0, 7, 1};
        private static final byte[] FALSE_BYTES = new byte[]{0, 7, 0};

        @Override
        public byte getIndex() {
            return 7;
        }

        @Override
        public Class<Boolean> getObjectClass() {
            return Boolean.class;
        }

        @Override
        public Boolean bytesToObject(byte[] bytes) {
            return bytes[2] == 0 ? Boolean.FALSE : Boolean.TRUE;
        }

        @Override
        public byte[] objectToBytes(Object object) {
            return (Boolean)object != false ? TRUE_BYTES : FALSE_BYTES;
        }
    }

    @Trivial
    public static final class CharacterInfo
    implements BuiltinSerializationInfo<Character> {
        @Override
        public byte getIndex() {
            return 6;
        }

        @Override
        public Class<Character> getObjectClass() {
            return Character.class;
        }

        @Override
        public Character bytesToObject(byte[] bytes) {
            return Character.valueOf(TypeConversion.bytesToChar(bytes, 2));
        }

        @Override
        public byte[] objectToBytes(Object object) {
            byte[] bytes = new byte[]{0, 6, 0, 0};
            TypeConversion.charToBytes(((Character)object).charValue(), bytes, 2);
            return bytes;
        }
    }

    @Trivial
    public static final class DoubleInfo
    implements BuiltinSerializationInfo<Double> {
        @Override
        public byte getIndex() {
            return 5;
        }

        @Override
        public Class<Double> getObjectClass() {
            return Double.class;
        }

        @Override
        public Double bytesToObject(byte[] bytes) {
            long doubleBits = TypeConversion.varIntBytesToLong(bytes, 2);
            return new Double(Double.longBitsToDouble(doubleBits));
        }

        @Override
        public byte[] objectToBytes(Object object) {
            double d = (Double)object;
            byte[] bytes = new byte[]{0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            int numWritten = TypeConversion.writeLongAsVarIntBytes(Double.doubleToLongBits(d), bytes, 2);
            if (numWritten < 12) {
                byte[] smallArray = new byte[numWritten];
                System.arraycopy(bytes, 0, smallArray, 0, numWritten);
                return smallArray;
            }
            return bytes;
        }
    }

    @Trivial
    public static final class FloatInfo
    implements BuiltinSerializationInfo<Float> {
        @Override
        public byte getIndex() {
            return 4;
        }

        @Override
        public Class<Float> getObjectClass() {
            return Float.class;
        }

        @Override
        public Float bytesToObject(byte[] bytes) {
            int floatBits = TypeConversion.varIntBytesToInt(bytes, 2);
            return new Float(Float.intBitsToFloat(floatBits));
        }

        @Override
        public byte[] objectToBytes(Object object) {
            float f = ((Float)object).floatValue();
            byte[] bytes = new byte[]{0, 4, 0, 0, 0, 0, 0};
            int numWritten = TypeConversion.writeIntAsVarIntBytes(Float.floatToIntBits(f), bytes, 2);
            if (numWritten < 7) {
                byte[] smallArray = new byte[numWritten];
                System.arraycopy(bytes, 0, smallArray, 0, numWritten);
                return smallArray;
            }
            return bytes;
        }
    }

    @Trivial
    public static final class ByteInfo
    implements BuiltinSerializationInfo<Byte> {
        @Override
        public byte getIndex() {
            return 3;
        }

        @Override
        public Class<Byte> getObjectClass() {
            return Byte.class;
        }

        @Override
        public Byte bytesToObject(byte[] bytes) {
            return bytes[2];
        }

        @Override
        public byte[] objectToBytes(Object object) {
            byte b = (Byte)object;
            return new byte[]{0, 3, b};
        }
    }

    @Trivial
    public static final class ShortInfo
    implements BuiltinSerializationInfo<Short> {
        @Override
        public byte getIndex() {
            return 2;
        }

        @Override
        public Class<Short> getObjectClass() {
            return Short.class;
        }

        @Override
        public Short bytesToObject(byte[] bytes) {
            return TypeConversion.bytesToShort(bytes, 2);
        }

        @Override
        public byte[] objectToBytes(Object object) {
            byte[] bytes = new byte[]{0, 2, 0, 0};
            TypeConversion.shortToBytes((Short)object, bytes, 2);
            return bytes;
        }
    }

    @Trivial
    public static final class IntegerInfo
    implements BuiltinSerializationInfo<Integer> {
        @Override
        public byte getIndex() {
            return 1;
        }

        @Override
        public Class<Integer> getObjectClass() {
            return Integer.class;
        }

        @Override
        public Integer bytesToObject(byte[] bytes) {
            return TypeConversion.varIntBytesToInt(bytes, 2);
        }

        @Override
        public byte[] objectToBytes(Object object) {
            byte[] bytes = new byte[]{0, 1, 0, 0, 0, 0, 0};
            int numWritten = TypeConversion.writeIntAsVarIntBytes((Integer)object, bytes, 2);
            if (numWritten < 7) {
                byte[] smallArray = new byte[numWritten];
                System.arraycopy(bytes, 0, smallArray, 0, numWritten);
                return smallArray;
            }
            return bytes;
        }
    }

    @Trivial
    public static final class LongInfo
    implements BuiltinSerializationInfo<Long> {
        @Override
        public byte getIndex() {
            return 0;
        }

        @Override
        public Class<Long> getObjectClass() {
            return Long.class;
        }

        @Override
        public Long bytesToObject(byte[] bytes) {
            return TypeConversion.varIntBytesToLong(bytes, 2);
        }

        @Override
        public byte[] objectToBytes(Object object) {
            byte[] bytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            int numWritten = TypeConversion.writeLongAsVarIntBytes((Long)object, bytes, 2);
            if (numWritten < 12) {
                byte[] smallArray = new byte[numWritten];
                System.arraycopy(bytes, 0, smallArray, 0, numWritten);
                return smallArray;
            }
            return bytes;
        }
    }
}

