/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.common;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIDataGraphException;
import com.ibm.websphere.sib.exception.SIDataGraphFormatMismatchException;
import com.ibm.websphere.sib.exception.SIDataGraphSchemaNotFoundException;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIMessageDomainNotSupportedException;
import com.ibm.websphere.sib.exception.SIMessageException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SINotSupportedException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.CommsConstants;
import com.ibm.ws.sib.comms.common.CATHandshakeProperties;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.jfapchannel.ConnectionInterface;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationUsageType;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.ReceivedData;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SICommandInvocationFailedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SIInsufficientDataForFactoryTypeException;
import com.ibm.wsspi.sib.core.exception.SIInvalidDestinationPrefixException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SIMessageNotLockedException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;

public abstract class JFAPCommunicator {
    private static String CLASS_NAME = JFAPCommunicator.class.getName();
    private static final TraceComponent tc = SibTr.register(JFAPCommunicator.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final String cellName = null;
    private static final int cellNameLengthInBuffer;
    private static final String nodeName;
    private static final int nodeNameLengthInBuffer;
    private static final String serverName;
    private static final int serverNameLengthInBuffer;
    private static final String clusterName;
    private static final int clusterNameLengthInBuffer;
    private Conversation con = null;

    protected Conversation getConversation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConversation");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConversation", (Object)this.con);
        }
        return this.con;
    }

    protected void setConversation(Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setConversation", (Object)conversation);
        }
        this.con = conversation;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setConversation");
        }
    }

    protected abstract int getConnectionObjectID();

    protected abstract void setConnectionObjectID(int var1);

    protected abstract CommsConnection getCommsConnection();

    protected abstract void setCommsConnection(CommsConnection var1);

    protected abstract CommsByteBuffer getCommsByteBuffer();

    protected abstract int getRequestNumber();

    protected CommsByteBuffer getCommsByteBuffer(ReceivedData rcvData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCommsByteBuffer", (Object)rcvData);
        }
        CommsByteBuffer buff = this.getCommsByteBuffer();
        buff.reset(rcvData);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCommsByteBuffer", (Object)buff);
        }
        return buff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommsByteBuffer jfapExchange(CommsByteBuffer buffer, int sendSegmentType, int priority, boolean canPoolOnReceive) throws SIConnectionDroppedException, SIConnectionLostException {
        CommsByteBuffer rcvBuffer;
        boolean success;
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"jfapExchange", (Object)new Object[]{buffer, sendSegmentType, priority, canPoolOnReceive});
            }
            success = false;
            rcvBuffer = null;
            try {
                if (buffer == null) {
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("NULL_DATA_LIST_PASSED_IN_SICO1046", null, null));
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".JFAPExchange"), (String)"5-001-0001", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
                    }
                    throw e;
                }
                int reqNum = this.getRequestNumber();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("About to Exchange segment conversation: " + this.con + " " + JFapChannelConstants.getSegmentName(sendSegmentType) + " - " + sendSegmentType + " (0x" + Integer.toHexString(sendSegmentType) + ") using request number " + reqNum));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)this.con.getFullSummary());
                }
                ReceivedData rd = this.con.exchange(buffer, sendSegmentType, reqNum, priority, canPoolOnReceive);
                rcvBuffer = this.getCommsByteBuffer(rd);
                int rcvSegmentType = rcvBuffer.getReceivedDataSegmentType();
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Exchange completed successfully. Segment returned " + JFapChannelConstants.getSegmentName(rcvSegmentType) + " - " + rcvSegmentType + " (0x" + Integer.toHexString(rcvSegmentType) + ")"));
            }
            catch (Throwable throwable) {
                if (!success && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exchange failed.");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"jfapExchange", rcvBuffer);
                }
                throw throwable;
            }
        }
        if (!(success = true) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exchange failed.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"jfapExchange", (Object)rcvBuffer);
        }
        return rcvBuffer;
    }

    protected void jfapSend(CommsByteBuffer buffer, int sendSegType, int priority, boolean canPoolOnReceive, Conversation.ThrottlingPolicy throttlingPolicy) throws SIConnectionDroppedException, SIConnectionLostException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"jfapSend", (Object)new Object[]{buffer, sendSegType, priority, canPoolOnReceive});
        }
        if (buffer == null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("NULL_DATA_LIST_PASSED_IN_SICO1046", null, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".JFAPSend"), (String)"5-001-0002", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
            }
            throw e;
        }
        int reqNum = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("About to Send segment conversation: " + this.con + " " + JFapChannelConstants.getSegmentName(sendSegType) + " - " + sendSegType + " (0x" + Integer.toHexString(sendSegType) + ") using request number " + reqNum));
            SibTr.debug((Object)this, (TraceComponent)tc, (String)this.con.getFullSummary());
        }
        this.con.send(buffer, sendSegType, reqNum, priority, canPoolOnReceive, throttlingPolicy, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"jfapSend");
        }
    }

    protected abstract void createConversationState();

    protected abstract void initiateCommsHandshaking() throws SIConnectionLostException, SIConnectionDroppedException;

    protected void initiateCommsHandshakingImpl(boolean serverMode) throws SIConnectionLostException, SIConnectionDroppedException {
        this.initiateCommsHandshakingImpl(serverMode, ConversationUsageType.JFAP);
    }

    protected void initiateCommsHandshakingImpl(boolean serverMode, ConversationUsageType usageType) throws SIConnectionLostException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initiateCommsHandshakingImpl", (Object)new Object[]{serverMode, usageType});
        }
        CATHandshakeProperties handshakeProperties = new CATHandshakeProperties();
        String connectionInfo = "Unknown";
        CommsConnection cConn = this.getCommsConnection();
        if (cConn != null) {
            connectionInfo = cConn.getConnectionInfo();
        }
        short capabilities = this.getClientCapabilities();
        short heartBeatInterval = (short)CommsUtils.getRuntimeIntProperty("sib.comms.HeartbeatInterval", "" + this.getConversation().getHeartbeatInterval());
        short heartBeatTimeout = (short)CommsUtils.getRuntimeIntProperty("sib.comms.HeartbeatTimeout", "" + this.getConversation().getHeartbeatTimeout());
        short currentFapLevel = (short)CommsUtils.getRuntimeIntProperty("sib.comms.ClientFapLevel", "20");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Client is FAP Level: " + currentFapLevel));
        }
        CommsByteBuffer hBuf = this.getCommsByteBuffer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"----- Sending the following handshake data ------");
        }
        if (serverMode) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)" Handshake type    : ME");
            }
            hBuf.put((byte)2);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)" Handshake type    : CLIENT");
            }
            hBuf.put((byte)1);
        }
        byte productMajor = 6;
        byte productMinor = 0;
        hBuf.putShort((short)1);
        hBuf.putShort(2);
        hBuf.put(productMajor);
        hBuf.put(productMinor);
        handshakeProperties.setMajorVersion(productMajor);
        handshakeProperties.setMinorVersion(productMinor);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Product Version   : " + productMajor + "." + productMinor));
        }
        hBuf.putShort((short)2);
        hBuf.putShort(2);
        hBuf.putShort(currentFapLevel);
        handshakeProperties.setFapLevel(currentFapLevel);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)(" FAP Version       : " + currentFapLevel));
        }
        hBuf.putShort((short)3);
        hBuf.putShort(8);
        hBuf.putLong(10000L);
        handshakeProperties.setMaxMessageSize(10000L);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)" Max Msg Size      : 10000");
        }
        hBuf.putShort((short)4);
        hBuf.putShort(4);
        hBuf.putInt(10000);
        handshakeProperties.setMaxTransmissionSize(10000);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)" Max Tx Size       : 10000");
        }
        hBuf.putShort((short)5);
        hBuf.putShort(2);
        hBuf.putShort(heartBeatInterval);
        handshakeProperties.setHeartbeatInterval(heartBeatInterval);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Heartbeat Interval: " + heartBeatInterval));
        }
        if (currentFapLevel >= 5) {
            hBuf.putShort((short)13);
            hBuf.putShort(2);
            hBuf.putShort(heartBeatTimeout);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Heartbeat Timeout : " + heartBeatTimeout));
            }
        }
        handshakeProperties.setHeartbeatTimeout(heartBeatTimeout);
        hBuf.putShort((short)7);
        hBuf.putShort(2);
        hBuf.putShort(capabilities);
        handshakeProperties.setCapabilites(capabilities);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Capabilities      : 0x" + Integer.toHexString(capabilities)));
        }
        hBuf.putShort((short)11);
        hBuf.putShort(2);
        hBuf.putShort((short)1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Product Id        : 0x" + Integer.toHexString(1)));
        }
        if (currentFapLevel >= 3) {
            byte[] fapBitmap = new byte[32];
            StringBuffer supportedFapLevels = null;
            for (int i = 255; i >= 0; --i) {
                boolean bitIsOn = CommsConstants.isFapLevelSupported((int)(i + 1));
                if (!bitIsOn) continue;
                int byteOffset = (255 - i) / 8;
                int bitOffset = i % 8;
                byte bitSet = (byte)(1 << bitOffset);
                int n = byteOffset;
                fapBitmap[n] = (byte)(fapBitmap[n] | bitSet);
                if (supportedFapLevels == null) {
                    supportedFapLevels = new StringBuffer();
                    supportedFapLevels.append(i + 1);
                    continue;
                }
                supportedFapLevels.append(", ");
                supportedFapLevels.append(i + 1);
            }
            hBuf.putShort((short)12);
            hBuf.putShort(fapBitmap.length);
            hBuf.put(fapBitmap);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Supported FAP's   : " + supportedFapLevels));
            }
        }
        if (usageType != ConversationUsageType.JFAP) {
            hBuf.putShort((short)14);
            hBuf.putShort(4);
            usageType.serialize(hBuf);
        }
        if (cellName != null && cellNameLengthInBuffer <= Short.MAX_VALUE) {
            hBuf.putShort((short)15);
            hBuf.putShort(cellNameLengthInBuffer);
            hBuf.putString(cellName);
        }
        if (nodeName != null && nodeNameLengthInBuffer <= Short.MAX_VALUE) {
            hBuf.putShort((short)16);
            hBuf.putShort(nodeNameLengthInBuffer);
            hBuf.putString(nodeName);
        }
        if (serverName != null && serverNameLengthInBuffer <= Short.MAX_VALUE) {
            hBuf.putShort((short)17);
            hBuf.putShort(serverNameLengthInBuffer);
            hBuf.putString(serverName);
        }
        if (clusterName != null && clusterNameLengthInBuffer <= Short.MAX_VALUE) {
            hBuf.putShort((short)18);
            hBuf.putShort(clusterNameLengthInBuffer);
            hBuf.putString(clusterName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"----- End of handshake data ---------------------");
        }
        CommsByteBuffer buf = this.jfapExchange(hBuf, 6, 7, true);
        try {
            short err = buf.getCommandCompletionCode(6);
            if (err != 0) {
                this.checkFor_SIConnectionDroppedException(buf, err);
                this.checkFor_SIConnectionLostException(buf, err);
                this.defaultChecker(buf, err);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"----- Received the following handshake data -----");
            }
            byte connectionType = buf.get();
            if (serverMode && connectionType != 2 || !serverMode && connectionType != 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unexpected connection type returned!", (Object)Byte.toString(connectionType));
                }
                throw new SIConnectionLostException(nls.getFormattedMessage("UNABLE_TO_NEGOTIATE_CONNECTION_SICO1023", new Object[]{connectionInfo}, null));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (serverMode) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)" Handshake type    : ME");
                } else {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)" Handshake type    : CLIENT");
                }
            }
            block16: while (buf.hasRemaining()) {
                short fieldId = buf.getShort();
                switch (fieldId) {
                    case 1: {
                        short productVersionFieldLength = buf.getShort();
                        if (productVersionFieldLength != 2) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Invalid product version length: " + productVersionFieldLength));
                            }
                            throw new SIConnectionLostException(nls.getFormattedMessage("UNABLE_TO_NEGOTIATE_CONNECTION_SICO1023", new Object[]{connectionInfo}, null));
                        }
                        byte upperProductVersion = buf.get();
                        byte lowerProductVersion = buf.get();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Product Version   : " + upperProductVersion + "." + lowerProductVersion));
                        }
                        handshakeProperties.setMajorVersion(upperProductVersion);
                        handshakeProperties.setMinorVersion(lowerProductVersion);
                        continue block16;
                    }
                    case 2: {
                        short fapLevelFieldLength = buf.getShort();
                        if (fapLevelFieldLength != 2) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Invalid FAP Field length: " + fapLevelFieldLength));
                            }
                            throw new SIConnectionLostException(nls.getFormattedMessage("UNABLE_TO_NEGOTIATE_CONNECTION_SICO1023", new Object[]{connectionInfo}, null));
                        }
                        short fapLevel = buf.getShort();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)(" FAP Version       : " + fapLevel));
                        }
                        if (fapLevel > currentFapLevel) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("FAP level returned (" + fapLevel + ") is greater than the requested FAP level (" + currentFapLevel + ")"));
                            }
                            throw new SIConnectionLostException(nls.getFormattedMessage("UNABLE_TO_NEGOTIATE_CONNECTION_SICO1023", new Object[]{connectionInfo}, null));
                        }
                        if (!CommsConstants.isFapLevelSupported((int)fapLevel)) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("FAP level returned (" + fapLevel + ") is not supported"));
                            }
                            throw new SIConnectionLostException(nls.getFormattedMessage("UNABLE_TO_NEGOTIATE_CONNECTION_SICO1023", new Object[]{connectionInfo}, null));
                        }
                        handshakeProperties.setFapLevel(fapLevel);
                        continue block16;
                    }
                    case 3: {
                        short maxMessageFieldLength = buf.getShort();
                        if (maxMessageFieldLength != 8) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Invalid Max Message Field length: " + maxMessageFieldLength));
                            }
                            throw new SIConnectionLostException(nls.getFormattedMessage("UNABLE_TO_NEGOTIATE_CONNECTION_SICO1023", new Object[]{connectionInfo}, null));
                        }
                        long maxMessageSize = buf.getLong();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Max Msg Size      : " + maxMessageSize));
                        }
                        handshakeProperties.setMaxMessageSize(Math.min(maxMessageSize, 10000L));
                        continue block16;
                    }
                    case 4: {
                        short maxTransmissionLength = buf.getShort();
                        if (maxTransmissionLength != 4) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Invalid Max Transmission Field length: " + maxTransmissionLength));
                            }
                            throw new SIConnectionLostException(nls.getFormattedMessage("UNABLE_TO_NEGOTIATE_CONNECTION_SICO1023", new Object[]{connectionInfo}, null));
                        }
                        int maxTransmissionSize = buf.getInt();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Max Tx Size       : " + maxTransmissionSize));
                        }
                        handshakeProperties.setMaxTransmissionSize(Math.min(maxTransmissionSize, 10000));
                        continue block16;
                    }
                    case 5: {
                        short heartbeatFieldLength = buf.getShort();
                        if (heartbeatFieldLength != 2) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Invalid Heartbeat Interval Field length: " + heartbeatFieldLength));
                            }
                            throw new SIConnectionLostException(nls.getFormattedMessage("UNABLE_TO_NEGOTIATE_CONNECTION_SICO1023", new Object[]{connectionInfo}, null));
                        }
                        short heartbeatInterval = buf.getShort();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Heartbeat Interval: " + heartbeatInterval));
                        }
                        handshakeProperties.setHeartbeatInterval(heartbeatInterval);
                        continue block16;
                    }
                    case 13: {
                        short heartbeatTimeoutFieldLength = buf.getShort();
                        if (heartbeatTimeoutFieldLength != 2) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Invalid Heartbeat Timeout Field length: " + heartbeatTimeoutFieldLength));
                            }
                            throw new SIConnectionLostException(nls.getFormattedMessage("UNABLE_TO_NEGOTIATE_CONNECTION_SICO1023", new Object[]{connectionInfo}, null));
                        }
                        short heartbeatTimeout = buf.getShort();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Heartbeat Timeout : " + heartbeatTimeout));
                        }
                        handshakeProperties.setHeartbeatTimeout(heartbeatTimeout);
                        continue block16;
                    }
                    case 7: {
                        short capabilityInterval = buf.getShort();
                        if (capabilityInterval != 2) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Invalid Capability Field length: " + capabilityInterval));
                            }
                            throw new SIConnectionLostException(nls.getFormattedMessage("UNABLE_TO_NEGOTIATE_CONNECTION_SICO1023", new Object[]{connectionInfo}, null));
                        }
                        short capability = buf.getShort();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Capabilities      : " + capability));
                        }
                        handshakeProperties.setCapabilites(capability);
                        continue block16;
                    }
                    case 11: {
                        short productIdLength = buf.getShort();
                        if (productIdLength != 2) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Invalid Product Id Field length: " + productIdLength));
                            }
                            throw new SIConnectionLostException(nls.getFormattedMessage("UNABLE_TO_NEGOTIATE_CONNECTION_SICO1023", new Object[]{connectionInfo}, null));
                        }
                        short productId = buf.getShort();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)(" Server Product Id : " + productId));
                        }
                        handshakeProperties.setPeerProductId(productId);
                        continue block16;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)" ** Unknown Parameter received: **");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Field Id: " + fieldId));
                }
                SIConnectionLostException e = new SIConnectionLostException(nls.getFormattedMessage("INVALID_PROP_SICO8009", new Object[]{"" + fieldId}, null));
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".initiateHandshaking"), (String)"5-001-0005", (Object)this);
                throw e;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"----- End of handshake data ---------------------");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Handshake properties:", (Object)handshakeProperties);
            }
            this.getConversation().setHeartbeatInterval(handshakeProperties.getHeartbeatInterval());
            this.getConversation().setHeartbeatTimeout(handshakeProperties.getHeartbeatTimeout());
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".initiateHandshaking"), (String)"5-001-0004", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SIException", (Object)((Object)e));
            }
            throw new SIConnectionLostException(nls.getFormattedMessage("UNKNOWN_CORE_EXCP_SICO8002", new Object[]{e}, null), (Throwable)e);
        }
        finally {
            if (buf != null) {
                buf.release();
            }
        }
        if (usageType.requiresNormalHandshakeProcessing()) {
            this.getConversation().setHandshakeProperties(handshakeProperties);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initiateCommsHandshakingImpl");
        }
    }

    private short getClientCapabilities() {
        boolean disableOptimizedTx;
        boolean jmsMessagesOnly;
        boolean jmfMessagesOnly;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getClientCapabilities");
        }
        short capabilities = 71;
        boolean nonJavaBootstrap = CommsUtils.getRuntimeBooleanProperty("sib.client.NonJavaBootstrap", CommsConstants.CAPABILITIY_REQUIRES_NONJAVA_BOOTSTRAP_DEF);
        if (nonJavaBootstrap) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Requesting non-java bootstrap");
            }
            capabilities = (short)(capabilities | 8);
        }
        if (jmfMessagesOnly = CommsUtils.getRuntimeBooleanProperty("sib.client.JMSOnly", CommsConstants.CAPABILITIY_REQUIRES_JMF_ENCODING_DEF)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Requesting JMF Only");
            }
            capabilities = (short)(capabilities | 0x20);
        }
        if (jmsMessagesOnly = CommsUtils.getRuntimeBooleanProperty("sib.client.JMFOnly", CommsConstants.CAPABILITIY_REQUIRES_JMS_MESSAGES_DEF)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Requesting JMS Only");
            }
            capabilities = (short)(capabilities | 0x10);
        }
        if (disableOptimizedTx = CommsUtils.getRuntimeBooleanProperty("sib.comms.DisableOptimizedTransactions", "false")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Disabling use of optimized transactions");
            }
            capabilities = (short)(capabilities & 0xFFBF);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getClientCapabilities", (Object)capabilities);
        }
        return capabilities;
    }

    public void checkFor_SIIncorrectCallException(CommsByteBuffer buffer, short exceptionCode) throws SIIncorrectCallException {
        if (exceptionCode == 2) {
            throw (SIIncorrectCallException)((Object)buffer.getException(this.con));
        }
    }

    public void checkFor_SIInvalidDestinationPrefixException(CommsByteBuffer buffer, short exceptionCode) throws SIInvalidDestinationPrefixException {
        if (exceptionCode == 3) {
            throw (SIInvalidDestinationPrefixException)buffer.getException(this.con);
        }
    }

    public void checkFor_SIDiscriminatorSyntaxException(CommsByteBuffer buffer, short exceptionCode) throws SIDiscriminatorSyntaxException {
        if (exceptionCode == 4) {
            throw (SIDiscriminatorSyntaxException)buffer.getException(this.con);
        }
    }

    public void checkFor_SISelectorSyntaxException(CommsByteBuffer buffer, short exceptionCode) throws SISelectorSyntaxException {
        if (exceptionCode == 5) {
            throw (SISelectorSyntaxException)buffer.getException(this.con);
        }
    }

    public void checkFor_SIInsufficientDataForFactoryTypeException(CommsByteBuffer buffer, short exceptionCode) throws SIInsufficientDataForFactoryTypeException {
        if (exceptionCode == 6) {
            throw (SIInsufficientDataForFactoryTypeException)buffer.getException(this.con);
        }
    }

    public void checkFor_SIAuthenticationException(CommsByteBuffer buffer, short exceptionCode) throws SIAuthenticationException {
        if (exceptionCode == 7) {
            throw (SIAuthenticationException)buffer.getException(this.con);
        }
    }

    public void checkFor_SINotPossibleInCurrentConfigurationException(CommsByteBuffer buffer, short exceptionCode) throws SINotPossibleInCurrentConfigurationException {
        if (exceptionCode == 8) {
            throw (SINotPossibleInCurrentConfigurationException)buffer.getException(this.con);
        }
    }

    public void checkFor_SINotAuthorizedException(CommsByteBuffer buffer, short exceptionCode) throws SINotAuthorizedException {
        if (exceptionCode == 9) {
            throw (SINotAuthorizedException)buffer.getException(this.con);
        }
    }

    public void checkFor_SISessionUnavailableException(CommsByteBuffer buffer, short exceptionCode) throws SISessionUnavailableException {
        if (exceptionCode == 10) {
            throw (SISessionUnavailableException)buffer.getException(this.con);
        }
    }

    public void checkFor_SISessionDroppedException(CommsByteBuffer buffer, short exceptionCode) throws SISessionDroppedException {
        if (exceptionCode == 11) {
            throw (SISessionDroppedException)buffer.getException(this.con);
        }
    }

    public void checkFor_SIDurableSubscriptionAlreadyExistsException(CommsByteBuffer buffer, short exceptionCode) throws SIDurableSubscriptionAlreadyExistsException {
        if (exceptionCode == 12) {
            throw (SIDurableSubscriptionAlreadyExistsException)buffer.getException(this.con);
        }
    }

    public void checkFor_SIDurableSubscriptionMismatchException(CommsByteBuffer buffer, short exceptionCode) throws SIDurableSubscriptionMismatchException {
        if (exceptionCode == 13) {
            throw (SIDurableSubscriptionMismatchException)buffer.getException(this.con);
        }
    }

    public void checkFor_SIDurableSubscriptionNotFoundException(CommsByteBuffer buffer, short exceptionCode) throws SIDurableSubscriptionNotFoundException {
        if (exceptionCode == 14) {
            throw (SIDurableSubscriptionNotFoundException)buffer.getException(this.con);
        }
    }

    public void checkFor_SIConnectionUnavailableException(CommsByteBuffer buffer, short exceptionCode) throws SIConnectionUnavailableException {
        if (exceptionCode == 15) {
            throw (SIConnectionUnavailableException)buffer.getException(this.con);
        }
    }

    public void checkFor_SIConnectionDroppedException(CommsByteBuffer buffer, short exceptionCode) throws SIConnectionDroppedException {
        if (exceptionCode == 16) {
            throw (SIConnectionDroppedException)((Object)buffer.getException(this.con));
        }
    }

    public void checkFor_SIDataGraphFormatMismatchException(CommsByteBuffer buffer, short exceptionCode) throws SIDataGraphFormatMismatchException {
        if (exceptionCode == 17) {
            throw (SIDataGraphFormatMismatchException)buffer.getException(this.con);
        }
    }

    public void checkFor_SIDataGraphSchemaNotFoundException(CommsByteBuffer buffer, short exceptionCode) throws SIDataGraphSchemaNotFoundException {
        if (exceptionCode == 18) {
            throw (SIDataGraphSchemaNotFoundException)buffer.getException(this.con);
        }
    }

    public void checkFor_SIDestinationLockedException(CommsByteBuffer buffer, short exceptionCode) throws SIDestinationLockedException {
        if (exceptionCode == 19) {
            throw (SIDestinationLockedException)buffer.getException(this.con);
        }
    }

    public void checkFor_SITemporaryDestinationNotFoundException(CommsByteBuffer buffer, short exceptionCode) throws SITemporaryDestinationNotFoundException {
        if (exceptionCode == 20) {
            throw (SITemporaryDestinationNotFoundException)((Object)buffer.getException(this.con));
        }
    }

    public void checkFor_SIMessageException(CommsByteBuffer buffer, short exceptionCode) throws SIMessageException {
        if (exceptionCode == 21) {
            throw (SIMessageException)buffer.getException(this.con);
        }
    }

    public void checkFor_SIResourceException(CommsByteBuffer buffer, short exceptionCode) throws SIResourceException {
        if (exceptionCode == 22) {
            throw (SIResourceException)((Object)buffer.getException(this.con));
        }
    }

    public void checkFor_SILimitExceededException(CommsByteBuffer buffer, short exceptionCode) throws SILimitExceededException {
        if (exceptionCode == 23) {
            throw (SILimitExceededException)buffer.getException(this.con);
        }
    }

    public void checkFor_SIConnectionLostException(CommsByteBuffer buffer, short exceptionCode) throws SIConnectionLostException {
        if (exceptionCode == 24) {
            throw (SIConnectionLostException)((Object)buffer.getException(this.con));
        }
    }

    public void checkFor_SIRollbackException(CommsByteBuffer buffer, short exceptionCode) throws SIRollbackException {
        if (exceptionCode == 25) {
            throw (SIRollbackException)buffer.getException(this.con);
        }
    }

    public void checkFor_SINotSupportedException(CommsByteBuffer buffer, short exceptionCode) throws SINotSupportedException {
        if (exceptionCode == 26) {
            throw (SINotSupportedException)buffer.getException(this.con);
        }
    }

    public void checkFor_SIMessageDomainNotSupportedException(CommsByteBuffer buffer, short exceptionCode) throws SIMessageDomainNotSupportedException {
        if (exceptionCode == 27) {
            throw (SIMessageDomainNotSupportedException)buffer.getException(this.con);
        }
    }

    public void checkFor_SIDataGraphCreationException(CommsByteBuffer buffer, short exceptionCode) throws SIDataGraphException {
        if (exceptionCode == 28) {
            throw (SIDataGraphException)buffer.getException(this.con);
        }
    }

    public void checkFor_SIErrorException(CommsByteBuffer buffer, short exceptionCode) throws SIErrorException {
        if (exceptionCode == 29) {
            throw (SIErrorException)buffer.getException(this.con);
        }
    }

    public void checkFor_SICommandInvocationFailedException(CommsByteBuffer buffer, short exceptionCode) throws SICommandInvocationFailedException {
        if (exceptionCode == 30) {
            throw (SICommandInvocationFailedException)buffer.getException(this.con);
        }
    }

    public void checkFor_SIMessageNotLockedException(CommsByteBuffer buffer, short exceptionCode) throws SIMessageNotLockedException {
        if (exceptionCode == 31) {
            throw (SIMessageNotLockedException)((Object)buffer.getException(this.con));
        }
    }

    public void defaultChecker(CommsByteBuffer buffer, short exceptionCode) throws SIErrorException {
        if (exceptionCode != 0) {
            throw new SIErrorException((Throwable)buffer.getException(this.con));
        }
    }

    protected void invalidateConnection(boolean notifyPeer, Throwable throwable, String debugReason) {
        ConnectionInterface connection;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"invalidateConnection", (Object)new Object[]{new Boolean(notifyPeer), throwable, debugReason});
        }
        if (this.con != null && (connection = this.con.getConnectionReference()) != null) {
            connection.invalidate(notifyPeer, throwable, debugReason);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"invalidateConnection");
        }
    }

    static {
        nodeName = null;
        serverName = null;
        clusterName = null;
        cellNameLengthInBuffer = CommsByteBuffer.calculateEncodedStringLength(cellName);
        nodeNameLengthInBuffer = CommsByteBuffer.calculateEncodedStringLength(nodeName);
        serverNameLengthInBuffer = CommsByteBuffer.calculateEncodedStringLength(serverName);
        clusterNameLengthInBuffer = CommsByteBuffer.calculateEncodedStringLength(clusterName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("cellName: " + cellName));
            SibTr.debug((TraceComponent)tc, (String)("cellNameLengthInBuffer: " + cellNameLengthInBuffer));
            SibTr.debug((TraceComponent)tc, (String)("nodeName: " + nodeName));
            SibTr.debug((TraceComponent)tc, (String)("nodeNameLengthInBuffer: " + nodeNameLengthInBuffer));
            SibTr.debug((TraceComponent)tc, (String)("serverName: " + serverName));
            SibTr.debug((TraceComponent)tc, (String)("serverNameLengthInBuffer: " + serverNameLengthInBuffer));
            SibTr.debug((TraceComponent)tc, (String)("clusterName: " + clusterName));
            SibTr.debug((TraceComponent)tc, (String)("clusterNameLengthInBuffer: " + clusterNameLengthInBuffer));
        }
    }
}

