/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBufferPool;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.jfapchannel.impl.TransmissionDataIterator;
import com.ibm.ws.sib.utils.ras.SibTr;

public class TransmissionData {
    private static final TraceComponent tc = SibTr.register(TransmissionData.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private WsByteBuffer[] xmitDataBuffers;
    private int currentXmitDataBufferIndex;
    private Connection connection;
    private Conversation conversation;
    private SendListener sendListener;
    private boolean isUserRequest;
    private boolean isTerminal;
    private WsByteBuffer headerScratchSpace;
    private int transmissionRemaining;
    private static final int STATE_BUILDING_PRIMARY_HEADER = 0;
    private static final int STATE_BUILDING_CONVERSATION_HEADER = 1;
    private static final int STATE_BUILDING_SEGMENT_HEADER = 2;
    private static final int STATE_BUILDING_PAYLOAD = 3;
    private static final int STATE_ERROR = 4;
    private int state = 0;
    private boolean exhausedXmitBuffer = false;
    private boolean transmissionBuilt = false;
    private TransmissionDataIterator iterator = null;
    private JFapChannelConstants.TransmissionLayout layout;
    private PrimaryHeaderFields primaryHeaderFields = new PrimaryHeaderFields();
    private ConversationHeaderFields conversationHeaderFields = new ConversationHeaderFields();
    private SegmentedTransmissionHeaderFields segmentedTransmissionHeaderFields = new SegmentedTransmissionHeaderFields();

    protected TransmissionData(TransmissionDataIterator iterator) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.iterator = iterator;
        int sizeofLargestHeader = Math.max(10, 4);
        sizeofLargestHeader = Math.max(sizeofLargestHeader, 12);
        this.headerScratchSpace = WsByteBufferPool.getInstance().allocate(sizeofLargestHeader);
        this.headerScratchSpace.clear();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    protected void reset(JFapByteBuffer jfapBuffer, boolean isTerminal, Connection connection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reset", (Object)new Object[]{jfapBuffer, "" + isTerminal, connection});
        }
        this.isTerminal = isTerminal;
        this.connection = connection;
        this.xmitDataBuffers = jfapBuffer.getBuffersForTransmission();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reset");
        }
    }

    protected void setLayoutToPrimary(int segmentLength, int priority, boolean isPooled, boolean isExchange, int packetNumber, int segmentType, SendListener sendListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setLayoutToPrimary", (Object)new Object[]{"" + segmentLength, "" + priority, "" + isPooled, "" + isExchange, "" + packetNumber, "" + segmentType, sendListener});
        }
        this.primaryHeaderFields.segmentLength = segmentLength;
        this.primaryHeaderFields.priority = priority;
        this.primaryHeaderFields.isPooled = isPooled;
        this.primaryHeaderFields.isExchange = isExchange;
        this.primaryHeaderFields.packetNumber = packetNumber;
        this.primaryHeaderFields.segmentType = segmentType;
        this.sendListener = sendListener;
        this.transmissionRemaining = segmentLength;
        this.layout = JFapChannelConstants.XMIT_PRIMARY_ONLY;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setLayoutToPrimary");
        }
    }

    protected void setLayoutToConversation(int segmentLength, int priority, boolean isPooled, boolean isExchange, int packetNumber, int segmentType, int conversationId, int requestNumber, Conversation conversation, SendListener sendListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setLayoutToConversation", (Object)new Object[]{"" + segmentLength, "" + priority, "" + isPooled, "" + isExchange, "" + packetNumber, "" + segmentType, "" + conversationId, "" + requestNumber, conversation, sendListener});
        }
        this.setLayoutToPrimary(segmentLength, priority, isPooled, isExchange, packetNumber, segmentType, sendListener);
        this.conversationHeaderFields.conversationId = conversationId;
        this.conversationHeaderFields.requestNumber = requestNumber;
        this.conversation = conversation;
        this.transmissionRemaining = segmentLength;
        this.layout = JFapChannelConstants.XMIT_CONVERSATION;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setLayoutToConversation");
        }
    }

    protected void setLayoutToStartSegment(int segmentLength, int priority, boolean isPooled, boolean isExchange, int packetNumber, int segmentType, int conversationId, int requestNumber, long totalLength) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setLayoutToStartSegment", (Object)new Object[]{"" + segmentLength, "" + priority, "" + isPooled, "" + isExchange, "" + packetNumber, "" + segmentType, "" + conversationId, "" + requestNumber, "" + totalLength});
        }
        this.setLayoutToConversation(segmentLength, priority, isPooled, isExchange, packetNumber, segmentType, conversationId, requestNumber, null, null);
        this.segmentedTransmissionHeaderFields.totalLength = totalLength;
        this.segmentedTransmissionHeaderFields.segmentType = segmentType;
        this.transmissionRemaining = segmentLength;
        this.primaryHeaderFields.segmentType = 3;
        this.layout = JFapChannelConstants.XMIT_SEGMENT_START;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setLayoutToStartSegment");
        }
    }

    protected void setLayoutToMiddleSegment(int segmentLength, int priority, boolean isPooled, boolean isExchange, int packetNumber, int conversationId, int requestNumber) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setLayoutToMiddleSegment", (Object)new Object[]{"" + segmentLength, "" + priority, "" + isPooled, "" + isExchange, "" + packetNumber, "" + conversationId, "" + requestNumber});
        }
        this.setLayoutToConversation(segmentLength, priority, isPooled, isExchange, packetNumber, 4, conversationId, requestNumber, null, null);
        this.layout = JFapChannelConstants.XMIT_SEGMENT_MIDDLE;
        this.transmissionRemaining = segmentLength;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setLayoutToMiddleSegment");
        }
    }

    protected void setLayoutToEndSegment(int segmentLength, int priority, boolean isPooled, boolean isExchange, int packetNumber, int conversationId, int requestNumber, Conversation conversation, SendListener sendListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setLayoutToSegmentEnd", (Object)new Object[]{"" + segmentLength, "" + priority, "" + isPooled, "" + isExchange, "" + packetNumber, "" + conversationId, "" + requestNumber, conversation, sendListener});
        }
        this.setLayoutToConversation(segmentLength, priority, isPooled, isExchange, packetNumber, 5, conversationId, requestNumber, conversation, sendListener);
        this.layout = JFapChannelConstants.XMIT_SEGMENT_END;
        this.transmissionRemaining = segmentLength;
    }

    boolean buildTransmission(WsByteBuffer xmitBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"buildTransmission", (Object)xmitBuffer);
        }
        SIErrorException error = null;
        block7: while (!this.exhausedXmitBuffer && !this.transmissionBuilt && error == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("state=" + this.state + " layout=" + this.layout));
            }
            switch (this.state) {
                case 0: {
                    if (!this.buildHeader(this.primaryHeaderFields, xmitBuffer)) continue block7;
                    if (this.layout == JFapChannelConstants.XMIT_PRIMARY_ONLY) {
                        this.state = 3;
                        continue block7;
                    }
                    if (this.layout == JFapChannelConstants.XMIT_CONVERSATION) {
                        this.state = 1;
                        continue block7;
                    }
                    if (this.layout == JFapChannelConstants.XMIT_SEGMENT_START) {
                        this.state = 1;
                        continue block7;
                    }
                    if (this.layout == JFapChannelConstants.XMIT_SEGMENT_MIDDLE) {
                        this.state = 1;
                        continue block7;
                    }
                    if (this.layout == JFapChannelConstants.XMIT_SEGMENT_END) {
                        this.state = 1;
                        continue block7;
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("unexpected layout: " + this.layout + " in state: " + this.state));
                    }
                    this.state = 4;
                    error = new SIErrorException("unexpected layout: " + this.layout + " in state: " + this.state);
                    continue block7;
                }
                case 1: {
                    if (!this.buildHeader(this.conversationHeaderFields, xmitBuffer)) continue block7;
                    if (this.layout == JFapChannelConstants.XMIT_CONVERSATION) {
                        this.state = 3;
                        continue block7;
                    }
                    if (this.layout == JFapChannelConstants.XMIT_SEGMENT_START) {
                        this.state = 2;
                        continue block7;
                    }
                    if (this.layout == JFapChannelConstants.XMIT_SEGMENT_MIDDLE) {
                        this.state = 3;
                        continue block7;
                    }
                    if (this.layout == JFapChannelConstants.XMIT_SEGMENT_END) {
                        this.state = 3;
                        continue block7;
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("unexpected layout: " + this.layout + " in state: " + this.state));
                    }
                    this.state = 4;
                    error = new SIErrorException("unexpected layout: " + this.layout + " in state: " + this.state);
                    continue block7;
                }
                case 2: {
                    if (!this.buildHeader(this.segmentedTransmissionHeaderFields, xmitBuffer)) continue block7;
                    if (this.layout == JFapChannelConstants.XMIT_SEGMENT_START) {
                        this.state = 3;
                        continue block7;
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("unexpected layout: " + this.layout + " in state: " + this.state));
                    }
                    this.state = 4;
                    error = new SIErrorException("unexpected layout: " + this.layout + " in state: " + this.state);
                    continue block7;
                }
                case 3: {
                    if (!this.buildPayload(xmitBuffer)) continue block7;
                    this.transmissionBuilt = true;
                    this.state = 0;
                    this.currentXmitDataBufferIndex = 0;
                    this.headerScratchSpace.clear();
                    continue block7;
                }
                case 4: {
                    if (error == null) {
                        error = new SIErrorException("Entered error state without exception been set");
                    }
                    this.connection.invalidate(true, (Throwable)error, "error building transmission");
                    continue block7;
                }
            }
        }
        boolean retValue = this.transmissionBuilt;
        if (this.transmissionBuilt) {
            this.transmissionBuilt = false;
        }
        this.exhausedXmitBuffer = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"buildTransmission", (Object)("" + retValue));
        }
        return retValue;
    }

    protected Conversation getConversation() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConversation");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConversation", (Object)this.conversation);
        }
        return this.conversation;
    }

    protected boolean isPooledBuffers() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isPooledBuffers");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isPooledBuffers", (Object)("" + this.primaryHeaderFields.isPooled));
        }
        return this.primaryHeaderFields.isPooled;
    }

    protected int getPriority() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPriority");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPriority", (Object)("" + this.primaryHeaderFields.priority));
        }
        return this.primaryHeaderFields.priority;
    }

    protected SendListener getSendListener() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSendListener");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSendListener", (Object)this.sendListener);
        }
        return this.sendListener;
    }

    protected boolean isUserRequest() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isUserRequest");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isUserRequest", (Object)("" + this.isUserRequest));
        }
        return this.isUserRequest;
    }

    protected boolean isTerminal() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isTermainl");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isTermainl", (Object)("" + this.isTerminal));
        }
        return this.isTerminal;
    }

    protected int getSize() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSize");
        }
        int headerSize = 0;
        if (this.layout == JFapChannelConstants.XMIT_PRIMARY_ONLY) {
            headerSize = 10;
        } else if (this.layout == JFapChannelConstants.XMIT_CONVERSATION) {
            headerSize = 14;
        } else if (this.layout == JFapChannelConstants.XMIT_SEGMENT_START) {
            headerSize = 26;
        } else if (this.layout == JFapChannelConstants.XMIT_SEGMENT_MIDDLE) {
            headerSize = 14;
        } else if (this.layout == JFapChannelConstants.XMIT_SEGMENT_END) {
            headerSize = 14;
        } else {
            throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"TRANSDATA_INTERNAL_SICJ0060", null, (String)"TRANSDATA_INTERNAL_SICJ0060"));
        }
        int retValue = this.primaryHeaderFields.segmentLength - headerSize;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSize", (Object)("" + retValue));
        }
        return retValue;
    }

    private boolean buildHeader(HeaderFields headerFields, WsByteBuffer xmitBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"buildHeader", (Object)new Object[]{headerFields, xmitBuffer});
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, xmitBuffer, "xmitBuffer");
        }
        boolean headerFinished = false;
        WsByteBuffer headerBuffer = null;
        if (this.headerScratchSpace.position() == 0) {
            if (tc.isDebugEnabled()) {
                JFapUtils.debugTraceWsByteBufferInfo(this, tc, this.headerScratchSpace, "headerScratchSpace");
            }
            if (xmitBuffer.remaining() >= headerFields.sizeof()) {
                headerBuffer = xmitBuffer;
                headerFields.writeToBuffer(xmitBuffer);
                headerFinished = true;
            } else {
                headerBuffer = this.headerScratchSpace;
                headerFields.writeToBuffer(this.headerScratchSpace);
                this.headerScratchSpace.flip();
            }
        } else {
            headerBuffer = this.headerScratchSpace;
        }
        if (!headerFinished) {
            int headerLeftToCopy = headerBuffer.remaining();
            int amountCopied = JFapUtils.copyWsByteBuffer(headerBuffer, xmitBuffer, headerLeftToCopy);
            boolean bl = headerFinished = amountCopied == headerLeftToCopy;
        }
        if (headerFinished) {
            this.headerScratchSpace.clear();
            this.transmissionRemaining -= headerFields.sizeof();
        } else {
            this.exhausedXmitBuffer = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"buildHeader", (Object)("" + headerFinished));
        }
        return headerFinished;
    }

    private boolean buildPayload(WsByteBuffer xmitBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"buildPayload", (Object)xmitBuffer);
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, xmitBuffer, "xmitBuffer");
        }
        boolean payloadFinished = false;
        if (this.xmitDataBuffers.length == 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"payload finished");
            }
            payloadFinished = true;
        } else {
            int amountToCopy;
            int amountCopied;
            do {
                if ((amountToCopy = this.xmitDataBuffers[this.currentXmitDataBufferIndex].remaining()) > this.transmissionRemaining) {
                    amountToCopy = this.transmissionRemaining;
                }
                amountCopied = JFapUtils.copyWsByteBuffer(this.xmitDataBuffers[this.currentXmitDataBufferIndex], xmitBuffer, amountToCopy);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("amountToCopy=" + amountToCopy + " amountCopied=" + amountCopied + " currentXmitDataBufferIndex=" + this.currentXmitDataBufferIndex));
                }
                this.transmissionRemaining -= amountCopied;
                if (amountCopied == amountToCopy) {
                    ++this.currentXmitDataBufferIndex;
                    boolean bl = payloadFinished = this.currentXmitDataBufferIndex == this.xmitDataBuffers.length;
                }
                if (amountCopied >= amountToCopy && this.transmissionRemaining >= 1) continue;
                this.exhausedXmitBuffer = true;
            } while (amountCopied == amountToCopy && !payloadFinished && !this.exhausedXmitBuffer);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"buildPayload", (Object)("" + payloadFinished));
        }
        return payloadFinished;
    }

    protected void release() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"release");
        }
        this.iterator.release();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"release");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/TransmissionData.java, SIB.comms, WASX.SIB, uu1215.01 1.17");
        }
    }

    private class SegmentedTransmissionHeaderFields
    extends HeaderFields {
        private long totalLength;
        int segmentType;

        protected SegmentedTransmissionHeaderFields() {
            super(12);
        }

        @Override
        protected void writeToBuffer(WsByteBuffer dst) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"SegmentedTransmissionHeaderFields.writeToBuffer");
            }
            dst.putLong(this.totalLength);
            dst.put((byte)this.segmentType);
            dst.put((byte)0);
            dst.putShort((short)0);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"SegmentedTransmissionHeaderFields.writeToBuffer");
            }
        }
    }

    private class ConversationHeaderFields
    extends HeaderFields {
        private int conversationId;
        private int requestNumber;

        protected ConversationHeaderFields() {
            super(4);
        }

        @Override
        protected void writeToBuffer(WsByteBuffer dst) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"ConversationHeaderFields.writeToBuffer");
            }
            dst.putShort((short)this.conversationId);
            dst.putShort((short)this.requestNumber);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"ConversationHeaderFields.writeToBuffer");
            }
        }
    }

    private class PrimaryHeaderFields
    extends HeaderFields {
        int segmentLength;
        int priority;
        boolean isPooled;
        boolean isExchange;
        int packetNumber;
        int segmentType;

        protected PrimaryHeaderFields() {
            super(10);
        }

        @Override
        protected void writeToBuffer(WsByteBuffer dst) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"PrimaryHeaderFields.writeToBuffer");
            }
            dst.putShort((short)-16657);
            dst.putInt(this.segmentLength);
            short flags = (short)(this.priority & 0xF);
            if (this.isPooled) {
                flags = (short)(flags | 0x1000);
            }
            if (this.isExchange) {
                flags = (short)(flags | 0x4000);
            }
            dst.putShort(flags);
            dst.put((byte)this.packetNumber);
            dst.put((byte)this.segmentType);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"PrimaryHeaderFields.writeToBuffer");
            }
        }
    }

    private abstract class HeaderFields {
        private int sizeof;

        protected HeaderFields(int sizeof) {
            this.sizeof = sizeof;
        }

        protected int sizeof() {
            return this.sizeof;
        }

        protected abstract void writeToBuffer(WsByteBuffer var1);
    }
}

