/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs.monitor;

import com.ibm.websphere.monitor.meters.Counter;
import com.ibm.websphere.monitor.meters.Meter;
import com.ibm.websphere.monitor.meters.StatisticsMeter;
import com.ibm.ws.jaxrs.monitor.RestStatsMXBean;

public class REST_Stats
extends Meter
implements RestStatsMXBean {
    private String appName;
    private String methodName;
    private Counter requestCount;
    private final StatisticsMeter responseTime;

    public REST_Stats(String aName, String mName) {
        this.setAppName(aName);
        this.setMethodName(mName);
        this.requestCount = new Counter();
        this.requestCount.setDescription("This shows number of requests to a Restful resource method");
        this.responseTime = new StatisticsMeter();
        this.responseTime.setDescription("Cumulative Response Time (NanoSeconds) for a Restful resource method");
        this.responseTime.setUnit("ns");
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public String getDescription() {
        return "Report Stats for specified Restful resource method.";
    }

    @Override
    public long getRequestCount() {
        return this.requestCount.getCurrentValue();
    }

    @Override
    public double getResponseTime() {
        return this.responseTime.getTotal();
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setRequestCount(Counter requestCount) {
        this.requestCount = requestCount;
    }

    public void incrementCountBy(int i) {
        this.requestCount.incrementBy((long)i);
    }

    public void updateRT(long elapsed) {
        this.responseTime.addDataPoint(elapsed);
    }

    @Override
    public Counter getRequestCountDetails() {
        return this.requestCount;
    }

    @Override
    public StatisticsMeter getResponseTimeDetails() {
        return this.responseTime;
    }
}

