/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.transport.iiop.security.FinalContextToken;
import com.ibm.ws.transport.iiop.security.SASException;
import com.ibm.ws.transport.iiop.security.SASNoContextException;
import com.ibm.ws.transport.iiop.security.SASReplyManager;
import com.ibm.ws.transport.iiop.security.ServerPolicy;
import com.ibm.ws.transport.iiop.security.config.ssl.SSLSessionManager;
import com.ibm.ws.transport.iiop.security.config.tss.TSSConfig;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CSI.CompleteEstablishContext;
import org.omg.CSI.ContextError;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
final class ServerSecurityInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static final TraceComponent tc = Tr.register(ServerSecurityInterceptor.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    private static final long serialVersionUID = 1L;
    private final Codec codec;
    private final transient SubjectManager subjectManager;
    private final Map<Integer, Subject> subjectMap;

    public ServerSecurityInterceptor(Codec codec) {
        this.codec = codec;
        this.subjectManager = new SubjectManager();
        this.subjectMap = new ConcurrentHashMap<Integer, Subject>();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={SASException.class, BAD_PARAM.class})
    public void receive_request(ServerRequestInfo ri) {
        boolean isDebug;
        int requestId = ri.request_id();
        boolean bl = isDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (isDebug) {
            Tr.debug((TraceComponent)tc, (String)("receive_request(" + ri.operation() + " [" + new String(ri.object_id()) + "] for request id: " + requestId + "."), (Object[])new Object[0]);
        }
        long contextId = 0L;
        this.subjectManager.clearSubjects();
        Subject subject = this.subjectMap.remove(requestId);
        if (subject != null) {
            this.subjectManager.setCallerSubject(subject);
            return;
        }
        try {
            ServerPolicy serverPolicy = (ServerPolicy)ri.get_server_policy(1095976448);
            if (serverPolicy == null) {
                if (isDebug) {
                    Tr.debug((TraceComponent)tc, (String)("The server policy is null for the policy type 1095976448 and request id: " + requestId + "."), (Object[])new Object[0]);
                }
                return;
            }
            TSSConfig tssPolicy = serverPolicy.getConfig();
            if (tssPolicy == null) {
                this.buildPolicyErrorMessage("CSIv2_SERVER_CONFIG_NULL_ERROR", "CWWKS9540E: There is no client configuration found in the client security policy request id: {0}.", requestId);
                return;
            }
            if (isDebug) {
                Tr.debug((TraceComponent)tc, (String)("Found server policy for request id: " + requestId + "."), (Object[])new Object[0]);
            }
            ServiceContext serviceContext = null;
            try {
                serviceContext = ri.get_request_service_context(15);
                if (isDebug) {
                    Tr.debug((TraceComponent)tc, (String)("Found service context for request id: " + requestId + "."), (Object[])new Object[0]);
                }
                Any any = this.codec.decode_value(serviceContext.context_data, SASContextBodyHelper.type());
                SASContextBody contextBody = SASContextBodyHelper.extract((Any)any);
                short msgType = contextBody.discriminator();
                switch (msgType) {
                    case 0: {
                        if (isDebug) {
                            Tr.debug((TraceComponent)tc, (String)("EstablishContext for  request id: " + requestId + "."), (Object[])new Object[0]);
                        }
                        contextId = contextBody.establish_msg().client_context_id;
                        subject = tssPolicy.check(SSLSessionManager.getSSLSession(ri.request_id()), contextBody.establish_msg(), this.codec);
                        if (subject != null) {
                            this.subjectManager.setCallerSubject(subject);
                        }
                        SASReplyManager.setSASReply(ri.request_id(), this.generateContextEstablished(subject, contextId, false));
                        break;
                    }
                    case 1: {
                        String messageFromBundle = Tr.formatMessage((TraceComponent)tc, (String)"CSIv2_SERVER_UNEXPECTED_MSG_ERROR", (Object[])new Object[]{"CompleteEstablishContext", requestId});
                        Tr.error((TraceComponent)tc, (String)messageFromBundle, (Object[])new Object[0]);
                        throw new INTERNAL(messageFromBundle);
                    }
                    case 4: {
                        String messageFromBundle = Tr.formatMessage((TraceComponent)tc, (String)"CSIv2_SERVER_UNEXPECTED_MSG_ERROR", (Object[])new Object[]{"ContextError", requestId});
                        Tr.error((TraceComponent)tc, (String)messageFromBundle, (Object[])new Object[0]);
                        throw new INTERNAL(messageFromBundle);
                    }
                    case 5: {
                        contextId = contextBody.in_context_msg().client_context_id;
                        String messageFromBundle = Tr.formatMessage((TraceComponent)tc, (String)"CSIv2_SERVER_DOES_NOT_SUPPORT_STATEFUL_ERROR", (Object[])new Object[]{contextId, requestId});
                        Tr.error((TraceComponent)tc, (String)messageFromBundle, (Object[])new Object[0]);
                        throw new SASNoContextException(messageFromBundle);
                    }
                }
            }
            catch (BAD_PARAM e) {
                if (isDebug) {
                    Tr.debug((TraceComponent)tc, (String)("No security service context found for request id: " + requestId + "."), (Object[])new Object[0]);
                }
                subject = this.acceptTransportContext(ri, tssPolicy);
            }
        }
        catch (INV_POLICY serverPolicy) {
            void e;
            FFDCFilter.processException((Throwable)serverPolicy, (String)"com.ibm.ws.transport.iiop.security.ServerSecurityInterceptor", (String)"173", (Object)((Object)this), (Object[])new Object[]{ri});
            this.buildPolicyErrorMessage("CSIv2_SERVER_UNEXPECTED_EXCEPTION_ERROR", "CWWKS9544E: There was an unexpected exception while receiving an inbound CSIv2 request for request id {0}. The exception message is {1}", requestId, e);
        }
        catch (TypeMismatch e) {
            void tm;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.transport.iiop.security.ServerSecurityInterceptor", (String)"177", (Object)((Object)this), (Object[])new Object[]{ri});
            String messageFromBundle = Tr.formatMessage((TraceComponent)tc, (String)"CSIv2_SERVER_UNEXPECTED_EXCEPTION_ERROR", (Object[])new Object[]{requestId, tm});
            Tr.error((TraceComponent)tc, (String)messageFromBundle, (Object[])new Object[0]);
            throw (MARSHAL)new MARSHAL(messageFromBundle).initCause((Throwable)tm);
        }
        catch (FormatMismatch tm) {
            void fm;
            FFDCFilter.processException((Throwable)tm, (String)"com.ibm.ws.transport.iiop.security.ServerSecurityInterceptor", (String)"181", (Object)((Object)this), (Object[])new Object[]{ri});
            String messageFromBundle = Tr.formatMessage((TraceComponent)tc, (String)"CSIv2_SERVER_UNEXPECTED_EXCEPTION_ERROR", (Object[])new Object[]{requestId, fm});
            Tr.error((TraceComponent)tc, (String)messageFromBundle, (Object[])new Object[0]);
            throw (MARSHAL)new MARSHAL(messageFromBundle).initCause((Throwable)fm);
        }
        catch (SASException e) {
            Tr.error((TraceComponent)tc, (String)"SASException", (Object[])new Object[]{e, " for request id: ", requestId});
            SASReplyManager.setSASReply(ri.request_id(), this.generateContextError(e, contextId));
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause.getMessage(), cause);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.transport.iiop.security.ServerSecurityInterceptor", (String)"199", (Object)((Object)this), (Object[])new Object[]{ri});
            this.buildPolicyErrorMessage("CSIv2_SERVER_UNEXPECTED_EXCEPTION_ERROR", "CWWKS9544E: There was an unexpected exception while receiving an inbound CSIv2 request for request id {0}. The exception message is {1}", requestId, e);
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause.getMessage(), cause);
        }
        if (isDebug) {
            Tr.debug((TraceComponent)tc, (String)(subject + " for request id: " + requestId + "."), (Object[])new Object[0]);
        }
    }

    private Subject acceptTransportContext(ServerRequestInfo ri, TSSConfig tssPolicy) throws SASException {
        Subject subject = tssPolicy.check(SSLSessionManager.getSSLSession(ri.request_id()), null, this.codec);
        if (subject != null) {
            this.subjectManager.setCallerSubject(subject);
        }
        return subject;
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) {
        Subject subject = this.getSubject();
        if (subject != null) {
            int id = ri.request_id();
            this.subjectMap.put(id, subject);
        }
    }

    private Subject getSubject() {
        Subject subject = this.subjectManager.getInvocationSubject();
        if (subject == null) {
            subject = this.subjectManager.getCallerSubject();
        }
        return subject;
    }

    public void send_exception(ServerRequestInfo ri) {
        this.subjectManager.clearSubjects();
        this.insertServiceContext(ri);
    }

    public void send_other(ServerRequestInfo ri) {
        this.subjectManager.clearSubjects();
        this.insertServiceContext(ri);
    }

    public void send_reply(ServerRequestInfo ri) {
        this.subjectManager.clearSubjects();
        this.insertServiceContext(ri);
    }

    public void destroy() {
    }

    public String name() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected SASContextBody generateContextError(SASException e, long contextId) {
        SASContextBody reply = new SASContextBody();
        reply.error_msg(new ContextError(contextId, e.getMajor(), e.getMinor(), e.getErrorToken()));
        return reply;
    }

    protected SASContextBody generateContextEstablished(Subject identity, long contextId, boolean stateful) {
        Set<FinalContextToken> credentials;
        byte[] finalContextToken = null;
        if (identity != null && !(credentials = identity.getPrivateCredentials(FinalContextToken.class)).isEmpty()) {
            try {
                FinalContextToken token = credentials.iterator().next();
                finalContextToken = token.getToken();
                token.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                FFDCFilter.processException((Throwable)destroyFailedException, (String)"com.ibm.ws.transport.iiop.security.ServerSecurityInterceptor", (String)"300", (Object)((Object)this), (Object[])new Object[]{identity, contextId, stateful});
            }
        }
        if (finalContextToken == null) {
            finalContextToken = new byte[]{};
        }
        SASContextBody reply = new SASContextBody();
        reply.complete_msg(new CompleteEstablishContext(contextId, stateful, finalContextToken));
        return reply;
    }

    /*
     * WARNING - void declaration
     */
    protected void insertServiceContext(ServerRequestInfo ri) {
        try {
            SASContextBody sasContextBody = SASReplyManager.clearSASReply(ri.request_id());
            if (sasContextBody != null) {
                Any any = ORB.init().create_any();
                SASContextBodyHelper.insert((Any)any, (SASContextBody)sasContextBody);
                ri.add_reply_service_context(new ServiceContext(15, this.codec.encode_value(any)), true);
            }
        }
        catch (InvalidTypeForEncoding sasContextBody) {
            void itfe;
            FFDCFilter.processException((Throwable)sasContextBody, (String)"com.ibm.ws.transport.iiop.security.ServerSecurityInterceptor", (String)"322", (Object)((Object)this), (Object[])new Object[]{ri});
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"InvalidTypeForEncoding thrown", (Object[])new Object[]{itfe});
            }
            throw (INTERNAL)new INTERNAL("InvalidTypeForEncoding thrown: " + itfe).initCause((Throwable)itfe);
        }
    }

    private void buildPolicyErrorMessage(String msgKey, String defaultMessage, Object ... arg1) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
            String messageFromBundle = Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])arg1);
            Tr.error((TraceComponent)tc, (String)messageFromBundle, (Object[])new Object[0]);
        }
    }
}

