/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.callback;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.saml2.Saml20Token;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.sso.common.SsoService;
import com.ibm.ws.wssecurity.token.TokenUtils;
import java.io.IOException;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.parsers.DocumentBuilder;
import org.apache.ws.security.saml.ext.SAMLCallback;
import org.opensaml.Configuration;
import org.opensaml.xml.parse.ParserPool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Saml20PropagationCallbackHandler
implements CallbackHandler {
    protected static final TraceComponent tc = Tr.register(Saml20PropagationCallbackHandler.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    static final String samlElementKey = "samlElement";
    static final long serialVersionUID = -5116720668821208501L;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        SsoService wssSamlService;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"callbacks", (Object[])new Object[0]);
        }
        if ((wssSamlService = TokenUtils.getCommonSsoService("wssSaml")) == null) {
            throw new IOException("The wsSecuritySaml-1.1 feature is not currently available. Make sure your server.xml has been configured to use the wsSecuritySaml-1.1 feature properly.");
        }
        if (callbacks.length == 0) {
            Tr.error((TraceComponent)tc, (String)"no_callbacks_provided", (Object[])new Object[0]);
            String msg = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages", (String)"no_callbacks_provided", (Object[])new Object[0], (String)"CWWKW0233E: No callbacks were provided to handle the request.");
            throw new IOException(msg);
        }
        boolean hasSaml = false;
        Saml20Token token = this.getSaml20TokenFromSubject();
        Element assertionElement = null;
        if (token != null && (assertionElement = this.getSamlElementFromToken(token)) != null) {
            hasSaml = true;
        }
        if (!hasSaml) {
            Tr.error((TraceComponent)tc, (String)"no_saml_found_in_subject", (Object[])new Object[0]);
            String msg = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages", (String)"no_saml_found_in_subject", (Object[])new Object[0], (String)"CWWKW0234E: The required SAML token is missing from the subject.");
            throw new IOException(msg);
        }
        for (int i = 0; i < callbacks.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("callbacks:" + callbacks[i]), (Object[])new Object[0]);
            }
            if (!(callbacks[i] instanceof SAMLCallback)) continue;
            SAMLCallback callback = (SAMLCallback)callbacks[i];
            callback.setAssertionElement(assertionElement);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Element getSamlElementFromToken(Saml20Token token) {
        Element samlElement = null;
        try {
            Element element;
            Map props = token.getProperties();
            if (props != null && (element = (Element)props.get(samlElementKey)) != null) {
                samlElement = element;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"the element from getProperties():", (Object[])new Object[]{samlElement});
            }
            if (samlElement == null) {
                String samlString = token.getSAMLAsString();
                ParserPool pp = Configuration.getParserPool();
                DocumentBuilder builder = pp.getBuilder();
                Document document = builder.parse(new InputSource(new StringReader(samlString)));
                samlElement = document.getDocumentElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"the element from getSAMLAsString():", (Object[])new Object[]{samlElement});
                }
            }
        }
        catch (Exception props) {
            void e;
            FFDCFilter.processException((Throwable)props, (String)"com.ibm.ws.wssecurity.callback.Saml20PropagationCallbackHandler", (String)"142", (Object)this, (Object[])new Object[]{token});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception while extracting SAML element: ", (Object[])new Object[]{e.getCause()});
            }
            Tr.warning((TraceComponent)tc, (String)"failed_to_extract_saml_element", (Object[])new Object[]{e.getLocalizedMessage()});
        }
        return samlElement;
    }

    /*
     * WARNING - void declaration
     */
    protected Saml20Token getSaml20TokenFromSubject() {
        Saml20Token samlToken = null;
        try {
            final Subject subject = WSSubject.getRunAsSubject();
            samlToken = (Saml20Token)AccessController.doPrivileged(new PrivilegedExceptionAction(){
                static final long serialVersionUID = -5288245422773768850L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Object run() throws Exception {
                    Iterator<Saml20Token> authIterator = subject.getPrivateCredentials(Saml20Token.class).iterator();
                    if (authIterator.hasNext()) {
                        Saml20Token token = authIterator.next();
                        return token;
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.wssecurity.callback.Saml20PropagationCallbackHandler$1", 1.class, null, null);
                }
            });
        }
        catch (Exception subject) {
            void e;
            FFDCFilter.processException((Throwable)subject, (String)"com.ibm.ws.wssecurity.callback.Saml20PropagationCallbackHandler", (String)"170", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception while getting SAML token from subject:", (Object[])new Object[]{e.getCause()});
            }
            Tr.warning((TraceComponent)tc, (String)"failed_to_extract_saml_token_from_subject", (Object[])new Object[]{e.getLocalizedMessage()});
        }
        return samlToken;
    }
}

