/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.config.admin.internal.ConfigurationStorageHelper;
import com.ibm.ws.config.xml.ConfigVariables;
import com.ibm.ws.config.xml.internal.ConfigVariable;
import com.ibm.ws.config.xml.internal.StringUtils;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConfigVariableRegistry
implements VariableRegistry,
ConfigVariables {
    private static final TraceComponent tc = Tr.register(ConfigVariableRegistry.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    public static final String UNIQUE = "UNIQUE_";
    public static final String IN_USE = "WLP_VAR_IN_USE";
    private final VariableRegistry registry;
    private final File variableCacheFile;
    private Map<String, ConfigVariable> configVariables;
    private Map<String, Object> variableCache;
    private Map<String, Object> defaultVariableCache;
    private final List<CommandLineVariable> commandLineVariables = new ArrayList<CommandLineVariable>();
    private final StringUtils stringUtils = new StringUtils();
    static final long serialVersionUID = -4939446888662027003L;

    public ConfigVariableRegistry(VariableRegistry registry, String[] cmdArgs, File variableCacheFile) {
        this.registry = registry;
        this.configVariables = Collections.emptyMap();
        this.variableCacheFile = variableCacheFile;
        if (variableCacheFile != null) {
            this.loadVariableCache();
        }
        if (this.variableCache == null) {
            this.variableCache = new HashMap<String, Object>();
        }
        if (this.defaultVariableCache == null) {
            this.defaultVariableCache = new HashMap<String, Object>();
        }
        for (String cmdArg : cmdArgs) {
            CommandLineVariable clv = new CommandLineVariable(cmdArg);
            if (!clv.isValid()) continue;
            this.commandLineVariables.add(clv);
            registry.replaceVariable(clv.getName(), clv.getValue());
        }
    }

    public void updateSystemVariables(Map<String, ConfigVariable> newVariables) {
        for (String string : this.configVariables.keySet()) {
            if (newVariables.containsKey(string)) continue;
            this.registry.removeVariable(string);
        }
        for (Map.Entry entry : newVariables.entrySet()) {
            String variableName = (String)entry.getKey();
            String variableValue = ((ConfigVariable)entry.getValue()).getValue();
            if (variableValue != null) {
                this.registry.replaceVariable(variableName, variableValue);
                continue;
            }
            this.registry.removeVariable(variableName);
        }
        this.configVariables = newVariables;
        for (CommandLineVariable commandLineVariable : this.commandLineVariables) {
            this.registry.replaceVariable(commandLineVariable.getName(), commandLineVariable.getValue());
        }
    }

    public synchronized void updateVariableCache(Map<String, Object> variables) {
        boolean dirty = false;
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            Object variableValue;
            ConfigVariable var;
            String variableName = entry.getKey();
            if (this.configVariables.containsKey(variableName) && (var = this.configVariables.get(variableName)).getDefaultValue() == null || this.isVariableCached(variableName, variableValue = entry.getValue())) continue;
            this.variableCache.put(variableName, variableValue);
            dirty = true;
        }
        if (dirty) {
            this.saveVariableCache();
        }
    }

    private boolean isVariableCached(String variableName, Object variableValue) {
        if (this.variableCache.containsKey(variableName)) {
            Object cachedVariableValue = this.variableCache.get(variableName);
            return ConfigVariableRegistry.isEqual(cachedVariableValue, variableValue);
        }
        return false;
    }

    private static boolean isEqual(Object oldVariableValue, Object newVariableValue) {
        if (oldVariableValue == null) {
            return newVariableValue == null;
        }
        if (newVariableValue == null) {
            return false;
        }
        return oldVariableValue.equals(newVariableValue);
    }

    public synchronized boolean variablesChanged() {
        for (Map.Entry<String, Object> entry : this.variableCache.entrySet()) {
            String variableName = entry.getKey();
            Object oldVariableValue = entry.getValue();
            Object newVariableValue = this.lookupVariable(variableName);
            if (newVariableValue == null) {
                newVariableValue = this.defaultVariableCache.get(variableName);
            }
            if (newVariableValue == null) {
                newVariableValue = this.lookupVariableFromAdditionalSources(variableName);
            }
            if (ConfigVariableRegistry.isEqual(oldVariableValue, newVariableValue)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Variable " + variableName + " has changed. Old value: " + oldVariableValue + " New value: " + newVariableValue), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    String lookupVariableFromAdditionalSources(String variableName) {
        String value = null;
        value = this.lookupVariable("env." + variableName);
        if (value == null) {
            variableName = this.stringUtils.replaceNonAlpha(variableName);
            value = this.lookupVariable("env." + variableName);
        }
        if (value == null) {
            variableName = variableName.toUpperCase();
            value = this.lookupVariable("env." + variableName);
        }
        return value;
    }

    public synchronized void clearVariableCache() {
        this.variableCache.clear();
        this.defaultVariableCache.clear();
    }

    public String lookupVariable(String variableName) {
        String resolvedVar;
        String varReference = "${" + variableName + "}";
        return varReference.equalsIgnoreCase(resolvedVar = this.registry.resolveRawString(varReference)) ? null : resolvedVar;
    }

    @FFDCIgnore(value={Exception.class})
    private synchronized void loadVariableCache() {
        block6: {
            try {
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.variableCacheFile)));
                try {
                    this.variableCache = new HashMap<String, Object>();
                    ConfigurationStorageHelper.readMap(in, ConfigurationStorageHelper.toMapOrDictionary(this.variableCache));
                    this.defaultVariableCache = new HashMap<String, Object>();
                    ConfigurationStorageHelper.readMap(in, ConfigurationStorageHelper.toMapOrDictionary(this.defaultVariableCache));
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.xml.internal.ConfigVariableRegistry", (String)"280", (Object)this, (Object[])new Object[0]);
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.config.xml.internal.ConfigVariableRegistry", (String)"280", (Object)this, (Object[])new Object[0]);
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                in.close();
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)("loadVariableCache():  Exception = " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={IOException.class})
    private synchronized void saveVariableCache() {
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.variableCacheFile)));
            try {
                ConfigurationStorageHelper.writeMap(out, ConfigurationStorageHelper.toMapOrDictionary(this.variableCache));
                ConfigurationStorageHelper.writeMap(out, ConfigurationStorageHelper.toMapOrDictionary(this.defaultVariableCache));
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.xml.internal.ConfigVariableRegistry", (String)"292", (Object)this, (Object[])new Object[0]);
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.config.xml.internal.ConfigVariableRegistry", (String)"292", (Object)this, (Object[])new Object[0]);
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            out.close();
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("saveVariableCache():  Exception = " + e.getMessage()), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)e, (String)ConfigVariableRegistry.class.getName(), (String)("saveVariableCache(): Exception = " + e.getMessage()));
        }
    }

    public synchronized void setDefaultVariables(Map<String, ConfigVariable> variables) {
        boolean dirty = false;
        for (Map.Entry<String, ConfigVariable> entry : variables.entrySet()) {
            String variableName = entry.getKey();
            String currentValue = this.lookupVariable(variableName);
            if (currentValue != null) continue;
            String defaultValue = entry.getValue().getValue();
            this.registry.addVariable(variableName, defaultValue);
            Object oldValue = this.defaultVariableCache.put(variableName, defaultValue);
            dirty = oldValue == null ? true : !oldValue.equals(defaultValue);
        }
        if (dirty) {
            this.saveVariableCache();
        }
    }

    public boolean addVariable(String variable, String value) {
        return this.registry.addVariable(variable, value);
    }

    public void replaceVariable(String variable, String value) {
        this.registry.replaceVariable(variable, value);
    }

    public String resolveString(String string) {
        return this.registry.resolveString(string);
    }

    public String resolveRawString(String string) {
        return this.registry.resolveRawString(string);
    }

    public void removeVariable(String symbol) {
        this.registry.removeVariable(symbol);
    }

    public String getUniqueVarString(ExtendedAttributeDefinition attrDef, String value) {
        return UNIQUE + attrDef.getUniqueCategory() + value;
    }

    public void removeUniqueVariable(ExtendedAttributeDefinition attrDef, String attributeValue) {
        this.removeVariable(this.getUniqueVarString(attrDef, attributeValue));
    }

    public void addVariableInUse(String variable) {
        this.addVariable(variable, IN_USE);
    }

    @Override
    public Map<String, String> getUserDefinedVariables() {
        HashMap<String, String> userDefinedVariables = new HashMap<String, String>();
        for (Map.Entry<String, ConfigVariable> entry : this.configVariables.entrySet()) {
            ConfigVariable var = entry.getValue();
            if (var.getValue() == null) continue;
            userDefinedVariables.put(var.getName(), var.getValue());
        }
        for (CommandLineVariable clVar : this.commandLineVariables) {
            userDefinedVariables.put(clVar.getName(), clVar.getValue());
        }
        return userDefinedVariables;
    }

    public String lookupVariableDefaultValue(String variableName) {
        ConfigVariable cv = this.configVariables.get(variableName);
        return cv == null ? null : cv.getDefaultValue();
    }

    @Override
    public Map<String, String> getUserDefinedVariableDefaults() {
        HashMap<String, String> userDefinedVariables = new HashMap<String, String>();
        for (Map.Entry<String, ConfigVariable> entry : this.configVariables.entrySet()) {
            ConfigVariable var = entry.getValue();
            if (var.getValue() != null || var.getDefaultValue() == null) continue;
            userDefinedVariables.put(var.getName(), var.getDefaultValue());
        }
        return userDefinedVariables;
    }

    @Trivial
    private static final class CommandLineVariable {
        private final String name;
        private final String value;
        private final boolean isValid;

        public CommandLineVariable(String cmdArg) {
            int idx = cmdArg.indexOf(61);
            if (!cmdArg.startsWith("--") || idx <= 2) {
                this.isValid = false;
                this.name = null;
                this.value = null;
            } else {
                this.isValid = true;
                this.name = cmdArg.substring(2, idx);
                this.value = cmdArg.substring(idx + 1);
            }
        }

        public boolean isValid() {
            return this.isValid;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

