/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.jms.internal.listener.impl;

import com.ibm.tx.jta.XAResourceNotAvailableException;
import com.ibm.tx.jta.embeddable.EmbeddableTransactionManagerFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener;
import com.ibm.ws.jbatch.jms.internal.listener.impl.BaseMessageEndpointFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.ws.tx.embeddable.RecoverableXAResourceAccessor;
import com.ibm.ws.util.ThreadContextAccessor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MessageEndpointHandler
implements MessageEndpoint,
InvocationHandler {
    private static final String CLASS_NAME = MessageEndpointHandler.class.getName();
    private static final TraceComponent tc = Tr.register(MessageEndpointHandler.class, (String)"wsbatch", null);
    private static final Method cvToStringMethod;
    private static final Method cvEqualsMethod;
    private static final Method cvHashCodeMethod;
    private static final byte BEFORE_DELIVERY_METHOD = 0;
    private static final byte AFTER_DELIVERY_METHOD = 1;
    private static final byte RELEASE_METHOD = 2;
    private static final short RELEASED_STATE = 0;
    private static final short READY_STATE = 1;
    private static final short IN_METHOD_OPTION_A_STATE = 2;
    private static final short BEFORE_DELIVERY_STATE = 3;
    private static final short IN_METHOD_OPTION_B_STATE = 4;
    private static final short AFTER_DELIVERY_PENDING_STATE = 5;
    private static final short DISCARDED_STATE = Short.MAX_VALUE;
    private short ivState = 0;
    private BaseMessageEndpointFactory ivMessageEndpointFactory;
    private final int ivRecoveryId;
    private boolean ivRecoverableXAResource;
    private Method ivMethod = null;
    private XAResource ivXAResource = null;
    Object ivProxy = null;
    private Thread ivThread = null;
    private boolean ivDiscardRequired = false;
    private int majorJCAVersion;
    private int minorJCAVersion;
    private boolean ivRollbackOnly;
    private boolean ivImportedTx;
    private final boolean ivRRSTransactional;
    private EmbeddableWebSphereTransactionManager ivTransactionManager = null;
    private static final ThreadContextAccessor threadContextAccessor;
    private Object origCL = null;
    static final long serialVersionUID = 6113303047469118349L;

    public BaseMessageEndpointFactory getBaseMessageEndpointFactory() {
        return this.ivMessageEndpointFactory;
    }

    public MessageEndpointHandler(BaseMessageEndpointFactory factory, int recoveryId, boolean rrsTransactional) {
        this.ivRecoveryId = recoveryId;
        this.ivMessageEndpointFactory = factory;
        this.ivTransactionManager = EmbeddableTransactionManagerFactory.getTransactionManager();
        this.ivRRSTransactional = rrsTransactional;
    }

    @Override
    @Trivial
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        Object result = null;
        if (declaringClass == MessageEndpoint.class) {
            this.invokeMessageEndpointMethod(method, args);
        } else if (declaringClass == Object.class) {
            result = this.invokeObjectClassMethod(proxy, method, args);
        } else {
            this.invokeJMSMethod(method, args);
        }
        return result;
    }

    protected void invokeJMSMethod(Method methodToInvoke, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        BatchJmsEndpointListener batchEndpointListener = new BatchJmsEndpointListener(this.ivMessageEndpointFactory.getConnectionFactory(), this.ivMessageEndpointFactory.getBatchExecutor().getBatchOperationGroup(), this.ivMessageEndpointFactory.getBatchExecutor().getWSJobRepository());
        methodToInvoke.invoke((Object)batchEndpointListener, args);
    }

    public void afterDelivery() throws ResourceException {
        threadContextAccessor.popContextClassLoader(this.origCL);
    }

    /*
     * WARNING - void declaration
     */
    public void beforeDelivery(Method method) throws NoSuchMethodException, ResourceException {
        try {
            UOWCoordinator coord;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("beforeDelivery push class loader=" + this.getClass().getClassLoader()), (Object[])new Object[0]);
            }
            this.origCL = threadContextAccessor.pushContextClassLoader(this.getClass().getClassLoader());
            UOWCurrent uowCurrent = EmbeddableTransactionManagerFactory.getUOWCurrent();
            UOWCoordinator inBoundCoord = uowCurrent.getUOWCoord();
            if (inBoundCoord == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"beforeDelivery called without a imported transaction context", (Object[])new Object[0]);
                }
                this.ivImportedTx = false;
            } else if (inBoundCoord.isGlobal()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"beforeDelivery called with a imported transaction context", (Object[])new Object[0]);
                }
                this.ivImportedTx = true;
            } else {
                inBoundCoord = null;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"beforeDelivery called without a imported transaction context", (Object[])new Object[0]);
                }
                this.ivImportedTx = false;
            }
            if ((this.ivXAResource != null || this.ivRRSTransactional) && !this.ivImportedTx && (coord = uowCurrent.getUOWCoord()).isGlobal()) {
                int recoveryId = this.ivRecoverableXAResource ? RecoverableXAResourceAccessor.getXARecoveryToken((XAResource)this.ivXAResource) : this.ivRecoveryId;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("enlisting XAResource from RA, recovery ID is " + recoveryId), (Object[])new Object[0]);
                }
                if (!this.ivRRSTransactional) {
                    this.ivTransactionManager.enlist(this.ivXAResource, recoveryId);
                } else {
                    this.ivTransactionManager.enlist(this.getNativeRRSXAR(coord), recoveryId);
                }
            }
        }
        catch (Throwable uowCurrent) {
            void t;
            FFDCFilter.processException((Throwable)uowCurrent, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointHandler", (String)"439", (Object)this, (Object[])new Object[]{method});
            FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".beforeDelivery"), (String)"1244", (Object)this);
            throw new ResourceException("beforeDelivery failure", (Throwable)t);
        }
    }

    public void release() {
        this.ivProxy = null;
    }

    private void invokeMessageEndpointMethod(Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if (name.startsWith("b")) {
            this.checkState(method, args, (byte)0);
            Method m = (Method)args[0];
            this.beforeDelivery(m);
        } else if (name.startsWith("a")) {
            this.checkState(method, args, (byte)1);
            this.afterDelivery();
        } else {
            this.checkState(method, args, (byte)2);
            this.release();
        }
    }

    @Trivial
    private Object invokeObjectClassMethod(Object proxy, Method method, Object[] args) throws Exception {
        if (method.equals(cvToStringMethod)) {
            return this.proxyToString(proxy);
        }
        if (method.equals(cvEqualsMethod)) {
            return this.proxyEquals(proxy, args[0]);
        }
        if (method.equals(cvHashCodeMethod)) {
            return this.proxyHashCode(proxy);
        }
        throw new Exception("Internal error, unexpected Object method dispatched: " + method);
    }

    @Trivial
    private String proxyToString(Object proxy) {
        String retStr = this.ivMessageEndpointFactory.getJ2EEName() + "($Proxy@" + Integer.toHexString(proxy.hashCode()) + ")";
        return retStr;
    }

    private Boolean proxyEquals(Object proxy, Object object) {
        return proxy == object ? Boolean.TRUE : Boolean.FALSE;
    }

    @Trivial
    private Integer proxyHashCode(Object proxy) {
        return System.identityHashCode(proxy);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void checkState(Method method, Object[] args, byte methodId) {
        thread = Thread.currentThread();
        if (this.ivThread != null && this.ivThread != thread) {
            this.ivDiscardRequired = true;
            t = new Exception("Conflicting with thread " + this.ivThread.getId() + ": " + this.ivThread.getName());
            t.setStackTrace(this.ivThread.getStackTrace());
            this.throwIllegalStateException("Multiple threads can not use same MessageEndpoint proxy instance concurrently", t);
        }
        switch (this.ivState) {
            case 1: {
                if (methodId == 0) {
                    this.ivState = (short)3;
                    this.ivMethod = (Method)args[0];
                    if (!TraceComponent.isAnyTracingEnabled() || !MessageEndpointHandler.tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)MessageEndpointHandler.tc, (String)("beforeDelivery: method is " + this.ivMethod), (Object[])new Object[0]);
                    break;
                }
                if (methodId == 2) {
                    this.ivState = 0;
                    break;
                }
                this.ivDiscardRequired = true;
                this.throwIllegalStateException("afterDelivery not paired with a prior beforeDelivery call");
                break;
            }
            case 2: {
                this.ivDiscardRequired = true;
                this.throwIllegalStateException("JCA requires resource adapter to ensure serial use of endpoint");
            }
            case 3: {
                if (methodId == 1) {
                    if (this.majorJCAVersion == 1 && this.minorJCAVersion == 5) {
                        if (TraceComponent.isAnyTracingEnabled() && MessageEndpointHandler.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)MessageEndpointHandler.tc, (String)"MessageEndpoint.afterDelivery is committing TX for JCA version 1.5 RA. A message listener method was not called in between the before/afterDelivery methods.", (Object[])new Object[0]);
                        }
                        this.ivRollbackOnly = false;
                        break;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && MessageEndpointHandler.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)MessageEndpointHandler.tc, (String)("MessageEndpoint.afterDelivery aborting TX as required by " + this.majorJCAVersion + "." + this.minorJCAVersion + ".  A message listener method was not called in between the before/afterDelivery methods."), (Object[])new Object[0]);
                    }
                    this.ivRollbackOnly = this.ivImportedTx == false;
                    break;
                }
                if (methodId == 0) {
                    this.ivDiscardRequired = true;
                    this.throwIllegalStateException("JCA requires resource adapter to call afterDelivery before the beforeDelivery can be called again on this endpoint");
                    break;
                }
                this.ivState = 0;
                break;
            }
            case 4: {
                if (methodId != 1) ** GOTO lbl46
                this.ivDiscardRequired = true;
                this.throwIllegalStateException("beforeDelivery called twice without afterDelivery between calls");
                ** GOTO lbl52
lbl46:
                // 1 sources

                if (methodId == 0) {
                    this.ivDiscardRequired = true;
                    this.throwIllegalStateException("beforeDelivery called twice without afterDelivery between calls");
                } else {
                    this.ivDiscardRequired = true;
                    this.throwIllegalStateException("release called without a prior afterDelivery call");
                }
            }
lbl52:
            // 4 sources

            case 5: {
                if (methodId == 1) {
                    // empty if block
                }
                if (methodId == 0) {
                    this.ivDiscardRequired = true;
                    this.throwIllegalStateException("JCA requires resource adapter to call afterDelivery before another beforeDelivery call can be made.");
                    break;
                }
                this.ivState = 0;
                break;
            }
            default: {
                this.ivDiscardRequired = true;
                this.throwIllegalStateException("JCA requires resource adapter not to make any calls on endpoint once release is called on endpoint");
            }
        }
        this.ivThread = thread;
    }

    public synchronized void initialize(XAResource xaResource, boolean recoverableXAResource, int majorJCAVer, int minorJCAVer) {
        if (this.ivState != 0) {
            this.ivDiscardRequired = true;
            this.throwIllegalStateException("MessageEndpoint proxy used after MessageEndpoint.release was called. Internal state = " + this.ivState);
        }
        this.ivState = 1;
        this.ivXAResource = xaResource;
        this.ivRecoverableXAResource = recoverableXAResource;
        this.majorJCAVersion = majorJCAVer;
        this.minorJCAVersion = minorJCAVer;
    }

    private void throwIllegalStateException(String msg) {
        this.throwIllegalStateException(msg, null);
    }

    private void throwIllegalStateException(String msg, Throwable t) {
        throw new IllegalStateException(msg, t);
    }

    protected XAResource getNativeRRSXAR(UOWCoordinator coord) throws XAResourceNotAvailableException {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        Method toStringMethod = null;
        Method equalsMethod = null;
        Method hashCodeMethod = null;
        try {
            Class<Object> c = Object.class;
            toStringMethod = c.getMethod("toString", null);
            equalsMethod = c.getMethod("equals", Object.class);
            hashCodeMethod = c.getMethod("hashCode", null);
        }
        catch (Throwable c) {
            void e;
            FFDCFilter.processException((Throwable)c, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointHandler", (String)"72", null, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".<cinit>"), (String)"115");
        }
        cvToStringMethod = toStringMethod;
        cvEqualsMethod = equalsMethod;
        cvHashCodeMethod = hashCodeMethod;
        threadContextAccessor = (ThreadContextAccessor)AccessController.doPrivileged(ThreadContextAccessor.getPrivilegedAction());
    }
}

