/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal;

import com.ibm.ws.kernel.boot.Debug;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.ProcessStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;

public class PSProcessStatusImpl
implements ProcessStatus {
    private static final boolean WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    private final String pid;

    public PSProcessStatusImpl(String pid) {
        this.pid = pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ProcessStatus.State isPossiblyRunning() {
        block14: {
            ProcessStatus.State state;
            BufferedReader reader;
            InputStream in;
            block12: {
                String line;
                if (this.pid.isEmpty()) {
                    return ProcessStatus.State.YES;
                }
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                if (WINDOWS) {
                    pb.command("ps", "-W", "-p", this.pid);
                } else {
                    pb.command("ps", "-p", this.pid);
                }
                Debug.println(pb.command());
                pb.redirectErrorStream(true);
                in = null;
                reader = null;
                Process p = pb.start();
                in = p.getInputStream();
                reader = new BufferedReader(new InputStreamReader(in));
                while ((line = reader.readLine()) != null) {
                    Debug.println(line);
                }
                p.waitFor();
                Debug.println("Exit code: " + p.exitValue());
                if (p.exitValue() != 0) break block12;
                state = ProcessStatus.State.YES;
                Utils.tryToClose(in);
                Utils.tryToClose(reader);
                return state;
            }
            try {
                state = ProcessStatus.State.NO;
            }
            catch (IOException e) {
                block13: {
                    if (!e.getMessage().contains("Cannot run program \"ps\"")) break block13;
                    state = ProcessStatus.State.UNDETERMINED;
                    Utils.tryToClose(in);
                    Utils.tryToClose(reader);
                    return state;
                }
                Debug.printStackTrace(e);
                Utils.tryToClose(in);
                Utils.tryToClose(reader);
                break block14;
            }
            catch (InterruptedException e2) {
                Debug.printStackTrace(e2);
                {
                    catch (Throwable throwable) {
                        Utils.tryToClose(in);
                        Utils.tryToClose(reader);
                        throw throwable;
                    }
                }
                Utils.tryToClose(in);
                Utils.tryToClose(reader);
            }
            Utils.tryToClose(in);
            Utils.tryToClose(reader);
            return state;
        }
        return ProcessStatus.State.YES;
    }
}

