/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.execution.impl;

import com.ibm.jbatch.container.execution.impl.RuntimeStepExecution;
import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.instance.WorkUnitDescriptor;
import com.ibm.jbatch.container.navigator.ModelNavigator;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionKey;
import com.ibm.jbatch.container.ws.PartitionPlanConfig;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class RuntimePartitionExecution
extends RuntimeWorkUnitExecution {
    protected static final Logger logger = Logger.getLogger(RuntimePartitionExecution.class.getName());
    private final PartitionPlanConfig partitionPlanConfig;
    private Long partitionLevelStepExecutionId;
    private boolean isRemoteDispatch;
    private boolean finalStatusSent;
    static final long serialVersionUID = 2469212921844376480L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RuntimePartitionExecution(PartitionPlanConfig partitionPlanConfig, ModelNavigator<JSLJob> navigator, boolean isRemoteDispatch) {
        super(navigator, partitionPlanConfig.getTopLevelNameInstanceExecutionInfo());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "<init>", new Object[]{partitionPlanConfig, navigator, isRemoteDispatch});
        }
        this.partitionLevelStepExecutionId = null;
        this.finalStatusSent = false;
        this.partitionPlanConfig = partitionPlanConfig;
        this.isRemoteDispatch = isRemoteDispatch;
        this.type = WorkUnitDescriptor.WorkUnitType.PARTITIONED_STEP;
        this.correlationId = partitionPlanConfig.getCorrelationId();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Logger getClassNameLogger() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getClassNameLogger", new Object[0]);
        }
        Logger logger = RuntimePartitionExecution.logger;
        if (RuntimePartitionExecution.logger != null && RuntimePartitionExecution.logger.isLoggable(Level.FINER)) {
            logger = logger;
            RuntimePartitionExecution.logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getClassNameLogger", logger);
        }
        return logger;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getExecutionLogMessage(RuntimeWorkUnitExecution.MessageType msgType) {
        Properties partitionProperties;
        RuntimeWorkUnitExecution.LogHelper lh = new RuntimeWorkUnitExecution.LogHelper(this);
        StringBuilder buf = lh.getBeginningPart(msgType);
        buf.append("invoking execution for a partition");
        buf.append("\n Partition step name = ");
        buf.append(this.getStepName());
        buf.append("\n Partition number = ");
        buf.append(this.getPartitionNumber());
        if (this.partitionLevelStepExecutionId != null) {
            buf.append("\n Partition-level (internal) step execution id = ");
            buf.append(this.partitionLevelStepExecutionId);
        }
        buf.append("\n Associated Top-level StepExecution id = ");
        buf.append(this.getTopLevelStepExecutionId());
        buf.append("\n Associated Top-level JobInstance id = ");
        buf.append(this.getTopLevelInstanceId());
        buf.append("\n Associated Top-level JobExecution id = ");
        buf.append(this.getTopLevelExecutionId());
        buf.append("\n Associated Top-level Job Name = ");
        buf.append(this.getTopLevelJobName());
        if (!msgType.equals((Object)RuntimeWorkUnitExecution.MessageType.STARTED)) {
            buf.append("\n Partition Batch Status = " + this.getBatchStatus());
            buf.append(", Partition Exit Status = " + this.getExitStatus());
        }
        if ((partitionProperties = this.partitionPlanConfig.getPartitionPlanProperties()) != null) {
            buf.append("\n Partition Properties = ");
            buf.append(partitionProperties);
        }
        buf.append("\n==========================================================\n");
        return buf.toString();
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getStepExecutionCreatedMessage(RuntimeStepExecution runtimeStepExecution) {
        this.partitionLevelStepExecutionId = runtimeStepExecution.getInternalStepThreadExecutionId();
        StringBuilder buf = new StringBuilder("\n");
        buf.append("==========================================================\n");
        buf.append("Invoking step execution partition, created new step execution for a partition-level step");
        buf.append("\n Partition step name = ");
        buf.append(this.getStepName());
        buf.append("\n Partition number = ");
        buf.append(this.getPartitionNumber());
        buf.append("\n Partition-level (internal) step execution id = ");
        buf.append(this.partitionLevelStepExecutionId);
        buf.append("\n Associated Top-level StepExecution id = ");
        buf.append(runtimeStepExecution.getTopLevelStepExecutionId());
        return buf.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private long getTopLevelStepExecutionId() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getTopLevelStepExecutionId", new Object[0]);
        }
        long l = this.partitionPlanConfig.getTopLevelStepExecutionId();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getTopLevelStepExecutionId", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getStepName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getStepName", new Object[0]);
        }
        String string = this.partitionPlanConfig.getStepName();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getStepName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void workStarted(Date date) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "workStarted", new Object[]{date});
        }
        this.batchStatus = BatchStatus.STARTED;
        this.publishPartitionEvent();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "workStarted");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void workStopping(Date date) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "workStopping", new Object[]{date});
        }
        this.batchStatus = BatchStatus.STOPPING;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "workStopping");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void workEnded(Date date) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "workEnded", new Object[]{date});
        }
        this.publishPartitionEvent();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "workEnded");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPartitionedStepName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getPartitionedStepName", new Object[0]);
        }
        String string = this.getStepName();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getPartitionedStepName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Integer getPartitionNumber() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getPartitionNumber", new Object[0]);
        }
        Integer n = this.partitionPlanConfig.getPartitionNumber();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getPartitionNumber", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getCorrelationId() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getCorrelationId", new Object[0]);
        }
        String string = this.partitionPlanConfig.getCorrelationId();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getCorrelationId", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateExecutionJobLogDir(String logDirPath) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "updateExecutionJobLogDir", new Object[]{logDirPath});
        }
        RemotablePartitionKey key = new RemotablePartitionKey(this.getTopLevelExecutionId(), this.getStepName(), this.getPartitionNumber());
        this.getPersistenceManagerService().updatePartitionExecutionLogDir(key, logDirPath);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "updateExecutionJobLogDir");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PartitionPlanConfig getPartitionPlanConfig() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getPartitionPlanConfig", new Object[0]);
        }
        PartitionPlanConfig partitionPlanConfig = this.partitionPlanConfig;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            partitionPlanConfig = partitionPlanConfig;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getPartitionPlanConfig", partitionPlanConfig);
        }
        return partitionPlanConfig;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void publishPartitionEvent() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "publishPartitionEvent", new Object[0]);
        }
        BatchEventsPublisher publisher = this.getBatchEventsPublisher();
        if (publisher != null) {
            String correlationId = this.getCorrelationId();
            publisher.publishPartitionEvent(this.getPartitionNumber(), this.getBatchStatus(), this.getExitStatus(), this.getPartitionedStepName(), this.getTopLevelInstanceId(), this.getTopLevelExecutionId(), this.getTopLevelStepExecutionId(), this.getPartitionTopicName(this.getBatchStatus()), correlationId);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "publishPartitionEvent");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getPartitionTopicName(BatchStatus batchStatus) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getPartitionTopicName", new Object[]{batchStatus});
        }
        switch (batchStatus) {
            case STARTED: {
                String string = "batch/jobs/execution/partition/started";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getPartitionTopicName", string);
                }
                return string;
            }
            case COMPLETED: {
                String string = "batch/jobs/execution/partition/completed";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getPartitionTopicName", string);
                }
                return string;
            }
            case STOPPED: {
                String string = "batch/jobs/execution/partition/stopped";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getPartitionTopicName", string);
                }
                return string;
            }
            case FAILED: {
                String string = "batch/jobs/execution/partition/failed";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "getPartitionTopicName", string);
                }
                return string;
            }
        }
        throw new IllegalStateException("Invalid BatchStatus for partition ended job event: " + batchStatus);
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isRemotePartitionDispatch() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "isRemotePartitionDispatch", new Object[0]);
        }
        boolean bl = this.isRemoteDispatch;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "isRemotePartitionDispatch", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setIsRemoteDispatch(boolean isRemote) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "setIsRemoteDispatch", new Object[]{isRemote});
        }
        this.isRemoteDispatch = isRemote;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "setIsRemoteDispatch");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isFinalStatusSent() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "isFinalStatusSent", new Object[0]);
        }
        boolean bl = this.finalStatusSent;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "isFinalStatusSent", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setFinalStatusSent(boolean finalStatusSent) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "setFinalStatusSent", new Object[]{finalStatusSent});
        }
        this.finalStatusSent = finalStatusSent;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution", "setFinalStatusSent");
        }
    }
}

