/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.http;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpUtils {
    public static final TraceComponent tc = Tr.register(HttpUtils.class, null, null);
    static final long serialVersionUID = 901807250888762068L;

    public HttpPost createHttpPostMethod(String url, List<NameValuePair> commonHeaders) {
        if (url == null) {
            return null;
        }
        HttpPost postMethod = new HttpPost(url);
        this.addHeadersToHttpObject((HttpRequestBase)postMethod, commonHeaders);
        return postMethod;
    }

    public HttpGet createHttpGetMethod(String url, List<NameValuePair> commonHeaders) {
        if (url == null) {
            return null;
        }
        HttpGet getMethod = new HttpGet(url);
        this.addHeadersToHttpObject((HttpRequestBase)getMethod, commonHeaders);
        return getMethod;
    }

    void addHeadersToHttpObject(HttpRequestBase requestObject, List<NameValuePair> headers) {
        if (headers == null) {
            return;
        }
        for (NameValuePair nvp : headers) {
            requestObject.addHeader(nvp.getName(), nvp.getValue());
        }
    }

    public HttpClient createHttpClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, String baUser, @Sensitive String baPassword) {
        HttpClient client = null;
        boolean addBasicAuthHeader = false;
        if (baUser != null && baPassword != null) {
            addBasicAuthHeader = true;
        }
        BasicCredentialsProvider credentialsProvider = null;
        if (addBasicAuthHeader) {
            credentialsProvider = this.createCredentialsProvider(baUser, baPassword);
        }
        client = this.createHttpClient(url.startsWith("https:"), isHostnameVerification, sslSocketFactory, addBasicAuthHeader, credentialsProvider);
        return client;
    }

    private HttpClient createHttpClient(boolean isSecure, boolean isHostnameVerification, SSLSocketFactory sslSocketFactory, boolean addBasicAuthHeader, BasicCredentialsProvider credentialsProvider) {
        CloseableHttpClient client = null;
        if (isSecure) {
            SSLConnectionSocketFactory connectionFactory = null;
            connectionFactory = !isHostnameVerification ? new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new AllowAllHostnameVerifier()) : new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new StrictHostnameVerifier());
            client = addBasicAuthHeader ? HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).build() : HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).build();
        } else {
            client = addBasicAuthHeader ? HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build() : HttpClientBuilder.create().build();
        }
        return client;
    }

    private BasicCredentialsProvider createCredentialsProvider(String baUser, @Sensitive String baPassword) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(baUser, baPassword));
        return credentialsProvider;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={Exception.class})
    protected String getHTTPRequestAsString(HttpClient httpClient, String url) throws Exception {
        String json;
        block8: {
            json = null;
            HttpGet request = new HttpGet(url);
            request.addHeader("content-type", "application/json");
            HttpResponse result = null;
            try {
                result = httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException iOException) {
                void ioex;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.common.http.HttpUtils", (String)"143", (Object)this, (Object[])new Object[]{httpClient, url});
                String errMsg = "IOException: " + ioex.getMessage() + " " + ioex.getCause();
                String message = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages", (String)"OIDC_CLIENT_DISCOVERY_ERROR", (Object[])new Object[]{url, errMsg}, (String)"Error processing discovery request");
                Tr.error((TraceComponent)tc, (String)message, (Object[])new Object[0]);
                throw ioex;
            }
            StatusLine statusLine = result.getStatusLine();
            int iStatusCode = statusLine.getStatusCode();
            if (iStatusCode == 200) {
                json = EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Response: ", (Object[])new Object[]{json});
                }
                if (json == null || json.isEmpty()) {
                    throw new Exception(this.logErrorMessage(url, iStatusCode, "empty or null json response"));
                }
                break block8;
            }
            String errMsg = statusLine.getReasonPhrase();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("status:" + iStatusCode + " errorMsg:" + errMsg), (Object[])new Object[0]);
            }
            throw new Exception(this.logErrorMessage(url, iStatusCode, errMsg));
        }
        return json;
    }

    private String logErrorMessage(String url, int iStatusCode, String errMsg) {
        String defaultMessage = "Error processing discovery request";
        String message = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages", (String)"OIDC_CLIENT_DISC_RESPONSE_ERROR", (Object[])new Object[]{url, iStatusCode, errMsg}, (String)defaultMessage);
        Tr.error((TraceComponent)tc, (String)message, (Object[])new Object[0]);
        return message;
    }

    public HttpClient createHTTPClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification) {
        CloseableHttpClient client = null;
        if (url != null && url.startsWith("http:")) {
            client = HttpClientBuilder.create().build();
        } else {
            SSLConnectionSocketFactory connectionFactory = null;
            connectionFactory = !isHostnameVerification ? new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new AllowAllHostnameVerifier()) : new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new StrictHostnameVerifier());
            client = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).build();
        }
        return client;
    }

    public HttpClient createHTTPClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, String baUser, @Sensitive String baPassword) {
        CloseableHttpClient client = null;
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(baUser, baPassword));
        if (url != null && url.toLowerCase().startsWith("http:")) {
            client = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        } else {
            SSLConnectionSocketFactory connectionFactory = null;
            connectionFactory = !isHostnameVerification ? new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new AllowAllHostnameVerifier()) : new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new StrictHostnameVerifier());
            client = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).build();
        }
        return client;
    }

    public String getHttpRequest(SSLSocketFactory sslSocketFactory, String discoveryUrl, boolean hostNameVerificationEnabled, String basicAuthIdentifier, String basicAuthSecret) throws Exception {
        HttpClient client = this.createHttpClient(sslSocketFactory, discoveryUrl, hostNameVerificationEnabled, basicAuthIdentifier, basicAuthSecret);
        if (client != null) {
            return this.getHTTPRequestAsString(client, discoveryUrl);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String invokeUrl(RequestMethod requestMethod, String url, SSLSocketFactory sslSocketFactory) throws Exception {
        try {
            HttpURLConnection connection = this.createConnection(requestMethod, url, sslSocketFactory);
            String response = this.readConnectionResponse(connection);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new Exception("Received unexpected " + responseCode + " response from " + (Object)((Object)requestMethod) + " request sent to " + url + ".");
            }
            return response;
        }
        catch (IOException connection) {
            void e;
            FFDCFilter.processException((Throwable)connection, (String)"com.ibm.ws.security.common.http.HttpUtils", (String)"243", (Object)this, (Object[])new Object[]{requestMethod, url, sslSocketFactory});
            throw new Exception("Connection to URL [" + url + "] failed. " + e, (Throwable)e);
        }
    }

    public HttpURLConnection createConnection(RequestMethod requestMethod, String url, SSLSocketFactory sslSocketFactory) throws IOException {
        HttpURLConnection connection = null;
        connection = url != null && url.toLowerCase().startsWith("https") ? this.getHttpsConnection(requestMethod, url, sslSocketFactory) : this.getHttpConnection(requestMethod, url);
        return connection;
    }

    public String readConnectionResponse(HttpURLConnection con) throws IOException {
        String line;
        InputStream responseStream = this.getResponseStream(con);
        if (responseStream == null) {
            return null;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(responseStream, "UTF-8"));
        String response = "";
        while ((line = in.readLine()) != null) {
            response = response + line;
        }
        in.close();
        return response;
    }

    HttpsURLConnection getHttpsConnection(RequestMethod requestMethod, String apiUrl, SSLSocketFactory sslSocketFactory) throws IOException {
        URL url = new URL(apiUrl);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setSSLSocketFactory(sslSocketFactory);
        connection.setRequestMethod(requestMethod.toString());
        return connection;
    }

    HttpURLConnection getHttpConnection(RequestMethod requestMethod, String apiUrl) throws IOException {
        URL url = new URL(apiUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(requestMethod.toString());
        return connection;
    }

    InputStream getResponseStream(HttpURLConnection con) throws IOException {
        InputStream responseStream = null;
        int responseCode = con.getResponseCode();
        if (responseCode < 400) {
            responseStream = con.getInputStream();
            if (responseStream == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to obtain response stream from InputStream. Getting ErrorStream instead", (Object[])new Object[0]);
                }
                responseStream = con.getErrorStream();
            }
        } else {
            responseStream = con.getErrorStream();
            if (responseStream == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to obtain response stream from ErrorStream. Getting InputStream instead", (Object[])new Object[0]);
                }
                responseStream = con.getInputStream();
            }
        }
        return responseStream;
    }

    public HttpURLConnection setHeaders(HttpURLConnection con, @Sensitive Map<String, String> headers) {
        if (headers == null) {
            return con;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            con.setRequestProperty(entry.getKey(), entry.getValue());
        }
        return con;
    }

    public static enum RequestMethod {
        GET,
        POST;

    }
}

