/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.krb5.SpnegoUtil;
import com.ibm.ws.security.spnego.SpnegoConfig;
import com.ibm.ws.security.spnego.internal.Krb5Util;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SpnegoAuthenticator {
    public static final TraceComponent tc = Tr.register(SpnegoAuthenticator.class, (String)"spnego", (String)"com.ibm.ws.security.spnego.internal.resources.SpnegoMessages");
    private HashMap<String, String> hostMap = new HashMap();
    private final Krb5Util krb5Util = new Krb5Util();
    private final AuthenticationResult CONTINUE = new AuthenticationResult(AuthResult.CONTINUE, "SPNEGO authenticator said continue...");
    private final SpnegoUtil spnegoUtil = new SpnegoUtil();
    static final long serialVersionUID = -8907961848765809679L;

    /*
     * WARNING - void declaration
     */
    public AuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse resp, String authzHeader, SpnegoConfig spnegoConfig) {
        AuthenticationResult result = this.CONTINUE;
        try {
            byte[] tokenByte = Base64Coder.base64Decode((byte[])Base64Coder.getBytes((String)this.spnegoUtil.extractAuthzTokenString(authzHeader)));
            if (!this.spnegoUtil.isSpnegoOrKrb5Token(tokenByte)) {
                return this.notSpnegoAndKerberosTokenError(resp, spnegoConfig);
            }
            String reqHostName = this.getReqHostName(req, spnegoConfig);
            result = this.krb5Util.processSpnegoToken(resp, tokenByte, reqHostName, spnegoConfig);
        }
        catch (AuthenticationException tokenByte) {
            FFDCFilter.processException((Throwable)tokenByte, (String)"com.ibm.ws.security.spnego.SpnegoAuthenticator", (String)"53", (Object)this, (Object[])new Object[]{req, resp, authzHeader, spnegoConfig});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception:", (Object[])new Object[]{e});
            }
            result = new AuthenticationResult(AuthResult.FAILURE, "SPNEGO authentication failure");
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    protected AuthenticationResult notSpnegoAndKerberosTokenError(HttpServletResponse resp, SpnegoConfig spnegoConfig) {
        if (!spnegoConfig.getDisableFailOverToAppAuthType()) {
            return this.CONTINUE;
        }
        resp.setStatus(401);
        resp.setContentType(spnegoConfig.getErrorPageConfig().getNtlmTokenReceivedPageContentType());
        resp.setCharacterEncoding(spnegoConfig.getErrorPageConfig().getNtlmTokenReceivedPageCharset());
        try {
            resp.getWriter().println(spnegoConfig.getErrorPageConfig().getNTLMTokenReceivedPage());
            WebContainerRequestState.getInstance((boolean)true).setAttribute("spnego.error.page", (Object)"true");
        }
        catch (IOException iOException) {
            void ex;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.spnego.SpnegoAuthenticator", (String)"82", (Object)this, (Object[])new Object[]{resp, spnegoConfig});
            Tr.error((TraceComponent)tc, (String)"SPNEGO_FAIL_TO_GET_WRITER", (Object[])new Object[]{"NTLMTokenReceivedPage", ex.getMessage()});
        }
        return new AuthenticationResult(AuthResult.SEND_401, "The token included in the HttpServletRequest is not a valid SPNEGO token");
    }

    /*
     * WARNING - void declaration
     */
    public AuthenticationResult createNegotiateHeader(HttpServletResponse resp, SpnegoConfig spnegoConfig) {
        resp.setStatus(401);
        resp.setHeader("WWW-Authenticate", "Negotiate");
        resp.setContentType(spnegoConfig.getErrorPageConfig().getSpnegoNotSupportedPageContentType());
        String charset = spnegoConfig.getErrorPageConfig().getSpnegoNotSupportedPageCharset();
        if (charset != null) {
            resp.setCharacterEncoding(charset);
        }
        try {
            resp.getWriter().println(spnegoConfig.getErrorPageConfig().getSpnegoNotSupportedPage());
            WebContainerRequestState.getInstance((boolean)true).setAttribute("spnego.error.page", (Object)"true");
        }
        catch (IOException iOException) {
            void ex;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.spnego.SpnegoAuthenticator", (String)"108", (Object)this, (Object[])new Object[]{resp, spnegoConfig});
            Tr.error((TraceComponent)tc, (String)"SPNEGO_FAIL_TO_GET_WRITER", (Object[])new Object[]{"SpnegoNotSupportedPage", ex.getMessage()});
        }
        AuthenticationResult authResult = new AuthenticationResult(AuthResult.TAI_CHALLENGE, "Create negotiation Http header");
        return authResult;
    }

    protected String getReqHostName(HttpServletRequest req, SpnegoConfig spnegoConfig) {
        String hostName = req.getServerName();
        if (spnegoConfig.getAllowLocalHost() && "localhost".equalsIgnoreCase(hostName)) {
            return hostName;
        }
        if (spnegoConfig.isCanonicalHostName()) {
            return this.getCanonicalHostname(spnegoConfig, hostName);
        }
        return hostName;
    }

    /*
     * WARNING - void declaration
     */
    protected String getCanonicalHostname(SpnegoConfig spnegoConfig, String hostName) {
        block4: {
            String mappedHost = this.hostMap.get(hostName);
            if (mappedHost != null) {
                hostName = mappedHost;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CanonicalSupport has converted " + hostName + " to " + mappedHost), (Object[])new Object[0]);
                }
                return hostName;
            }
            try {
                InetAddress inet = InetAddress.getByName(hostName);
                String canonicalHostName = inet.getCanonicalHostName();
                hostName = this.cacheHostName(hostName, canonicalHostName);
            }
            catch (UnknownHostException inet) {
                void ue;
                FFDCFilter.processException((Throwable)inet, (String)"com.ibm.ws.security.spnego.SpnegoAuthenticator", (String)"154", (Object)this, (Object[])new Object[]{spnegoConfig, hostName});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Canonical support specified but error when looking up - " + hostName + "failed. Aliases will not work."), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("getCanonicalHostname got unexpected exception: " + ue), (Object[])new Object[0]);
            }
        }
        return hostName;
    }

    protected String cacheHostName(String hostName, String canonicalHostName) {
        this.hostMap.put(hostName, canonicalHostName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Canonicalization support will map " + hostName + " to " + canonicalHostName), (Object[])new Object[0]);
        }
        return canonicalHostName;
    }

    protected void setHostMap(HashMap<String, String> hostMap) {
        this.hostMap = hostMap;
    }
}

