/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaConnectorConstants;
import com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaConnectorException;
import com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaInput;
import com.ibm.ws.microprofile.reactive.messaging.kafka.PartitionTrackerFactory;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaAdapterFactory;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaConsumer;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;
import org.eclipse.microprofile.reactive.messaging.spi.IncomingConnectorFactory;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@Connector(value="liberty-kafka")
@ApplicationScoped
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class KafkaIncomingConnector
implements IncomingConnectorFactory {
    private static final TraceComponent tc = Tr.register(KafkaIncomingConnector.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
    ManagedScheduledExecutorService executor;
    @Inject
    KafkaAdapterFactory kafkaAdapterFactory;
    private final List<KafkaInput<?, ?>> kafkaInputs = Collections.synchronizedList(new ArrayList());
    static final long serialVersionUID = -9192585079099587413L;

    @PostConstruct
    private void postConstruct() {
        Bundle b = FrameworkUtil.getBundle(KafkaIncomingConnector.class);
        ServiceReference mgdSchedExecSvcRef = b.getBundleContext().getServiceReference(ManagedScheduledExecutorService.class);
        this.executor = (ManagedScheduledExecutorService)b.getBundleContext().getService(mgdSchedExecSvcRef);
        if (this.executor == null) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"internal.kafka.connector.error.CWMRX1000E", (Object[])new Object[]{"The Managed Scheduled Executor Service could not be found."});
            throw new IllegalStateException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void shutdown() {
        List<KafkaInput<?, ?>> list = this.kafkaInputs;
        synchronized (list) {
            for (KafkaInput<?, ?> kafkaInput : this.kafkaInputs) {
                try {
                    kafkaInput.shutdown();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaIncomingConnector", (String)"75", (Object)this, (Object[])new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public PublisherBuilder<Message<Object>> getPublisherBuilder(Config config) {
        String channelName = (String)config.getValue("channel-name", String.class);
        try {
            Optional groupID = config.getOptionalValue("group.id", String.class);
            if (!groupID.isPresent()) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"kafka.groupid.not.set.CWMRX1005E", (Object[])new Object[]{"mp.messaging.incoming." + channelName + "." + "group.id"});
                throw new IllegalArgumentException(msg);
            }
            String topic = config.getOptionalValue("topic", String.class).orElse(channelName);
            int maxPollRecords = config.getOptionalValue("max.poll.records", Integer.class).orElse(500);
            int unackedLimit = config.getOptionalValue("unacked.limit", Integer.class).orElse(maxPollRecords);
            HashMap<String, String> consumerConfig = new HashMap<String, String>();
            consumerConfig.put("enable.auto.commit", "false");
            consumerConfig.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
            consumerConfig.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
            consumerConfig.putAll(StreamSupport.stream(config.getPropertyNames().spliterator(), false).filter(k -> !KafkaConnectorConstants.NON_KAFKA_PROPS.contains(k)).collect(Collectors.toMap(Function.identity(), k -> (String)config.getValue(k, String.class))));
            boolean enableAutoCommit = "true".equalsIgnoreCase((String)consumerConfig.get("enable.auto.commit"));
            KafkaConsumer kafkaConsumer = this.kafkaAdapterFactory.newKafkaConsumer(consumerConfig);
            PartitionTrackerFactory partitionTrackerFactory = new PartitionTrackerFactory();
            partitionTrackerFactory.setExecutor((ScheduledExecutorService)this.executor);
            partitionTrackerFactory.setAdapterFactory(this.kafkaAdapterFactory);
            partitionTrackerFactory.setAutoCommitEnabled(enableAutoCommit);
            if (enableAutoCommit) {
                unackedLimit = 0;
            }
            KafkaInput kafkaInput = new KafkaInput(this.kafkaAdapterFactory, partitionTrackerFactory, kafkaConsumer, (ExecutorService)this.executor, topic, unackedLimit);
            this.kafkaInputs.add(kafkaInput);
            return kafkaInput.getPublisher();
        }
        catch (Exception groupID) {
            void e;
            FFDCFilter.processException((Throwable)groupID, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaIncomingConnector", (String)"133", (Object)this, (Object[])new Object[]{config});
            throw new KafkaConnectorException(Tr.formatMessage((TraceComponent)tc, (String)"kafka.create.incoming.error.CWMRX1007E", (Object[])new Object[]{channelName, e.getMessage()}), (Throwable)e);
        }
    }
}

