/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.DumpActivator;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.SipContainerInterface;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.management.DynamicMBean;
import javax.management.Notification;
import javax.management.StandardMBean;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=false, service={SipContainerInterface.class, DynamicMBean.class}, property={"service.vendor=IBM", "jmx.objectname=WebSphere:name=com.ibm.ws.sip.container.SipContainerMBean"})
public class SipContainerMBean
extends StandardMBean
implements SipContainerInterface {
    private static final LogMgr c_logger = Log.get(SipContainerMBean.class);
    private final boolean _isJMXEnabled = false;
    private ExecutorService _executorService;
    private String _dumpMethod = null;
    private String _dumpDescription = null;

    @Reference(policy=ReferencePolicy.STATIC)
    protected void setExecutorService(ExecutorService service) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setExecutorService", "setting the executor service for DumpActivator");
        }
        this._executorService = service;
    }

    public SipContainerMBean() {
        super(SipContainerInterface.class, false);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        System.out.println("SipContainerMBean activated");
    }

    public void setWeight(int weight) {
        PerformanceMgr perfMgr;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setWeight", Integer.toString(weight));
        }
        if ((perfMgr = PerformanceMgr.getInstance()) != null) {
            perfMgr.setServerWeight(weight);
        }
    }

    public int getWeight() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "getWeight");
        }
        int weight = -1;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "getWeight: " + weight);
        }
        return weight;
    }

    public void quiesce(boolean b) {
        if (c_logger.isInfoEnabled()) {
            if (b) {
                c_logger.info("info.sip.container.quiesce.on", "Stop.STOP INITIATED");
            } else {
                c_logger.info("info.sip.container.quiesce.off", "Start");
            }
        }
        SipContainer.getInstance().setQuiesceAttribute(b);
    }

    public void sendOverloadedNotification() {
    }

    public void sendOverloadClearedNotification() {
    }

    public void sendNotification(Notification notification) {
    }

    @Override
    public String setDumpMethod(String method, String description) {
        this._dumpMethod = method;
        this._dumpDescription = description;
        return "Success";
    }

    public boolean dispatchActivateTask(Object dumpMethodString) {
        DumpActivator dumping = new DumpActivator(dumpMethodString);
        if (this._dumpMethod != null) {
            dumping.setDumpMethod(this._dumpMethod, this._dumpDescription);
        }
        this._executorService.execute(dumping);
        return true;
    }

    @Override
    public int dumpAllSASIds() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "dumpAllSASIds");
        }
        boolean success = this.dispatchActivateTask(DumpActivator.DUMP_SAS_IDs);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "dumpAllSASIds: " + success);
        }
        return success ? 0 : -1;
    }

    @Override
    public int dumpAllTUSipSessionIds() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "dumpAllTUSipSessionIds");
        }
        boolean success = this.dispatchActivateTask(DumpActivator.DUMP_TU_IDs);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "dumpAllTUSipSessionIds: " + success);
        }
        return success ? 0 : -1;
    }

    @Override
    public int dumpAllSASDetails() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "dumpAllSASDetails");
        }
        boolean success = this.dispatchActivateTask(DumpActivator.DUMP_SAS_DETAILs);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "dumpAllSASDetails: " + success);
        }
        return success ? 0 : -1;
    }

    @Override
    public int dumpAllTUSipSessionDetails() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "dumpAllTUSipSessionDetails");
        }
        boolean success = this.dispatchActivateTask(DumpActivator.DUMP_TU_DETAILs);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "dumpAllTUSipSessionDetails: " + success);
        }
        return success ? 0 : -1;
    }

    @Override
    public void dumpSASDetails(String sasId) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "dumpAllSASDetails, sessionId=" + sasId);
        }
        boolean success = this.dispatchActivateTask("SAS_" + sasId);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "dumpAllSASDetails: " + success);
        }
    }

    @Override
    public void dumpSipSessionDetails(String ssId) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "dumpSipSessionDetails, sessionId=" + ssId);
        }
        boolean success = this.dispatchActivateTask("SS_" + ssId);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "dumpSipSessionDetails: " + success);
        }
    }
}

