/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transactions.st;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.stack.dispatch.TimerEvent;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transactions.BranchMethodKey;
import com.ibm.ws.sip.stack.transaction.transactions.MergedRequestKey;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransactionHelper;
import com.ibm.ws.sip.stack.transaction.transactions.st.SIPServerTransactionImpl;
import com.ibm.ws.sip.stack.transaction.transport.SIPTransportException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.URI;
import jain.protocol.ip.sip.header.CSeqHeader;
import jain.protocol.ip.sip.header.CallIdHeader;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;

public class SIPNonInviteServerTransactionImpl
extends SIPServerTransactionImpl {
    public static final int STATE_TRYING = 0;
    public static final int STATE_PROCEEDING = 1;
    public static final int STATE_COMPLETED = 2;
    public static final int STATE_TERMINATED = 3;
    private Response m_mostRecentProvisionalResponse;
    private Response m_finalResponse;
    private TimerJ m_timerJ;
    private ApiTimer m_apiTimer;
    private static final LogMgr c_logger = Log.get(SIPNonInviteServerTransactionImpl.class);

    public SIPNonInviteServerTransactionImpl(SIPTransactionStack transactionStack, SipProvider provider, Request req, BranchMethodKey key, MergedRequestKey mergedRequestKey) {
        super(transactionStack, provider, req, key, mergedRequestKey);
    }

    @Override
    public synchronized void processRequest(Request sipRequest) throws SipParseException {
        try {
            switch (this.getState()) {
                case -1: {
                    this.setState(0);
                    long delay = this.getParentStack().getConfiguration().getNonInviteServerTransactionTimer();
                    this.m_apiTimer = new ApiTimer(this, this.getCallId());
                    this.addTimerTask(this.m_apiTimer, delay);
                    this.sendRequestToUA(sipRequest);
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    this.sendResponseToTransport(this.m_mostRecentProvisionalResponse);
                    break;
                }
                case 2: {
                    this.sendResponseToTransport(this.m_finalResponse);
                }
            }
        }
        catch (SIPTransportException exp) {
            this.prossesTransportError();
        }
    }

    @Override
    public synchronized void processResponse(Response sipResponse) throws SipParseException {
        try {
            switch (this.getState()) {
                case 0: {
                    if (SIPTransactionHelper.isProvionalResponse(sipResponse.getStatusCode())) {
                        this.setState(1);
                        this.m_mostRecentProvisionalResponse = sipResponse;
                        this.sendResponseToTransport(sipResponse);
                        break;
                    }
                    if (!SIPTransactionHelper.isFinalResponse(sipResponse.getStatusCode())) break;
                    this.setStateCompleted(sipResponse);
                    this.sendResponseToTransport(sipResponse);
                    break;
                }
                case 1: {
                    if (SIPTransactionHelper.isProvionalResponse(sipResponse.getStatusCode())) {
                        this.sendResponseToTransport(sipResponse);
                        break;
                    }
                    if (!SIPTransactionHelper.isFinalResponse(sipResponse.getStatusCode())) break;
                    this.setStateCompleted(sipResponse);
                    this.sendResponseToTransport(sipResponse);
                    break;
                }
            }
        }
        catch (SIPTransportException exp) {
            this.prossesTransportError();
        }
    }

    private void setStateCompleted(Response sipResponse) {
        this.m_finalResponse = sipResponse;
        this.setState(2);
        this.m_apiTimer.cancel();
        if (!this.isTransportReliable()) {
            long delay = this.getParentStack().getConfiguration().getTimerJ();
            this.m_timerJ = new TimerJ(this, this.getCallId());
            this.addTimerTask(this.m_timerJ, delay);
        } else {
            this.destroyTransaction();
        }
    }

    @Override
    public synchronized void prossesTransportError() {
        Response lastResponcse = null;
        if (this.m_finalResponse != null) {
            lastResponcse = this.m_finalResponse;
        } else if (this.m_mostRecentProvisionalResponse != null) {
            lastResponcse = this.m_mostRecentProvisionalResponse;
        }
        this.destroyTransaction();
        this.notifyRespnseErrorToUA(lastResponcse);
    }

    @Override
    public synchronized Response getMostRecentResponse() {
        Response retVal = null;
        if (this.m_finalResponse != null) {
            retVal = this.m_finalResponse;
        } else if (this.m_mostRecentProvisionalResponse != null) {
            retVal = this.m_mostRecentProvisionalResponse;
        }
        return retVal;
    }

    @Override
    public synchronized void destroyTransaction() {
        this.setState(3);
        if (this.m_timerJ != null) {
            this.m_timerJ.cancel();
        }
        this.m_apiTimer.cancel();
        this.remove();
    }

    void timerJfired() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "timerJfired", "Timer J fired on transaction " + this.toString());
        }
        this.updateSipTimersInvocationsPMICounter();
        if (this.getState() != 2) {
            this.notifyTimeOutToUA();
        }
        this.destroyTransaction();
    }

    void timerApifired() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "timerApifired", "Timer API fired on transaction " + this.toString());
        }
        if (this.getState() != 2) {
            this.notifyTimeOutToUA();
        }
        this.destroyTransaction();
    }

    @Override
    protected boolean is2543RequestPartOfTransaction(Request req, ViaHeader oldVia, ViaHeader newVia) {
        String newMethod;
        String newFromTag;
        URI newRequestURI;
        URI oldRequestURI;
        String oldFromTag;
        Request initial = this.getFirstRequest();
        String oldToTag = initial.getToHeader().getTag();
        if (oldToTag == null) {
            oldToTag = "";
        }
        if ((oldFromTag = initial.getFromHeader().getTag()) == null) {
            oldFromTag = "";
        }
        CallIdHeader oldCallId = initial.getCallIdHeader();
        CSeqHeader oldCSeq = initial.getCSeqHeader();
        try {
            oldRequestURI = initial.getRequestURI();
            newRequestURI = req.getRequestURI();
        }
        catch (SipParseException e2) {
            return false;
        }
        String newToTag = req.getToHeader().getTag();
        if (newToTag == null) {
            newToTag = "";
        }
        if ((newFromTag = req.getFromHeader().getTag()) == null) {
            newFromTag = "";
        }
        CallIdHeader newCallId = req.getCallIdHeader();
        CSeqHeader newCSeq = req.getCSeqHeader();
        try {
            newMethod = req.getMethod();
        }
        catch (SipParseException e3) {
            return false;
        }
        boolean match = newMethod.equals("INVITE") ? false : (newMethod.equals("ACK") ? false : newRequestURI.equals(oldRequestURI) && newToTag.equals(oldToTag) && newFromTag.equals(oldFromTag) && newCallId.equals(oldCallId) && newCSeq.equals(oldCSeq) && newVia.equals(oldVia));
        return match;
    }

    @Override
    public LogMgr getLoger() {
        return c_logger;
    }

    @Override
    protected String getType() {
        return "Server non-INVITE";
    }

    @Override
    public String getStateAsString() {
        switch (this.getState()) {
            case 0: {
                return "Trying";
            }
            case 1: {
                return "Proceeding";
            }
            case 2: {
                return "Completed";
            }
            case 3: {
                return "Terminated";
            }
        }
        return super.getStateAsString();
    }

    static class ApiTimer
    extends TimerEvent {
        SIPNonInviteServerTransactionImpl m_st;

        ApiTimer(SIPNonInviteServerTransactionImpl st, String callId) {
            super(callId);
            this.m_st = st;
        }

        @Override
        public void onExecute() {
            this.m_st.timerApifired();
        }

        @Override
        public boolean cancel() {
            return super.cancel();
        }
    }

    static class TimerJ
    extends TimerEvent {
        SIPNonInviteServerTransactionImpl m_st;

        TimerJ(SIPNonInviteServerTransactionImpl st, String callId) {
            super(callId);
            this.m_st = st;
        }

        @Override
        public void onExecute() {
            this.m_st.timerJfired();
        }

        @Override
        public boolean cancel() {
            return super.cancel();
        }
    }
}

