/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.async;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.async.AsyncContextImpl;
import com.ibm.ws.webcontainer.async.AsyncListenerEnum;
import com.ibm.ws.webcontainer.async.ListenerHelper;
import com.ibm.ws.webcontainer.async.ServiceWrapper;
import com.ibm.ws.webcontainer.srt.SRTServletRequestThreadData;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.async.WrapperRunnable;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WrapperRunnableImpl
extends ServiceWrapper
implements WrapperRunnable {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.wsspi.webcontainer.async");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.async.WrapperRunnableImpl";
    private Runnable runnable;
    private AsyncContextImpl asyncContext;
    private SRTServletRequestThreadData requestDataOnStartRequestThread;
    private AtomicBoolean running = new AtomicBoolean(false);

    public WrapperRunnableImpl(Runnable run, AsyncContextImpl asyncContext) {
        super(asyncContext);
        this.runnable = run;
        this.asyncContext = asyncContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "constructor", " " + this);
        }
        this.requestDataOnStartRequestThread = new SRTServletRequestThreadData();
        this.requestDataOnStartRequestThread.init(SRTServletRequestThreadData.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "run", this);
        }
        if (!this.asyncContext.transferContext()) {
            this.popContextData();
        }
        AsyncContextImpl asyncContextImpl = this.asyncContext;
        synchronized (asyncContextImpl) {
            this.asyncContext.removeStartRunnable(this);
        }
        if (!this.getAndSetRunning(true)) {
            WebContainerRequestState reqState;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "run", "running");
            }
            if ((reqState = WebContainerRequestState.getInstance(false)) != null) {
                reqState.init();
            }
            SRTServletRequestThreadData.getInstance().init(this.requestDataOnStartRequestThread);
            try {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "run", "Context Class loader before run: " + Thread.currentThread().getContextClassLoader());
                }
                this.runnable.run();
            }
            catch (Throwable th) {
                logger.logp(Level.WARNING, CLASS_NAME, "run", "error.occurred.during.async.servlet.handling", th);
                ListenerHelper.invokeAsyncErrorHandling(this.asyncContext, reqState, th, AsyncListenerEnum.ERROR, ListenerHelper.ExecuteNextRunnable.FALSE, ListenerHelper.CheckDispatching.TRUE);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "run", "not running because it has already ran or been cancelled");
        }
        if (!this.asyncContext.transferContext()) {
            this.resetContextData();
        }
        SRTServletRequestThreadData.getInstance().init(null);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "run", this);
        }
    }

    public String toString() {
        return "WrapperRunnable hashCode->" + this.hashCode() + ", start(runnable)->" + this.runnable;
    }

    @Override
    public boolean getAndSetRunning(boolean b) {
        return this.running.getAndSet(b);
    }
}

