/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.adaptor;

import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArchiveAdaptor {
    static final String WLP_USR = "wlp/usr";

    static boolean write(boolean tmpFile, List<File> installedFiles, File fileToWrite, InputStream inputStream, InstallConstants.ExistsAction existsAction, String fileToWriteChecksum) throws IOException, InstallException {
        return ArchiveAdaptor.write(tmpFile, installedFiles, fileToWrite, null, new InstallUtils.InputStreamFileWriter(inputStream), existsAction, fileToWriteChecksum);
    }

    static boolean write(boolean tmpFile, List<File> installedFiles, File fileToWrite, String toFileEncoding, InstallUtils.FileWriter fileWriter, InstallConstants.ExistsAction existsAction, String fileToWriteChecksum) throws IOException, InstallException {
        if (!tmpFile && fileToWrite.exists() && existsAction != InstallConstants.ExistsAction.replace) {
            if (existsAction == InstallConstants.ExistsAction.fail) {
                if (installedFiles.contains(fileToWrite) || InstallUtils.isFileSame(fileToWrite, null, null, fileToWriteChecksum)) {
                    return false;
                }
                throw new InstallException(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.file.exists", fileToWrite));
            }
            if (existsAction == InstallConstants.ExistsAction.ignore) {
                Logger.getLogger("com.ibm.ws.install").log(Level.FINEST, fileToWrite.getAbsolutePath() + " was not installed because it already exists.");
                return false;
            }
        }
        if (InstallUtils.mkdirs(installedFiles, fileToWrite.getParentFile())) {
            if (installedFiles != null) {
                installedFiles.add(fileToWrite);
            }
        } else {
            throw new InstallException(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.dir.create.fail", fileToWrite.getParentFile()), 25);
        }
        fileWriter.writeToFile(fileToWrite, toFileEncoding);
        return true;
    }
}

