/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.inbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.internal.CallbackIDs;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundLink;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.InterChannelCallback;
import com.ibm.wsspi.channelfw.VirtualConnection;

public class HttpIgnoreBodyCallback
implements InterChannelCallback {
    private static final TraceComponent tc = Tr.register(HttpIgnoreBodyCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static HttpIgnoreBodyCallback myInstance = null;

    private HttpIgnoreBodyCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpIgnoreBodyCallback();
        }
    }

    public static final HttpIgnoreBodyCallback getRef() {
        if (null == myInstance) {
            HttpIgnoreBodyCallback.createSingleton();
        }
        return myInstance;
    }

    public void complete(VirtualConnection vc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called: " + vc), (Object[])new Object[0]);
        }
        if (null == vc) {
            return;
        }
        Object o = vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC);
        if (null == o) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR: null ISC in complete()", (Object[])new Object[0]);
            }
            return;
        }
        HttpInboundServiceContextImpl sc = (HttpInboundServiceContextImpl)o;
        try {
            VirtualConnection rc = null;
            do {
                WsByteBuffer buffer;
                if (null == (buffer = sc.getRequestBodyBuffer())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Reached end of the body being purged", (Object[])new Object[0]);
                    }
                    sc.getLink().close(vc, null);
                    return;
                }
                buffer.release();
                rc = sc.getRequestBodyBuffer(this, false);
            } while (null != rc);
        }
        catch (Exception purgeException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception purging request body: " + purgeException), (Object[])new Object[0]);
            }
            sc.getLink().close(vc, purgeException);
        }
    }

    public void error(VirtualConnection vc, Throwable t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called: " + vc), (Object[])new Object[0]);
        }
        if (null == vc) {
            return;
        }
        Object o = vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL);
        if (null == o) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR: null ICL in error()", (Object[])new Object[0]);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Error occurring while purging body: " + t), (Object[])new Object[0]);
        }
        ((HttpInboundLink)((Object)o)).close(vc, (Exception)t);
    }
}

