/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.tai.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.tai.TAIService;
import com.ibm.ws.security.authentication.tai.TAIUtil;
import com.ibm.ws.security.authentication.tai.internal.InterceptorConfigImpl;
import com.ibm.ws.security.authentication.tai.internal.TAIConfigImpl;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TAIServiceImpl
implements TAIService {
    private static final TraceComponent tc = Tr.register(TAIServiceImpl.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.tai.internal.resources.TAIMessages");
    private static final String KEY_INTERCEPTOR_SERVICE = "interceptorService";
    private static final String KEY_ID = "id";
    private final ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef = new ConcurrentServiceReferenceMap("interceptorService");
    private TAIConfigImpl taiConfig = null;
    private final Map<String, TrustAssociationInterceptor> invokeBeforeSSOTais = new LinkedHashMap<String, TrustAssociationInterceptor>();
    private final Map<String, TrustAssociationInterceptor> invokeAfterSSOTais = new LinkedHashMap<String, TrustAssociationInterceptor>();
    private final Map<String, Boolean> disableLtpaCookieTais = new HashMap<String, Boolean>();
    private final Set<String> orderOfInterceptorIds = new TreeSet<String>();
    static final long serialVersionUID = -7070427789064377826L;

    protected synchronized void setInterceptorService(ServiceReference<TrustAssociationInterceptor> ref) {
        String id = this.getComponentId(ref);
        this.orderOfInterceptorIds.add(id);
        this.interceptorServiceRef.putReference((Object)id, ref);
        this.initTAI(id);
    }

    protected synchronized void unsetInterceptorService(ServiceReference<TrustAssociationInterceptor> ref) {
        String id = this.getComponentId(ref);
        this.orderOfInterceptorIds.remove(id);
        this.interceptorServiceRef.removeReference((Object)id, ref);
        this.clearTaiMaps(id);
    }

    protected synchronized void activate(ComponentContext cc, Map<String, Object> props) {
        this.interceptorServiceRef.activate(cc);
        this.taiConfig = new TAIConfigImpl(props);
        this.initAllTAIs(null);
    }

    protected synchronized void modified(Map<String, Object> props) {
        this.taiConfig = new TAIConfigImpl(props);
    }

    protected synchronized void deactivate(ComponentContext cc) {
        this.interceptorServiceRef.deactivate(cc);
        this.orderOfInterceptorIds.clear();
        this.clearTaiMaps();
    }

    void initAllTAIs(String newTaiId) {
        if (newTaiId != null) {
            this.orderOfInterceptorIds.add(newTaiId);
        }
        this.clearTaiMaps();
        for (String id : this.orderOfInterceptorIds) {
            this.initTAI(id);
        }
    }

    void initTAI(String id) {
        Object interceptor = this.interceptorServiceRef.getService((Object)id);
        if (interceptor != null) {
            if (interceptor instanceof InterceptorConfigImpl) {
                this.processSharedLibrary(id, (InterceptorConfigImpl)interceptor);
            } else if (interceptor instanceof TrustAssociationInterceptor) {
                this.processUserFeature(id, (TrustAssociationInterceptor)interceptor);
            }
            this.printTaiMap();
        } else {
            this.clearTaiMaps(id);
        }
    }

    private void printTaiMap() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("invokeBeforeSSOTais " + this.invokeBeforeSSOTais.toString()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("invokeAfterSSOTais  " + this.invokeAfterSSOTais.toString()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("disableLtpaCookieTais " + this.disableLtpaCookieTais.toString()), (Object[])new Object[0]);
            this.taiConfig.printTaiConfig();
        }
    }

    private void processSharedLibrary(String id, InterceptorConfigImpl itcConf) {
        TrustAssociationInterceptor tai = itcConf.getInterceptorInstance(this);
        this.updateTaiMaps(id, tai, itcConf.isInvokeBeforeSSO(), itcConf.isInvokeAfterSSO(), null);
    }

    private void processUserFeature(String id, TrustAssociationInterceptor tai) {
        TAIUtil taiUtil = new TAIUtil(this.interceptorServiceRef, id);
        this.updateTaiMaps(id, tai, taiUtil.isInvokeBeforeSSO(), taiUtil.isInvokeAfterSSO(), taiUtil.isDisableLtpaCookie());
    }

    private void updateTaiMaps(String id, TrustAssociationInterceptor tai, boolean beforeSso, boolean afterSso, Object disableLtpaCookie) {
        if (beforeSso) {
            this.invokeBeforeSSOTais.put(id, tai);
        }
        if (afterSso) {
            this.invokeAfterSSOTais.put(id, tai);
        }
        if (disableLtpaCookie != null) {
            this.disableLtpaCookieTais.put(id, (boolean)((Boolean)disableLtpaCookie));
        }
    }

    @Override
    public Map<String, TrustAssociationInterceptor> getTais(boolean beforeSso) {
        if (beforeSso) {
            return this.invokeBeforeSSOTais;
        }
        return this.invokeAfterSSOTais;
    }

    @Override
    public boolean isInvokeForUnprotectedURI() {
        return this.taiConfig.isInvokeForUnprotectedURI();
    }

    @Override
    public boolean isInvokeForFormLogin() {
        return this.taiConfig.isInvokeForFormLogin();
    }

    @Override
    public boolean isFailOverToAppAuthType() {
        return this.taiConfig.isFailOverToAppAuthType();
    }

    @Override
    public boolean isDisableLtpaCookie(String taiId) {
        if (this.disableLtpaCookieTais.get(taiId) != null) {
            return this.disableLtpaCookieTais.get(taiId);
        }
        return this.taiConfig.isDisableLtpaCookie();
    }

    private void clearTaiMaps() {
        this.invokeBeforeSSOTais.clear();
        this.invokeAfterSSOTais.clear();
        this.disableLtpaCookieTais.clear();
    }

    private void clearTaiMaps(String entry) {
        this.invokeBeforeSSOTais.remove(entry);
        this.invokeAfterSSOTais.remove(entry);
        this.disableLtpaCookieTais.remove(entry);
    }

    private String getComponentId(ServiceReference<TrustAssociationInterceptor> ref) {
        String id = (String)ref.getProperty(KEY_ID);
        if (id == null && (id = (String)ref.getProperty("component.name")) == null) {
            id = (String)ref.getProperty("component.id");
        }
        return id;
    }
}

