/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.collector.manager.buffer.BufferManagerEMQHelper;
import com.ibm.ws.collector.manager.buffer.BufferManagerImpl;
import com.ibm.ws.collector.manager.buffer.SimpleRotatingSoftQueue;
import com.ibm.ws.kernel.boot.logging.LoggerHandlerManager;
import com.ibm.ws.kernel.boot.logging.WsLogManager;
import com.ibm.ws.logging.RoutedMessage;
import com.ibm.ws.logging.WsMessageRouter;
import com.ibm.ws.logging.WsTraceRouter;
import com.ibm.ws.logging.collector.CollectorJsonHelpers;
import com.ibm.ws.logging.data.AccessLogData;
import com.ibm.ws.logging.data.AuditData;
import com.ibm.ws.logging.data.FFDCData;
import com.ibm.ws.logging.data.JSONObject;
import com.ibm.ws.logging.data.LogTraceData;
import com.ibm.ws.logging.internal.PackageProcessor;
import com.ibm.ws.logging.internal.TraceSpecification;
import com.ibm.ws.logging.internal.WsLogRecord;
import com.ibm.ws.logging.internal.impl.BaseTraceFormatter;
import com.ibm.ws.logging.internal.impl.ConsoleLogHandler;
import com.ibm.ws.logging.internal.impl.FileLogHeader;
import com.ibm.ws.logging.internal.impl.LogProviderConfigImpl;
import com.ibm.ws.logging.internal.impl.LoggingConfigUtils;
import com.ibm.ws.logging.internal.impl.LoggingConstants;
import com.ibm.ws.logging.internal.impl.LoggingFileUtils;
import com.ibm.ws.logging.internal.impl.MessageLogHandler;
import com.ibm.ws.logging.internal.impl.RoutedMessageImpl;
import com.ibm.ws.logging.source.LogSource;
import com.ibm.ws.logging.source.TraceSource;
import com.ibm.ws.logging.utils.CollectorManagerPipelineUtils;
import com.ibm.ws.logging.utils.FileLogHolder;
import com.ibm.ws.logging.utils.RecursionCounter;
import com.ibm.ws.logging.utils.SequenceNumber;
import com.ibm.wsspi.collector.manager.SynchronousHandler;
import com.ibm.wsspi.logging.MessageRouter;
import com.ibm.wsspi.logprovider.LogProviderConfig;
import com.ibm.wsspi.logprovider.TrService;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class BaseTraceService
implements TrService {
    static final PrintStream rawSystemOut = System.out;
    static final PrintStream rawSystemErr = System.err;
    protected final SystemLogHolder systemOut;
    protected final SystemLogHolder systemErr;
    public static final Object NULL_ID = null;
    public static final Logger NULL_LOGGER = null;
    public static final String NULL_FORMATTED_MSG = null;
    protected static RecursionCounter counterForTraceRouter = new RecursionCounter();
    protected static RecursionCounter counterForMessageRouter = new RecursionCounter();
    protected static RecursionCounter counterForTraceSource = new RecursionCounter();
    protected static RecursionCounter counterForTraceWriter = new RecursionCounter();
    protected static RecursionCounter counterForLogSource = new RecursionCounter();
    private static final int MINUTE = 60000;
    protected final AtomicReference<MessageRouter> externalMessageRouter = new AtomicReference();
    protected final AtomicReference<WsMessageRouter> internalMessageRouter = new AtomicReference();
    protected final AtomicReference<WsTraceRouter> internalTraceRouter = new AtomicReference();
    protected volatile Level consoleLogLevel = WsLevel.AUDIT;
    protected volatile boolean copySystemStreams = true;
    protected volatile BaseTraceFormatter formatter;
    protected volatile boolean isoDateFormat = false;
    protected volatile TraceWriter messagesLog = null;
    protected volatile TraceWriter traceLog = null;
    protected TeePrintStream teeOut = null;
    protected TeePrintStream teeErr = null;
    private String logHeader;
    private boolean javaLangInstrument;
    private boolean isHpelEnabled;
    private volatile Collection<String> hideMessageids;
    protected volatile Queue<RoutedMessage> earlierMessages = new SimpleRotatingSoftQueue<RoutedMessage>(new RoutedMessage[100]);
    protected volatile Queue<RoutedMessage> earlierTraces = new SimpleRotatingSoftQueue<RoutedMessage>(new RoutedMessage[200]);
    protected volatile LogSource logSource = null;
    protected volatile TraceSource traceSource = null;
    protected volatile MessageLogHandler messageLogHandler = null;
    protected volatile ConsoleLogHandler consoleLogHandler = null;
    protected volatile BufferManagerImpl logConduit;
    protected volatile BufferManagerImpl traceConduit;
    protected volatile CollectorManagerPipelineUtils collectorMgrPipelineUtils = null;
    protected volatile Timer earlyMessageTraceKiller_Timer = new Timer();
    protected volatile String serverName = null;
    protected volatile String wlpUserDir = null;
    private static final String OMIT_FIELDS_STRING = "@@@OMIT@@@";
    private static ThreadLocal<StackTraceFlags> traceFlags = new ThreadLocal<StackTraceFlags>(){

        @Override
        protected StackTraceFlags initialValue() {
            return new StackTraceFlags();
        }
    };

    public BaseTraceService() {
        this.systemOut = new SystemLogHolder("SystemOut", System.out);
        this.systemErr = new SystemLogHolder("SystemErr", System.err);
        this.earlyMessageTraceKiller_Timer.schedule((TimerTask)new EarlyMessageTraceCleaner(), 300000L);
    }

    @Override
    public void init(LogProviderConfig config) {
        this.isHpelEnabled = WsLogManager.isBinaryLoggingEnabled();
        this.update(config);
        this.registerLoggerHandlerSingleton();
        this.captureSystemStreams();
        BufferManagerEMQHelper.removeEMQByTimer();
    }

    protected void registerLoggerHandlerSingleton() {
        LoggerHandlerManager.setSingleton((Handler)new Handler(){

            @Override
            public void publish(LogRecord logRecord) {
                BaseTraceService.this.publishLogRecord(logRecord);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        });
    }

    protected void unregisterLoggerHandlerSingleton() {
        LoggerHandlerManager.unsetSingleton();
    }

    @Override
    public synchronized void update(LogProviderConfig config) {
        ArrayList<String> filteredList;
        LogProviderConfigImpl trConfig = (LogProviderConfigImpl)config;
        this.logHeader = trConfig.getLogHeader();
        this.javaLangInstrument = trConfig.hasJavaLangInstrument();
        this.consoleLogLevel = trConfig.getConsoleLogLevel();
        this.copySystemStreams = trConfig.copySystemStreams();
        this.hideMessageids = trConfig.getMessagesToHide();
        if (this.hideMessageids.size() > 0 && !this.isHpelEnabled) {
            this.logHeader = this.logHeader.concat("Suppressed message ids: " + this.hideMessageids).concat(LoggingConstants.nl);
        }
        if (this.formatter == null || trConfig.getTraceFormat() != this.formatter.getTraceFormat()) {
            this.formatter = new BaseTraceFormatter(trConfig.getTraceFormat());
        }
        this.isoDateFormat = trConfig.getIsoDateFormat();
        if (this.isoDateFormat != BaseTraceFormatter.useIsoDateFormat) {
            BaseTraceFormatter.useIsoDateFormat = this.isoDateFormat;
        }
        BaseTraceService.applyJsonFields(trConfig.getjsonFields());
        this.initializeWriters(trConfig);
        if (this.hideMessageids.size() > 0) {
            String msgKey = this.isHpelEnabled ? "MESSAGES_CONFIGURED_HIDDEN_HPEL" : "MESSAGES_CONFIGURED_HIDDEN_2";
            Tr.info(TraceSpecification.getTc(), msgKey, this.hideMessageids);
        }
        this.serverName = trConfig.getServerName();
        this.wlpUserDir = trConfig.getWlpUsrDir();
        if (this.collectorMgrPipelineUtils == null) {
            this.collectorMgrPipelineUtils = CollectorManagerPipelineUtils.getInstance();
        }
        this.logSource = this.collectorMgrPipelineUtils.getLogSource();
        this.traceSource = this.collectorMgrPipelineUtils.getTraceSource();
        this.logConduit = this.collectorMgrPipelineUtils.getLogConduit();
        this.traceConduit = this.collectorMgrPipelineUtils.getTraceConduit();
        String messageFormat = trConfig.getMessageFormat();
        String consoleFormat = trConfig.getConsoleFormat();
        ArrayList<String> messageSourceList = new ArrayList<String>(trConfig.getMessageSource());
        ArrayList<String> consoleSourceList = new ArrayList<String>(trConfig.getConsoleSource());
        List<String> filterdMessageSourceList = this.filterSourcelist(messageSourceList);
        List<String> filterdConsoleSourceList = this.filterSourcelist(consoleSourceList);
        if (this.messageLogHandler == null && this.messagesLog != null) {
            this.messageLogHandler = new MessageLogHandler(this.serverName, this.wlpUserDir, filterdMessageSourceList);
            this.collectorMgrPipelineUtils.setMessageHandler(this.messageLogHandler);
            this.messageLogHandler.setWriter(this.messagesLog);
        }
        if (this.consoleLogHandler == null) {
            this.consoleLogHandler = new ConsoleLogHandler(this.serverName, this.wlpUserDir, filterdConsoleSourceList);
            this.collectorMgrPipelineUtils.setConsoleHandler(this.consoleLogHandler);
            this.consoleLogHandler.setWriter(this.systemOut, this.systemErr);
            this.consoleLogHandler.setBaseTraceService(this);
        }
        this.commonMessageLogHandlerUpdates();
        this.commonConsoleLogHandlerUpdates();
        if ((messageFormat.toLowerCase().equals("simple") || messageFormat.toLowerCase().equals("basic") || !LoggingConfigUtils.isMessageFormatValueValid(messageFormat)) && this.messageLogHandler != null) {
            this.messageLogHandler.setFormat("simple");
            this.messageLogHandler.modified(new ArrayList<String>());
            filteredList = new ArrayList<String>();
            filteredList.add("message");
            this.updateConduitSyncHandlerConnection(filteredList, this.messageLogHandler);
        }
        if ((consoleFormat.toLowerCase().equals("dev") || consoleFormat.toLowerCase().equals("basic") || consoleFormat.toLowerCase().equals("simple") || !LoggingConfigUtils.isConsoleFormatValueValid(consoleFormat)) && this.consoleLogHandler != null) {
            if (consoleFormat.toLowerCase().equals("simple")) {
                this.consoleLogHandler.setFormat("simple");
            } else {
                this.consoleLogHandler.setFormat("dev");
            }
            filteredList = new ArrayList();
            filteredList.add("message");
            if (this.traceLog == this.systemOut) {
                filteredList.add("trace");
                this.consoleLogHandler.setTraceStdout(true);
            } else {
                this.consoleLogHandler.setTraceStdout(false);
            }
            this.consoleLogHandler.modified(new ArrayList<String>());
            this.updateConduitSyncHandlerConnection(filteredList, this.consoleLogHandler);
        }
        if (messageFormat.toLowerCase().equals("json") && this.messageLogHandler != null) {
            this.messageLogHandler.setFormat("json");
            this.messageLogHandler.modified(filterdMessageSourceList);
            this.updateConduitSyncHandlerConnection(messageSourceList, this.messageLogHandler);
        }
        if (consoleFormat.toLowerCase().equals("json") && this.consoleLogHandler != null) {
            this.consoleLogHandler.setFormat("json");
            this.consoleLogHandler.modified(filterdConsoleSourceList);
            this.updateConduitSyncHandlerConnection(consoleSourceList, this.consoleLogHandler);
        }
    }

    public static void applyJsonFields(String value) {
        String[] keyValuePairs;
        if (value == null || value == "" || value.isEmpty()) {
            AccessLogData.resetJsonLoggingNameAliases();
            FFDCData.resetJsonLoggingNameAliases();
            LogTraceData.resetJsonLoggingNameAliasesMessage();
            LogTraceData.resetJsonLoggingNameAliasesTrace();
            AuditData.resetJsonLoggingNameAliases();
            return;
        }
        TraceComponent tc = Tr.register(LogTraceData.class, "logging", "com.ibm.ws.logging.internal.resources.LoggingMessages");
        boolean valueFound = false;
        boolean isInvalidEventType = false;
        HashMap<String, String> messageMap = new HashMap<String, String>();
        HashMap<String, String> traceMap = new HashMap<String, String>();
        HashMap<String, String> ffdcMap = new HashMap<String, String>();
        HashMap<String, String> accessLogMap = new HashMap<String, String>();
        HashMap<String, String> auditMap = new HashMap<String, String>();
        List<String> LogTraceList = Arrays.asList(LogTraceData.NAMES1_1);
        List<String> FFDCList = Arrays.asList(FFDCData.NAMES1_1);
        List<String> AccessLogList = Arrays.asList(AccessLogData.NAMES1_1);
        List<String> AuditList = Arrays.asList(AuditData.NAMES1_1);
        for (String pair : keyValuePairs = value.split(",")) {
            if ((pair = pair.trim()).endsWith(":")) {
                pair = pair + OMIT_FIELDS_STRING;
            }
            String[] entry = pair.split(":");
            entry[0] = entry[0].trim();
            if (entry.length == 2) {
                entry[1] = entry[1].trim();
                if (LogTraceList.contains(entry[0])) {
                    messageMap.put(entry[0], entry[1]);
                    traceMap.put(entry[0], entry[1]);
                    valueFound = true;
                }
                if (FFDCList.contains(entry[0])) {
                    ffdcMap.put(entry[0], entry[1]);
                    valueFound = true;
                }
                if (AccessLogList.contains(entry[0])) {
                    accessLogMap.put(entry[0], entry[1]);
                    valueFound = true;
                }
                if (AuditList.contains(entry[0])) {
                    auditMap.put(entry[0], entry[1]);
                    valueFound = true;
                }
                if (entry[0].startsWith("ext_")) {
                    messageMap.put(entry[0], entry[1]);
                    traceMap.put(entry[0], entry[1]);
                    valueFound = true;
                }
                if (!valueFound) {
                    Tr.warning(tc, "JSON_FIELDS_NO_MATCH", new Object[0]);
                }
                valueFound = false;
                continue;
            }
            if (entry.length == 3) {
                entry[1] = entry[1].trim();
                entry[2] = entry[2].trim();
                if ("message".equals(entry[0])) {
                    if (LogTraceList.contains(entry[1]) || entry[1].startsWith("ext_")) {
                        messageMap.put(entry[1], entry[2]);
                        valueFound = true;
                    }
                } else if ("trace".equals(entry[0])) {
                    if (LogTraceList.contains(entry[1]) || entry[1].startsWith("ext_")) {
                        traceMap.put(entry[1], entry[2]);
                        valueFound = true;
                    }
                } else if ("ffdc".equals(entry[0])) {
                    if (FFDCList.contains(entry[1])) {
                        ffdcMap.put(entry[1], entry[2]);
                        valueFound = true;
                    }
                } else if ("accessLog".equals(entry[0])) {
                    if (AccessLogList.contains(entry[1])) {
                        accessLogMap.put(entry[1], entry[2]);
                        valueFound = true;
                    }
                } else if ("audit".equals(entry[0])) {
                    if (AuditList.contains(entry[1])) {
                        auditMap.put(entry[1], entry[2]);
                        valueFound = true;
                    }
                } else {
                    isInvalidEventType = true;
                    Tr.warning(tc, "JSON_FIELDS_INCORRECT_EVENT_TYPE", new Object[0]);
                }
                if (!valueFound && !isInvalidEventType) {
                    Tr.warning(tc, "JSON_FIELDS_NO_MATCH", new Object[0]);
                }
                valueFound = false;
                isInvalidEventType = false;
                continue;
            }
            Tr.warning(tc, "JSON_FIELDS_FORMAT_WARNING_2", new Object[0]);
        }
        AccessLogData.newJsonLoggingNameAliases(accessLogMap);
        FFDCData.newJsonLoggingNameAliases(ffdcMap);
        LogTraceData.newJsonLoggingNameAliasesMessage(messageMap);
        LogTraceData.newJsonLoggingNameAliasesTrace(traceMap);
        AuditData.newJsonLoggingNameAliases(auditMap);
        CollectorJsonHelpers.updateFieldMappings();
    }

    private void commonConsoleLogHandlerUpdates() {
        if (this.consoleLogHandler != null) {
            this.consoleLogHandler.setBasicFormatter(this.formatter);
            this.consoleLogHandler.setConsoleLogLevel(this.consoleLogLevel.intValue());
            this.consoleLogHandler.setCopySystemStreams(this.copySystemStreams);
        }
    }

    private void commonMessageLogHandlerUpdates() {
        if (this.messageLogHandler != null) {
            this.messageLogHandler.setWriter(this.messagesLog);
            this.messageLogHandler.setBasicFormatter(this.formatter);
        }
    }

    @Override
    public void stop() {
        this.restoreSystemStreams();
        this.unregisterLoggerHandlerSingleton();
        LoggingFileUtils.tryToClose(this.messagesLog);
        LoggingFileUtils.tryToClose(this.traceLog);
    }

    @Override
    public void register(TraceComponent tc) {
    }

    @Override
    public void info(TraceComponent tc, String msgKey, Object ... o) {
        WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.INFO, msgKey, o);
        this.publishLogRecord(logRecord);
    }

    @Override
    public void audit(TraceComponent tc, String msgKey, Object ... o) {
        WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, WsLevel.AUDIT, msgKey, o);
        this.publishLogRecord(logRecord);
    }

    @Override
    public void warning(TraceComponent tc, String msgKey, Object ... o) {
        WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.WARNING, msgKey, o);
        this.publishLogRecord(logRecord);
    }

    @Override
    public void error(TraceComponent tc, String msgKey, Object ... o) {
        WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, WsLevel.ERROR, msgKey, o);
        this.publishLogRecord(logRecord);
    }

    @Override
    public void fatal(TraceComponent tc, String msgKey, Object ... o) {
        WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, WsLevel.FATAL, msgKey, o);
        this.publishLogRecord(logRecord);
    }

    @Override
    public void debug(TraceComponent tc, String txt, Object ... o) {
        if (tc.isDebugEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINEST, txt, o);
            this.publishTraceLogRecord(this.traceLog, logRecord, NULL_ID, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void debug(TraceComponent tc, Object id, String txt, Object ... o) {
        if (tc.isDebugEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINEST, txt, o);
            this.publishTraceLogRecord(this.traceLog, logRecord, id, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void entry(TraceComponent tc, String methodName, Object ... o) {
        if (tc.isEntryEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINER, "Entry ", o);
            logRecord.setSourceMethodName(methodName);
            this.publishTraceLogRecord(this.traceLog, logRecord, null, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void entry(TraceComponent tc, Object id, String methodName, Object ... o) {
        if (tc.isEntryEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINER, "Entry ", o);
            logRecord.setSourceMethodName(methodName);
            this.publishTraceLogRecord(this.traceLog, logRecord, id, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void event(TraceComponent tc, String txt, Object ... o) {
        if (tc.isEventEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, WsLevel.EVENT, txt, o);
            this.publishTraceLogRecord(this.traceLog, logRecord, NULL_ID, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void event(TraceComponent tc, Object id, String txt, Object ... o) {
        if (tc.isEventEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, WsLevel.EVENT, txt, o);
            this.publishTraceLogRecord(this.traceLog, logRecord, id, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void exit(TraceComponent tc, String methodName) {
        if (tc.isEntryEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINER, "Exit ", null);
            logRecord.setSourceMethodName(methodName);
            this.publishTraceLogRecord(this.traceLog, logRecord, NULL_ID, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void exit(TraceComponent tc, Object id, String methodName) {
        if (tc.isEntryEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINER, "Exit ", null);
            logRecord.setSourceMethodName(methodName);
            this.publishTraceLogRecord(this.traceLog, logRecord, id, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void exit(TraceComponent tc, String methodName, Object o) {
        if (tc.isEntryEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINER, "Exit ", new Object[]{o});
            logRecord.setSourceMethodName(methodName);
            this.publishTraceLogRecord(this.traceLog, logRecord, NULL_ID, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void exit(TraceComponent tc, Object id, String methodName, Object o) {
        if (tc.isEntryEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINER, "Exit ", new Object[]{o});
            logRecord.setSourceMethodName(methodName);
            this.publishTraceLogRecord(this.traceLog, logRecord, id, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void dump(TraceComponent tc, String txt, Object ... o) {
        if (tc.isDumpEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINEST, "Dump: " + txt, o);
            this.publishTraceLogRecord(this.traceLog, logRecord, NULL_ID, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    public void echo(SystemLogHolder holder, LogRecord logRecord) {
        TraceWriter detailLog = this.traceLog;
        RoutedMessageImpl routedMessage = null;
        if (this.externalMessageRouter.get() != null) {
            String message = this.formatter.messageLogFormat(logRecord, logRecord.getMessage());
            routedMessage = new RoutedMessageImpl(logRecord.getMessage(), logRecord.getMessage(), message, logRecord);
        } else {
            routedMessage = new RoutedMessageImpl(logRecord.getMessage(), logRecord.getMessage(), null, logRecord);
        }
        this.invokeMessageRouters(routedMessage);
        if (this.logSource != null) {
            this.publishToLogSource(routedMessage);
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            this.publishTraceLogRecord(detailLog, logRecord, NULL_ID, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    protected void writeFilteredStreamOutput(SystemLogHolder holder, LogRecord logRecord) {
        String txt = BaseTraceService.filterStackTraces(logRecord.getMessage());
        if (txt != null) {
            this.writeStreamOutput(holder, txt, true);
        }
    }

    protected boolean isMessageHidden(String formattedMsg) {
        for (String messageId : this.hideMessageids) {
            if (!formattedMsg.startsWith(messageId)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeMessageRouters(RoutedMessage routedMessage) {
        boolean retMe;
        block9: {
            MessageRouter externalMsgRouter = this.externalMessageRouter.get();
            WsMessageRouter internalMsgRouter = this.internalMessageRouter.get();
            retMe = true;
            try {
                if (counterForMessageRouter.incrementCount() > 2) break block9;
                if (externalMsgRouter != null) {
                    retMe &= externalMsgRouter.route(routedMessage.getFormattedMsg(), routedMessage.getLogRecord());
                }
                if (internalMsgRouter != null) {
                    retMe &= internalMsgRouter.route(routedMessage);
                    break block9;
                }
                String message = this.formatter.messageLogFormat(routedMessage.getLogRecord(), routedMessage.getFormattedVerboseMsg());
                RoutedMessageImpl specialRoutedMessage = new RoutedMessageImpl(routedMessage.getFormattedMsg(), routedMessage.getFormattedVerboseMsg(), message, routedMessage.getLogRecord());
                BaseTraceService baseTraceService = this;
                synchronized (baseTraceService) {
                    if (this.earlierMessages != null) {
                        this.earlierMessages.add(specialRoutedMessage);
                    }
                }
            }
            finally {
                counterForMessageRouter.decrementCount();
            }
        }
        return retMe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeTraceRouters(RoutedMessage routedTrace) {
        boolean retMe;
        block8: {
            retMe = true;
            LogRecord logRecord = routedTrace.getLogRecord();
            try {
                String levelName;
                Level level;
                int levelValue;
                if (counterForTraceRouter.incrementCount() > 2 || logRecord == null || (levelValue = (level = logRecord.getLevel()).intValue()) >= Level.INFO.intValue() || (levelName = level.getName()).equals("SystemOut") || levelName.equals("SystemErr")) break block8;
                WsTraceRouter internalTrRouter = this.internalTraceRouter.get();
                if (internalTrRouter != null) {
                    retMe &= internalTrRouter.route(routedTrace);
                    break block8;
                }
                if (this.earlierTraces == null) break block8;
                BaseTraceService baseTraceService = this;
                synchronized (baseTraceService) {
                    if (this.earlierTraces != null) {
                        this.earlierTraces.add(routedTrace);
                    }
                }
            }
            finally {
                counterForTraceRouter.decrementCount();
            }
        }
        return retMe;
    }

    @Override
    public void publishLogRecord(LogRecord logRecord) {
        String formattedMsg = null;
        String formattedVerboseMsg = null;
        Level level = logRecord.getLevel();
        int levelValue = level.intValue();
        TraceWriter detailLog = this.traceLog;
        if (levelValue >= Level.INFO.intValue()) {
            formattedMsg = this.formatter.formatMessage(logRecord);
            formattedVerboseMsg = this.formatter.formatVerboseMessage(logRecord, formattedMsg);
            RoutedMessageImpl routedMessage = null;
            if (this.externalMessageRouter.get() != null) {
                String message = this.formatter.messageLogFormat(logRecord, formattedVerboseMsg);
                routedMessage = new RoutedMessageImpl(formattedMsg, formattedVerboseMsg, message, logRecord);
            } else {
                routedMessage = new RoutedMessageImpl(formattedMsg, formattedVerboseMsg, null, logRecord);
            }
            boolean logNormally = this.invokeMessageRouters(routedMessage);
            if (!logNormally) {
                return;
            }
            if (this.isMessageHidden(formattedMsg)) {
                this.publishTraceLogRecord(detailLog, logRecord, NULL_ID, formattedMsg, formattedVerboseMsg);
                return;
            }
            if (this.logSource != null) {
                this.publishToLogSource(routedMessage);
            }
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            this.publishTraceLogRecord(detailLog, logRecord, NULL_ID, formattedMsg, formattedVerboseMsg);
        }
    }

    protected void publishToLogSource(RoutedMessage routedMessage) {
        try {
            if (counterForLogSource.incrementCount() <= 2) {
                this.logSource.publish(routedMessage);
            }
        }
        finally {
            counterForLogSource.decrementCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishTraceLogRecord(TraceWriter detailLog, LogRecord logRecord, Object id, String formattedMsg, String formattedVerboseMsg) {
        if (formattedVerboseMsg == null) {
            formattedVerboseMsg = this.formatter.formatVerboseMessage(logRecord, formattedMsg, false);
        }
        RoutedMessageImpl routedTrace = new RoutedMessageImpl(formattedMsg, formattedVerboseMsg, null, logRecord);
        this.invokeTraceRouters(routedTrace);
        try {
            String levelName;
            Level level;
            int levelValue;
            if (counterForTraceSource.incrementCount() <= 2 && logRecord != null && (levelValue = (level = logRecord.getLevel()).intValue()) < Level.INFO.intValue() && !(levelName = level.getName()).equals("SystemOut") && !levelName.equals("SystemErr") && this.traceSource != null) {
                this.traceSource.publish(routedTrace, id);
            }
        }
        finally {
            counterForTraceSource.decrementCount();
        }
        try {
            if (counterForTraceWriter.incrementCount() <= 1 && detailLog != this.systemOut) {
                String traceDetail = this.formatter.traceLogFormat(logRecord, id, formattedMsg, formattedVerboseMsg);
                detailLog.writeRecord(traceDetail);
            }
        }
        finally {
            counterForTraceWriter.decrementCount();
        }
    }

    @Override
    public void setMessageRouter(MessageRouter msgRouter) {
        this.externalMessageRouter.set(msgRouter);
        if (msgRouter instanceof WsMessageRouter) {
            this.setWsMessageRouter((WsMessageRouter)msgRouter);
        }
    }

    @Override
    public void unsetMessageRouter(MessageRouter msgRouter) {
        this.externalMessageRouter.compareAndSet(msgRouter, null);
        if (msgRouter instanceof WsMessageRouter) {
            this.unsetWsMessageRouter((WsMessageRouter)msgRouter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setWsMessageRouter(WsMessageRouter msgRouter) {
        this.internalMessageRouter.set(msgRouter);
        if (this.earlierMessages != null) {
            BaseTraceService baseTraceService = this;
            synchronized (baseTraceService) {
                if (this.earlierMessages != null) {
                    msgRouter.setEarlierMessages(this.earlierMessages);
                }
            }
        } else {
            msgRouter.setEarlierMessages(null);
        }
    }

    public void unsetWsMessageRouter(WsMessageRouter msgRouter) {
        this.internalMessageRouter.compareAndSet(msgRouter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTraceRouter(WsTraceRouter traceRouter) {
        this.internalTraceRouter.set(traceRouter);
        if (this.earlierTraces != null) {
            BaseTraceService baseTraceService = this;
            synchronized (baseTraceService) {
                if (this.earlierTraces != null) {
                    traceRouter.setEarlierTraces(this.earlierTraces);
                }
            }
        } else {
            traceRouter.setEarlierTraces(null);
        }
    }

    @Override
    public void unsetTraceRouter(WsTraceRouter traceRouter) {
        this.internalTraceRouter.compareAndSet(traceRouter, null);
    }

    protected void initializeWriters(LogProviderConfigImpl config) {
        this.messagesLog = FileLogHolder.createFileLogHolder(this.messagesLog, this.newFileLogHeader(false, config), config.getLogDirectory(), config.getMessageFileName(), config.getMaxFiles(), config.getMaxFileBytes(), config.getNewLogsOnStart());
        TraceWriter oldWriter = this.traceLog;
        String fileName = config.getTraceFileName();
        if (fileName.equals("stdout")) {
            this.traceLog = this.systemOut;
            LoggingFileUtils.tryToClose(oldWriter);
        } else {
            this.traceLog = FileLogHolder.createFileLogHolder(oldWriter == this.systemOut ? null : oldWriter, this.newFileLogHeader(true, config), config.getLogDirectory(), config.getTraceFileName(), config.getMaxFiles(), config.getMaxFileBytes(), config.getNewLogsOnStart());
            if (!TraceComponent.isAnyTracingEnabled()) {
                ((FileLogHolder)this.traceLog).releaseFile();
            }
        }
    }

    private FileLogHeader newFileLogHeader(boolean trace, LogProviderConfigImpl config) {
        boolean isJSON = false;
        String messageFormat = config.getMessageFormat();
        if ("json".equals(messageFormat)) {
            isJSON = true;
            String jsonHeader = this.constructJSONHeader(messageFormat, config);
            return new FileLogHeader(jsonHeader, trace, this.javaLangInstrument, isJSON);
        }
        return new FileLogHeader(this.logHeader, trace, this.javaLangInstrument, isJSON);
    }

    private String constructJSONHeader(String messageFormat, LogProviderConfigImpl config) {
        String serverHostName = this.getServerHostName();
        String wlpUserDir = config.getWlpUsrDir();
        String serverName = this.getServerName(config);
        String datetime = this.getDatetime();
        String sequenceNumber = this.getSequenceNumber();
        JSONObject.JSONObjectBuilder jsonBuilder = new JSONObject.JSONObjectBuilder();
        jsonBuilder.addField(LogTraceData.getTypeKeyJSON(true), "liberty_message", false, false).addField(LogTraceData.getHostKeyJSON(true), serverHostName, false, true).addField(LogTraceData.getUserDirKeyJSON(true), wlpUserDir, false, true).addField(LogTraceData.getServerNameKeyJSON(true), serverName, false, true).addField(LogTraceData.getMessageKeyJSON(true), this.logHeader, false, true).addField(LogTraceData.getDatetimeKeyJSON(true), datetime, false, true).addField(LogTraceData.getSequenceKeyJSON(true), sequenceNumber, false, true);
        return jsonBuilder.build().toString().concat("\n");
    }

    private String getSequenceNumber() {
        SequenceNumber sequenceNumber = new SequenceNumber();
        long rawSequenceNumber = sequenceNumber.getRawSequenceNumber();
        String sequenceId = null;
        if (sequenceId == null || sequenceId.isEmpty()) {
            sequenceId = SequenceNumber.formatSequenceNumber(System.currentTimeMillis(), rawSequenceNumber);
        }
        return sequenceId;
    }

    private String getDatetime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        String datetime = dateFormat.format(System.currentTimeMillis());
        return datetime;
    }

    private String getServerName(LogProviderConfigImpl config) {
        String containerName = System.getenv("CONTAINER_NAME");
        this.serverName = containerName == null || containerName.equals("") || containerName.length() == 0 ? config.getServerName() : containerName;
        return this.serverName;
    }

    private String getServerHostName() {
        String serverHostName = null;
        String containerHost = System.getenv("CONTAINER_HOST");
        if (containerHost == null || containerHost.equals("") || containerHost.length() == 0) {
            try {
                serverHostName = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws UnknownHostException {
                        return InetAddress.getLocalHost().getCanonicalHostName();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                serverHostName = "";
            }
        } else {
            serverHostName = containerHost;
        }
        return serverHostName;
    }

    protected void captureSystemStreams() {
        this.teeOut = new TeePrintStream(new TrOutputStream(this.systemOut, this), true);
        System.setOut(this.teeOut);
        this.teeErr = new TeePrintStream(new TrOutputStream(this.systemErr, this), true);
        System.setErr(this.teeErr);
    }

    protected void restoreSystemStreams() {
        if (System.out == this.teeOut) {
            System.setOut(this.systemOut.getOriginalStream());
        }
        if (System.err == this.teeErr) {
            System.setErr(this.systemErr.getOriginalStream());
        }
    }

    protected synchronized void writeStreamOutput(SystemLogHolder holder, String txt, boolean rawStream) {
        if (holder == this.systemErr && rawStream) {
            txt = "[err] " + txt;
        }
        holder.originalStream.println(txt);
    }

    public static String filterStackTraces(String txt) {
        StackTraceFlags stackTraceFlags = traceFlags.get();
        if (txt.startsWith("\tat ")) {
            PackageProcessor packageProcessor = PackageProcessor.getPackageProcessor();
            String packageName = PackageProcessor.extractPackageFromStackTraceLine(txt);
            if (packageProcessor != null && packageProcessor.isIBMPackage(packageName)) {
                if (stackTraceFlags.isSuppressingTraces) {
                    txt = null;
                } else if (stackTraceFlags.needsToOutputInternalPackageMarker) {
                    txt = "\tat [internal classes]";
                    stackTraceFlags.needsToOutputInternalPackageMarker = false;
                    stackTraceFlags.isSuppressingTraces = true;
                } else {
                    stackTraceFlags.needsToOutputInternalPackageMarker = true;
                }
            } else {
                stackTraceFlags.isSuppressingTraces = false;
                stackTraceFlags.needsToOutputInternalPackageMarker = false;
            }
        } else {
            stackTraceFlags.isSuppressingTraces = false;
            stackTraceFlags.needsToOutputInternalPackageMarker = false;
        }
        return txt;
    }

    private List<String> filterSourcelist(List<String> sourceList) {
        ArrayList<String> filteredList = new ArrayList<String>(sourceList);
        filteredList.remove("trace");
        filteredList.remove("message");
        return filteredList;
    }

    private void updateConduitSyncHandlerConnection(List<String> sourceList, SynchronousHandler handler) {
        if (sourceList.contains("message")) {
            this.logConduit.addSyncHandler(handler);
        } else {
            this.logConduit.removeSyncHandler(handler);
        }
        if (sourceList.contains("trace")) {
            this.traceConduit.addSyncHandler(handler);
        } else {
            this.traceConduit.removeSyncHandler(handler);
        }
    }

    private class EarlyMessageTraceCleaner
    extends TimerTask {
        private EarlyMessageTraceCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BaseTraceService baseTraceService = BaseTraceService.this;
            synchronized (baseTraceService) {
                BaseTraceService.this.earlierMessages = null;
                BaseTraceService.this.earlierTraces = null;
                if (BaseTraceService.this.internalMessageRouter.get() != null) {
                    BaseTraceService.this.setWsMessageRouter(BaseTraceService.this.internalMessageRouter.get());
                }
                if (BaseTraceService.this.internalTraceRouter.get() != null) {
                    BaseTraceService.this.setTraceRouter(BaseTraceService.this.internalTraceRouter.get());
                }
            }
        }
    }

    public static class TrOutputStream
    extends ByteArrayOutputStream {
        final SystemLogHolder holder;
        final BaseTraceService service;
        public static ThreadLocal<Boolean> isPrinting = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };

        public TrOutputStream(SystemLogHolder slh, BaseTraceService service) {
            this.holder = slh;
            this.service = service;
        }

        @Override
        public synchronized void flush() throws IOException {
            if (isPrinting.get().booleanValue()) {
                return;
            }
            super.flush();
            if (!this.holder.isEnabled()) {
                super.reset();
                return;
            }
            String entry = this.toString();
            super.reset();
            if (entry.isEmpty() || LoggingConstants.nl.equals(entry)) {
                return;
            }
            if (entry.endsWith(LoggingConstants.nl)) {
                entry = entry.substring(0, entry.length() - LoggingConstants.nlen);
            }
            LogRecord logRecord = new LogRecord(this.holder, entry);
            logRecord.setLoggerName(this.holder.getName());
            this.service.echo(this.holder, logRecord);
        }
    }

    public static final class TeePrintStream
    extends PrintStream {
        protected final TrOutputStream trStream;

        public TeePrintStream(TrOutputStream trStream, boolean autoFlush) {
            super(trStream, autoFlush);
            this.trStream = trStream;
        }

        @Override
        public synchronized void print(boolean b) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(b);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void print(char c) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(c);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void print(int i) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(i);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void print(long l) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(l);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void print(float f) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(f);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void print(double d) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(d);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void print(char[] c) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(c);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void print(String s) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(s);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void print(Object obj) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(obj);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void println() {
            TrOutputStream.isPrinting.set(true);
            try {
                super.println();
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void println(boolean b) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(b);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void println(char c) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(c);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void println(int i) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(i);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void println(long l) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(l);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void println(float f) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(f);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void println(double d) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(d);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void println(char[] c) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(c);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void println(String s) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(s);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }

        @Override
        public synchronized void println(Object obj) {
            TrOutputStream.isPrinting.set(true);
            try {
                super.print(obj);
            }
            finally {
                TrOutputStream.isPrinting.set(false);
                super.flush();
            }
        }
    }

    public static final class SystemLogHolder
    extends Level
    implements TraceWriter {
        private static final long serialVersionUID = 1L;
        final transient PrintStream originalStream;
        final transient TraceComponent tc;

        protected SystemLogHolder(String name, PrintStream origin) {
            super(name, WsLevel.CONFIG.intValue());
            this.originalStream = origin;
            this.tc = Tr.register(name, SystemLogHolder.class, (String)null);
        }

        public PrintStream getOriginalStream() {
            return this.originalStream;
        }

        @Override
        public void writeRecord(String record) {
            this.originalStream.println(record);
        }

        @Override
        public void close() throws IOException {
        }

        public boolean isEnabled() {
            return this.tc.getLoggerLevel() != Level.OFF;
        }
    }

    private static class StackTraceFlags {
        boolean needsToOutputInternalPackageMarker = false;
        boolean isSuppressingTraces = false;

        private StackTraceFlags() {
        }
    }

    public static interface TraceWriter
    extends Closeable {
        public void writeRecord(String var1);
    }
}

