/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.MessageTrustDecider;
import org.apache.cxf.transport.http.UntrustedURLConnectionIOException;
import org.apache.cxf.transport.https.HttpsURLConnectionInfo;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
final class TrustDecisionUtil {
    private static final Logger LOG = LogUtils.getL7dLogger(TrustDecisionUtil.class);
    static final long serialVersionUID = -4765944961397769551L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private TrustDecisionUtil() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.TrustDecisionUtil", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.TrustDecisionUtil", "<init>", this);
        }
    }

    /*
     * Unable to fully structure code
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static void makeTrustDecision(MessageTrustDecider trustDecider, Message message, HttpURLConnection connection, String conduitName) throws IOException {
        if (TrustDecisionUtil.LOG != null && TrustDecisionUtil.LOG.isLoggable(Level.FINER)) {
            TrustDecisionUtil.LOG.entering("org.apache.cxf.transport.http.TrustDecisionUtil", "makeTrustDecision", new Object[]{trustDecider, message, connection, conduitName});
        }
        decider2 = (MessageTrustDecider)message.get(MessageTrustDecider.class);
        if (trustDecider != null || decider2 != null) {
            try {
                connection.connect();
                info = new HttpsURLConnectionInfo(connection);
                if (trustDecider != null) {
                    trustDecider.establishTrust(conduitName, info, message);
                    if (TrustDecisionUtil.LOG.isLoggable(Level.FINE)) {
                        TrustDecisionUtil.LOG.log(Level.FINE, "Trust Decider " + trustDecider.getLogicalName() + " considers Conduit " + conduitName + " trusted.");
                    }
                }
                if (decider2 == null) ** GOTO lbl25
                decider2.establishTrust(conduitName, info, message);
                if (!TrustDecisionUtil.LOG.isLoggable(Level.FINE)) ** GOTO lbl25
                TrustDecisionUtil.LOG.log(Level.FINE, "Trust Decider " + decider2.getLogicalName() + " considers Conduit " + conduitName + " trusted.");
            }
            catch (UntrustedURLConnectionIOException untrustedEx) {
                connection.disconnect();
                if (TrustDecisionUtil.LOG.isLoggable(Level.FINE)) {
                    TrustDecisionUtil.LOG.log(Level.FINE, "Trust Decider " + (trustDecider != null ? trustDecider.getLogicalName() : decider2.getLogicalName()) + " considers Conduit " + conduitName + " untrusted.", untrustedEx);
                }
                throw untrustedEx;
            }
        } else if (TrustDecisionUtil.LOG.isLoggable(Level.FINE)) {
            TrustDecisionUtil.LOG.log(Level.FINE, "No Trust Decider for Conduit '" + conduitName + "'. An afirmative Trust Decision is assumed.");
        }
lbl25:
        // 6 sources

        if (TrustDecisionUtil.LOG != null && TrustDecisionUtil.LOG.isLoggable(Level.FINER)) {
            TrustDecisionUtil.LOG.exiting("org.apache.cxf.transport.http.TrustDecisionUtil", "makeTrustDecision");
        }
    }
}

