/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet.servicelist;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.commons_text.StringEscapeUtils;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.apache.cxf.transport.servlet.servicelist.ServiceListWriter;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class UnformattedServiceListWriter
implements ServiceListWriter {
    boolean renderWsdlList;
    static final long serialVersionUID = -7889892918142524440L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public UnformattedServiceListWriter(boolean renderWsdlList) {
        this.renderWsdlList = renderWsdlList;
    }

    @Override
    public String getContentType() {
        return "text/html; charset=UTF-8";
    }

    @Override
    public void writeServiceList(PrintWriter writer, String baseAddress, AbstractDestination[] soapDestinations, AbstractDestination[] restDestinations) throws IOException {
        if (soapDestinations.length > 0 || restDestinations.length > 0) {
            this.writeUnformattedSOAPEndpoints(writer, baseAddress, soapDestinations);
            this.writeUnformattedRESTfulEndpoints(writer, baseAddress, restDestinations);
        } else {
            writer.write("No services have been found.");
        }
    }

    private void writeUnformattedSOAPEndpoints(PrintWriter writer, String baseAddress, AbstractDestination[] destinations) throws IOException {
        for (AbstractDestination sd : destinations) {
            String address = this.getAbsoluteAddress(baseAddress, sd);
            address = StringEscapeUtils.escapeHtml4(address);
            writer.write(address);
            if (this.renderWsdlList) {
                writer.write("?wsdl");
            }
            writer.write(10);
        }
        writer.write(10);
    }

    private void writeUnformattedRESTfulEndpoints(PrintWriter writer, String baseAddress, AbstractDestination[] destinations) throws IOException {
        for (AbstractDestination sd : destinations) {
            String address = this.getAbsoluteAddress(baseAddress, sd);
            address = StringEscapeUtils.escapeHtml4(address);
            writer.write(address + "?_wadl\n");
        }
    }

    private String getAbsoluteAddress(String basePath, AbstractDestination d) {
        String endpointAddress = (String)d.getEndpointInfo().getProperty("publishedEndpointUrl");
        if (endpointAddress != null) {
            return endpointAddress;
        }
        endpointAddress = d.getEndpointInfo().getAddress();
        if (d instanceof ServletDestination && (endpointAddress.startsWith("http://") || endpointAddress.startsWith("https://"))) {
            String path = ((ServletDestination)d).getPath();
            return basePath + path;
        }
        if (basePath == null || endpointAddress.startsWith(basePath)) {
            return endpointAddress;
        }
        return basePath + endpointAddress;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.servlet.servicelist.UnformattedServiceListWriter", UnformattedServiceListWriter.class, null, null);
    }
}

