/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.strategies.writeable;

import com.ibm.ws.repository.common.enums.State;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryBadDataException;
import com.ibm.ws.repository.exceptions.RepositoryResourceNoConnectionException;
import com.ibm.ws.repository.exceptions.RepositoryResourceValidationException;
import com.ibm.ws.repository.resources.internal.RepositoryResourceImpl;
import com.ibm.ws.repository.strategies.writeable.UploadStrategy;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseStrategy
implements UploadStrategy {
    private static List<String> _vanityUrlLocks = new ArrayList<String>();
    protected State _desiredStateIfMatchingFound;
    protected State _desiredStateIfNoMatchingFound;

    protected static synchronized String getVanityUrlLock(String vanityUrl) {
        int index = _vanityUrlLocks.indexOf(vanityUrl);
        if (index == -1) {
            _vanityUrlLocks.add(vanityUrl);
            return vanityUrl;
        }
        return _vanityUrlLocks.get(index);
    }

    protected BaseStrategy() {
        this._desiredStateIfMatchingFound = null;
        this._desiredStateIfNoMatchingFound = State.DRAFT;
    }

    protected BaseStrategy(State desiredStateIfMatchingFound, State desiredStateIfNoMatchingFound) {
        this._desiredStateIfMatchingFound = desiredStateIfMatchingFound;
        this._desiredStateIfNoMatchingFound = desiredStateIfNoMatchingFound;
    }

    protected State calculateTargetState(RepositoryResourceImpl matchingResource) {
        State targetState = this._desiredStateIfNoMatchingFound;
        if (matchingResource != null) {
            targetState = this._desiredStateIfMatchingFound == null ? matchingResource.getState() : this._desiredStateIfMatchingFound;
        }
        return targetState;
    }

    @Override
    public List<RepositoryResourceImpl> findMatchingResources(RepositoryResourceImpl resource) throws RepositoryResourceValidationException, RepositoryBackendException, RepositoryBadDataException, RepositoryResourceNoConnectionException {
        return resource.findMatchingResource();
    }

    @Override
    public boolean performEditionChecking() {
        return true;
    }
}

