/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.utils.SocialUtil;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OAuthClientHttpUtil {
    private static final TraceComponent tc = Tr.register(OAuthClientHttpUtil.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    static OAuthClientHttpUtil instance = null;
    static final long serialVersionUID = -6905112042812687003L;

    OAuthClientHttpUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    public String extractTokensFromResponse(Map<String, Object> postResponseMap) throws SocialLoginException {
        if (postResponseMap == null) {
            return null;
        }
        HttpResponse response = (HttpResponse)postResponseMap.get("RESPONSEMAP_CODE");
        if (response == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"An HttpResponse object was not found in the map", (Object[])new Object[0]);
            }
            return null;
        }
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        try {
            return EntityUtils.toString((HttpEntity)entity);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.internal.utils.OAuthClientHttpUtil", (String)"77", (Object)this, (Object[])new Object[]{postResponseMap});
            throw new SocialLoginException("ERROR_PARSING_RESPONSE_ENTITY", (Exception)e, new Object[]{e.getLocalizedMessage()});
        }
    }

    HttpPost createPostMethod(String url, List<NameValuePair> commonHeaders) throws SocialLoginException {
        SocialUtil.validateEndpointWithQuery(url);
        HttpPost postMethod = new HttpPost(url);
        if (commonHeaders != null) {
            for (NameValuePair nvp : commonHeaders) {
                postMethod.addHeader(nvp.getName(), nvp.getValue());
            }
        }
        return postMethod;
    }

    HttpGet createHttpGetMethod(String url, List<NameValuePair> commonHeaders) throws SocialLoginException {
        SocialUtil.validateEndpointWithQuery(url);
        HttpGet getMethod = new HttpGet(url);
        if (commonHeaders != null) {
            for (NameValuePair nvp : commonHeaders) {
                getMethod.addHeader(nvp.getName(), nvp.getValue());
            }
        }
        return getMethod;
    }

    /*
     * WARNING - void declaration
     */
    HttpResponse executeRequest(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, HttpUriRequest httpUriRequest, boolean useJvmProps) throws SocialLoginException {
        HttpClient httpClient = this.createHTTPClient(sslSocketFactory, url, isHostnameVerification, useJvmProps);
        HttpResponse response = null;
        try {
            response = httpClient.execute(httpUriRequest);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.internal.utils.OAuthClientHttpUtil", (String)"115", (Object)this, (Object[])new Object[]{sslSocketFactory, url, isHostnameVerification, httpUriRequest, useJvmProps});
            throw new SocialLoginException("ERROR_EXECUTING_REQUEST", (Exception)e, new Object[]{url, e.getLocalizedMessage()});
        }
        return response;
    }

    /*
     * WARNING - void declaration
     */
    void verifyResponse(String url, HttpResponse response) throws SocialLoginException {
        String errorMsg;
        String statusInsert;
        block5: {
            if (response == null) {
                return;
            }
            StatusLine status = response.getStatusLine();
            if (status != null && status.getStatusCode() == 200) {
                return;
            }
            statusInsert = status == null ? null : status.getStatusCode() + " " + status.getReasonPhrase();
            errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"RESPONSE_STATUS_MISSING_OR_ERROR", (Object[])new Object[]{statusInsert});
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try {
                    errorMsg = EntityUtils.toString((HttpEntity)entity).trim();
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.internal.utils.OAuthClientHttpUtil", (String)"135", (Object)this, (Object[])new Object[]{url, response});
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)("Caught error parsing HttpEntity: " + e), (Object[])new Object[0]);
                }
            }
        }
        throw new SocialLoginException("RESPONSE_STATUS_UNSUCCESSFUL", null, new Object[]{url, statusInsert, errorMsg});
    }

    public Map<String, Object> postToEndpoint(String url, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, String accessToken, SSLSocketFactory sslSocketFactory, List<NameValuePair> commonHeaders, boolean isHostnameVerification, String authMethod, boolean useJvmProps) throws SocialLoginException {
        SocialUtil.validateEndpointWithQuery(url);
        this.debugPostToEndPoint(url, params, baUsername, baPassword, accessToken, commonHeaders);
        HttpPost postMethod = this.createPostMethod(url, commonHeaders);
        postMethod = this.setPostParameters(postMethod, params);
        return this.commonEndpointInvocation((HttpUriRequest)postMethod, url, baUsername, baPassword, accessToken, sslSocketFactory, isHostnameVerification, authMethod, useJvmProps);
    }

    public Map<String, Object> getToEndpoint(String url, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, String accessToken, SSLSocketFactory sslSocketFactory, List<NameValuePair> commonHeaders, boolean isHostnameVerification, String authMethod, boolean useJvmProps) throws SocialLoginException {
        SocialUtil.validateEndpointWithQuery(url);
        this.debugPostToEndPoint(url, params, baUsername, baPassword, accessToken, commonHeaders);
        HttpGet getMethod = this.createHttpGetMethod(url, commonHeaders);
        if (params != null) {
            for (NameValuePair nvp : params) {
                getMethod.addHeader(nvp.getName(), nvp.getValue());
            }
        }
        return this.commonEndpointInvocation((HttpUriRequest)getMethod, url, baUsername, baPassword, accessToken, sslSocketFactory, isHostnameVerification, authMethod, useJvmProps);
    }

    Map<String, Object> postToIntrospectEndpoint(String url, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, String accessToken, SSLSocketFactory sslSocketFactory, List<NameValuePair> commonHeaders, boolean isHostnameVerification, String authMethod, boolean useJvmProps) throws SocialLoginException {
        SocialUtil.validateEndpointWithQuery(url);
        this.debugPostToEndPoint(url, params, baUsername, baPassword, accessToken, commonHeaders);
        HttpPost postMethod = this.createPostMethod(url, commonHeaders);
        postMethod = this.setPostParameters(postMethod, params);
        return this.commonEndpointInvocation((HttpUriRequest)postMethod, url, baUsername, baPassword, accessToken, sslSocketFactory, isHostnameVerification, authMethod, useJvmProps);
    }

    HttpPost setPostParameters(HttpPost postMethod, @Sensitive List<NameValuePair> params) {
        block3: {
            try {
                if (params != null) {
                    postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Object[] objectArray = new Object[2];
                objectArray[0] = postMethod;
                objectArray[1] = "<sensitive java.util.List>";
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.social.internal.utils.OAuthClientHttpUtil", (String)"215", (Object)this, (Object[])objectArray);
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"The default encoding is not supported; parameters might not be present in the request", (Object[])new Object[0]);
            }
        }
        return postMethod;
    }

    Map<String, Object> commonEndpointInvocation(HttpUriRequest httpUriRequest, String url, String baUsername, @Sensitive String baPassword, String accessToken, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, String authMethod, boolean useJvmProps) throws SocialLoginException {
        this.setAuthorizationHeader(baUsername, baPassword, accessToken, httpUriRequest, authMethod);
        HttpResponse response = this.executeRequest(sslSocketFactory, url, isHostnameVerification, httpUriRequest, useJvmProps);
        this.verifyResponse(url, response);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("RESPONSEMAP_CODE", response);
        result.put("RESPONSEMAP_METHOD", httpUriRequest);
        return result;
    }

    void setAuthorizationHeader(String baUsername, @Sensitive String baPassword, String accessToken, HttpUriRequest httpUriRequest, String authMethod) {
        if (accessToken != null) {
            httpUriRequest.addHeader("Authorization", "bearer " + accessToken);
            return;
        }
        if (authMethod != null && authMethod.equals("client_secret_basic")) {
            String userpass = baUsername + ":" + baPassword;
            String basicAuth = "Basic " + Base64Coder.base64Encode((String)userpass);
            httpUriRequest.addHeader("Authorization", basicAuth);
        }
    }

    void debugPostToEndPoint(String url, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, String accessToken, List<NameValuePair> commonHeaders) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        Tr.debug((TraceComponent)tc, (String)("postToEndpoint: url: " + url + " headers: " + commonHeaders + " params: ***** baUsername: " + baUsername + " baPassword: " + (baPassword != null ? "****" : null) + " accessToken: " + accessToken), (Object[])new Object[0]);
        StringBuffer sb = new StringBuffer();
        sb.append("curl -k -v");
        if (commonHeaders != null) {
            for (NameValuePair nvp : commonHeaders) {
                sb.append(" -H \"");
                sb.append(nvp.getName());
                sb.append(": ");
                sb.append(nvp.getValue());
                sb.append("\"");
            }
        }
        if (params != null && params.size() > 0) {
            sb.append(" -d \"");
            Iterator<NameValuePair> i = params.iterator();
            while (i.hasNext()) {
                NameValuePair nvp;
                nvp = i.next();
                String name = nvp.getName();
                sb.append(name);
                sb.append("=");
                if (name.equals("client_secret")) {
                    sb.append("*****");
                } else {
                    sb.append(nvp.getValue());
                }
                if (!i.hasNext()) continue;
                sb.append("&");
            }
            sb.append("\"");
        }
        if (baUsername != null && baPassword != null) {
            sb.append(" -u \"");
            sb.append(baUsername);
            sb.append(":");
            sb.append("****");
            sb.append("\"");
        }
        if (accessToken != null) {
            sb.append(" -H \"Authorization: bearer ");
            sb.append(accessToken);
            sb.append("\"");
        }
        sb.append(" ");
        sb.append(url);
        Tr.debug((TraceComponent)tc, (String)("CURL Command: " + sb.toString()), (Object[])new Object[0]);
    }

    public HttpClient createHTTPClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, boolean useJvmProps) {
        CloseableHttpClient client = null;
        if (url != null && url.startsWith("http:")) {
            client = this.getBuilder(useJvmProps).build();
        } else {
            SSLConnectionSocketFactory connectionFactory = null;
            connectionFactory = !isHostnameVerification ? new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new AllowAllHostnameVerifier()) : new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new StrictHostnameVerifier());
            client = this.getBuilder(useJvmProps).setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).build();
        }
        return client;
    }

    public HttpClient createHTTPClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, String baUser, @Sensitive String baPassword, boolean useJvmProps) {
        CloseableHttpClient client = null;
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(baUser, baPassword));
        if (url != null && url.startsWith("http:")) {
            client = this.getBuilder(useJvmProps).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        } else {
            SSLConnectionSocketFactory connectionFactory = null;
            connectionFactory = !isHostnameVerification ? new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new AllowAllHostnameVerifier()) : new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new StrictHostnameVerifier());
            client = this.getBuilder(useJvmProps).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).build();
        }
        return client;
    }

    private HttpClientBuilder getBuilder(boolean useJvmProps) {
        return useJvmProps ? HttpClientBuilder.create().disableCookieManagement().useSystemProperties() : HttpClientBuilder.create().disableCookieManagement();
    }

    public static OAuthClientHttpUtil getInstance() {
        if (instance == null) {
            instance = new OAuthClientHttpUtil();
        }
        return instance;
    }
}

