/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.messaging.mbean.MessagingEngineMBean;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.admin.JsMEConfig;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.LWMConfig;
import com.ibm.ws.sib.admin.internal.BaseMessagingEngineImpl;
import com.ibm.ws.sib.admin.internal.JsAdminFactory;
import com.ibm.ws.sib.admin.internal.JsBusImpl;
import com.ibm.ws.sib.admin.internal.JsMainAdminComponentImpl;
import com.ibm.ws.sib.admin.internal.JsMainImpl;
import com.ibm.ws.sib.admin.internal.JsObject;
import com.ibm.ws.sib.admin.internal.MessagingMBeanFactoryImpl;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.SeverePersistenceException;
import com.ibm.ws.sib.processor.SIMPAdmin;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Vector;

public class JsMessagingEngineImpl
extends BaseMessagingEngineImpl
implements JsMessagingEngine,
JsEngineComponent,
LWMConfig,
MessagingEngineMBean {
    private static final TraceComponent tc = SibTr.register(JsMessagingEngineImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.internal.JsMessagingEngineImpl";
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private final boolean _eventNotificationEnabled = false;
    JsObject object = new JsObject("WEMMessagingEngine", this._name);

    public JsMessagingEngineImpl(JsMainImpl mainImpl, JsBusImpl bus, JsMEConfig me) throws Exception {
        super(mainImpl, bus, me);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"JsMessagingEngineImpl().<init>", (Object)this);
        }
        this._mbeanFactory = new MessagingMBeanFactoryImpl(this, mainImpl.bContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"JsMessagingEngineImpl().<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(JsMessagingEngine engine) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialize", (Object)engine);
        }
        try {
            this.jsaf = JsAdminFactory.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object li = null;
        boolean initializationFailed = false;
        Object object = this.stateChangeLock;
        synchronized (object) {
            this.setState(1);
            for (int i = 0; i < 5; ++i) {
                this.stopSequence[i] = new Vector();
            }
            try {
                this._messageStore = (MessageStore)JsMainAdminComponentImpl.messageStoreRef.getService();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this._messageProcessor = this.loadClass("com.ibm.ws.sib.processor.impl.MessageProcessor", 1, true);
            initializationFailed = false;
        }
        try {
            this._messageStore.initialize((JsMessagingEngine)this);
            this._messageProcessor.initialize((JsMessagingEngine)this);
            this.setState(2);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.internal.JsMessagingEngineImpl.<init>", (String)"625", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"ME_CANNOT_BE_INITIALIZED_SIAS0033", (Object)new Object[]{this._name, "MessageProcessor.java", "initialize()"});
            SibTr.exception((TraceComponent)tc, (Exception)e);
            initializationFailed = true;
        }
        if (initializationFailed) {
            this.destroy();
            this.setState(0);
        } else {
            this.setState(2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int mode) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start, mode ", (Object)mode);
        }
        boolean startFailed = false;
        Object li = null;
        Object object = this.stateChangeLock;
        synchronized (object) {
            if (this._state == 10) {
                this.setState(6);
            }
        }
        try {
            this._messageStore.start();
            this._messageProcessor.start(0);
            this.setState(7);
        }
        catch (Exception e) {
            if (!(e.getCause() instanceof SeverePersistenceException)) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.internal.JsMessagingEngineImpl.start", (String)"626", (Object)this);
            }
            SibTr.error((TraceComponent)tc, (String)"ME_CANNOT_BE_STARTED_SIAS0034", (Object)new Object[]{this._name, "", "start()"});
            SibTr.exception((TraceComponent)tc, (Exception)e);
            startFailed = true;
        }
        if (startFailed) {
            SibTr.error((TraceComponent)tc, (String)"ME_RESTART_CHECK_SIAS0027", (Object)this.getName());
            this.stop(1);
            this.destroy();
            this.setState(10);
        } else {
            this._mpAdmin = ((SIMPAdmin)this.getMessageProcessor()).getAdministrator();
            this.setState(7);
        }
        if (!startFailed) {
            this.serverStarted();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Messaging Engine " + this._name + " with UUID " + this._uuid + " has been started."));
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Messaging engine failed");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    @Override
    public void stop(int mode) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop, mode ", (Object)mode);
        }
        this.setState(8);
        this._localizer.clearMPAdmin();
        this._mpAdmin = null;
        this._messageProcessor.stop(mode);
        this._messageStore.stop(mode);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Messaging Engine " + this._name + " finished stop phases"));
        }
        this.setState(10);
        SibTr.debug((TraceComponent)tc, (String)"Messaging Engine stopped");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Messaging Engine " + this._name + " has been stopped before dynamic config cycle completed."));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"stop");
        }
    }

    @Override
    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destroy", (Object)this);
        }
        this.setState(11);
        if (this._mbeanFactory != null) {
            ((MessagingMBeanFactoryImpl)this._mbeanFactory).deregisterAll();
        }
        this._messageProcessor.destroy();
        this._messageStore.destroy();
        this.setState(12);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public boolean isEventNotificationEnabled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeNewEngineComponent(JsEngineComponent engineComponent) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNewEngineComponent", (Object)engineComponent);
        }
        Object object = this.stateChangeLock;
        synchronized (object) {
            if (this._state != 0 && this._state != 12) {
                engineComponent.initialize((JsMessagingEngine)this);
                engineComponent.setConfig((LWMConfig)this);
            }
            if (this._state == 6 || this._state == 7) {
                int mode = 0;
                if (this._mainImpl.isServerInRecoveryMode()) {
                    mode += 2;
                }
                engineComponent.start(mode);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNewEngineComponent");
        }
    }

    protected void destroyOldEngineComponent(BaseMessagingEngineImpl.ComponentList component) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destroyOldEngineComponent", (Object)component);
        }
        boolean removed = this.jmeComponents.remove(component);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"destroyOldEngineComponent, component removed from jmeComponents?", (Object)removed);
        }
        JsEngineComponent engineComponent = component.getRef();
        if (this._state == 6 || this._state == 7 || this._state == 8 || this._state == 9 || this._state == 13) {
            engineComponent.stop(0);
        }
        if (this._state != 0 && this._state != 12) {
            engineComponent.destroy();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destroyOldEngineComponent");
        }
    }

    private void notifyMessagingEngineStarting(String meName, String meUuid, String startType) {
        if (this.isEventNotificationEnabled()) {
            String string = nls.getFormattedMessage("NOTIFY_MESSAGING_ENGINE_STARTING_SIAS0049", new Object[]{meName, meUuid}, null);
        }
    }

    private void notifyMessagingEngineStarted(String meName, String meUuid, String startType) {
        if (this.isEventNotificationEnabled()) {
            String string = "Messaging Engine " + this._name + " with UUID " + this._uuid + " has been started.";
        }
    }

    private void notifyMessagingEngineStopping(String meName, String meUuid, String stopReason) {
        if (this.isEventNotificationEnabled()) {
            String string = nls.getFormattedMessage("NOTIFY_MESSAGING_ENGINE_STOPPING_SIAS0050", new Object[]{this.getName(), this.getUuid().toString()}, null);
        }
    }

    private void notifyMessagingEngineStopped(String meName, String meUuid, String stopReason) {
        if (this.isEventNotificationEnabled()) {
            String string = nls.getFormattedMessage("NOTIFY_MESSAGING_ENGINE_STOP_SIAS0045", new Object[]{this.getName(), this.getUuid().toString()}, null);
        }
    }

    private void notifyMessagingEngineFailed(String meName, String meUuid, String failOperation, String failOperationType) {
        if (this.isEventNotificationEnabled()) {
            String string = nls.getFormattedMessage("NOTIFY_MESSAGING_ENGINE_STOP_FAILED_SIAS0052", new Object[]{this.getName(), this.getUuid().toString()}, null);
        }
    }

    public String getMBeanType() {
        return "WEMMessagingEngine";
    }
}

