/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.gd.AIStream;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.runtime.SIMPAttachedRemoteSubscriberControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteConsumerReceiverControllable;
import com.ibm.ws.sib.processor.runtime.SIMPTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.impl.AbstractRegisteredControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.RemoteTopicSpaceControl;
import com.ibm.ws.sib.processor.runtime.impl.Topicspace;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class AttachedRemoteSubscriberControl
extends AbstractRegisteredControlAdapter
implements SIMPAttachedRemoteSubscriberControllable {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(AttachedRemoteSubscriberControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final String HANDLER_NAME = "AttachedRemoteSubscriber";
    private String _remoteDurableName;
    private BaseDestinationHandler _destinationHandler;
    private MessageProcessor _messageProcessor;
    private AnycastInputHandler _anycastInputHandler;
    private Topicspace _topicspace;
    private RemoteTopicSpaceControl _remoteTopicSpaceControl;

    public AttachedRemoteSubscriberControl(String remoteDurableName, AnycastInputHandler anycastInputHandler, MessageProcessor messageProcessor, RemoteTopicSpaceControl remoteTopicSpace) {
        super(messageProcessor, ControllableType.REMOTE_SUBSCRIPTION_POINT);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AttachedRemoteSubscriberControl", (Object)new Object[]{remoteDurableName, anycastInputHandler, messageProcessor, remoteTopicSpace});
        }
        this._remoteDurableName = remoteDurableName;
        this._anycastInputHandler = anycastInputHandler;
        this._destinationHandler = anycastInputHandler.getBaseDestinationHandler();
        this._messageProcessor = messageProcessor;
        this._remoteTopicSpaceControl = remoteTopicSpace;
        this.registerControlAdapterAsMBean();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AttachedRemoteSubscriberControl", (Object)this);
        }
    }

    public SIMPTopicSpaceControllable getTopicSpace() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpace");
        }
        if (this._topicspace == null) {
            this._topicspace = new Topicspace(this._messageProcessor, this._destinationHandler);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpace", (Object)this._topicspace);
        }
        return this._topicspace;
    }

    public RemoteTopicSpaceControl getRemoteTopicSpaceControl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteTopicSpaceControl");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteTopicSpaceControl", (Object)this._remoteTopicSpaceControl);
        }
        return this._remoteTopicSpaceControl;
    }

    @Override
    public String getRemoteEngineUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
        }
        String engineUUID = this._anycastInputHandler.getLocalisationUuid().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)engineUUID);
        }
        return engineUUID;
    }

    public SIMPRemoteConsumerReceiverControllable getRemoteConsumerReceiver() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteConsumerReceiver");
        }
        AIStream aiStream = this._anycastInputHandler.getAIStream();
        SIMPRemoteConsumerReceiverControllable remoteConsumerReceiverControl = null;
        if (aiStream != null) {
            remoteConsumerReceiverControl = (SIMPRemoteConsumerReceiverControllable)aiStream.getControlAdapter();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteConsumerReceiver", (Object)remoteConsumerReceiverControl);
        }
        return remoteConsumerReceiverControl;
    }

    public SIMPIterator getConsumerIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerIterator");
        }
        InvalidOperationException finalE = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"AttachedRemoteSubscriberControl.getConsumerIterator", "1:188:1.32", this}, null));
        SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConsumerIterator");
        }
        throw finalE;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._destinationHandler == null || this._messageProcessor == null || this._anycastInputHandler == null || this._remoteTopicSpaceControl == null) {
            SIMPControllableNotFoundException e = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"AttachedRemoteSubscriberControl.assertValidControllable", "1:218:1.32"}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this._remoteDurableName = null;
        this._anycastInputHandler = null;
        this._destinationHandler = null;
        this._messageProcessor = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public synchronized void registerControlAdapterAsMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        if (!this.isRegistered()) {
            super.registerControlAdapterAsMBean();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    @Override
    public void deregisterControlAdapterMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
        super.deregisterControlAdapterMBean();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"runtimeEventOccurred", (Object)event);
        }
    }

    public String getName() {
        return "AttachedRemoteSubscriber." + this._remoteDurableName;
    }

    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)this._remoteDurableName);
        }
        return this._remoteDurableName;
    }

    public SIMPIterator getTopicNameIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicNameIterator");
        }
        List<Object> topicList = null;
        if (this._anycastInputHandler.getAIStream() != null) {
            String[] topics = this._anycastInputHandler.getRCD().getConsumerDispatcherState().getTopics();
            topicList = Arrays.asList(topics);
        } else {
            topicList = new LinkedList();
        }
        BasicSIMPIterator iterator = new BasicSIMPIterator(topicList.iterator());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopicNameIterator", (Object)iterator);
        }
        return iterator;
    }

    public void clearAllTopics() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clearAllTopics");
        }
        this._anycastInputHandler.forceFlushAtTarget();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clearAllTopics");
        }
    }
}

