/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.AnnotatedEndpoint;
import com.ibm.ws.wsoc.MethodData;
import com.ibm.ws.wsoc.PathParamData;
import com.ibm.ws.wsoc.impl.MethodDataImpl;
import com.ibm.ws.wsoc.impl.PathParamDataImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.DecodeException;
import javax.websocket.DeploymentException;
import javax.websocket.server.PathParam;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EndpointMethodHelper
implements Cloneable {
    private static final TraceComponent tc = Tr.register(EndpointMethodHelper.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    Method method = null;
    Class<?> inputParameterType;
    MethodData methodData = null;
    DecodeException decodeException = null;
    String endpointPath = null;
    static final long serialVersionUID = -7889375405377791488L;

    public EndpointMethodHelper(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getInputParameterType() {
        return this.inputParameterType;
    }

    public HashMap<Integer, PathParamData> getPathParams() {
        return this.methodData.getPathParams();
    }

    public void setEndpointPath(String endpointPath) {
        this.endpointPath = endpointPath;
    }

    public void setMethodData(MethodData methodData) {
        this.methodData = methodData;
    }

    public MethodData getMethodData() {
        return this.methodData;
    }

    public void introspectPathParams() throws DeploymentException {
        Class[] pathParamTypesAllowed = new Class[]{String.class, Character.TYPE, Character.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Boolean.TYPE, Boolean.class};
        List<Class> pathParamTypeList = Arrays.asList(pathParamTypesAllowed);
        Class<?>[] paramTypes = this.method.getParameterTypes();
        Annotation[][] paramAnnotations = this.method.getParameterAnnotations();
        boolean uriSegmentMatched = true;
        for (int i = 0; i < paramAnnotations.length; ++i) {
            for (Annotation annotation : paramAnnotations[i]) {
                if (annotation.annotationType() != PathParam.class) continue;
                if (pathParamTypeList.contains(paramTypes[i])) {
                    String pathParamValue = ((PathParam)annotation).value();
                    if (pathParamValue != null && !pathParamValue.isEmpty()) {
                        List<String> segments = Arrays.asList(this.endpointPath.split("/"));
                        if (!segments.contains("{" + pathParamValue + "}") && !segments.contains(pathParamValue)) {
                            if (tc.isDebugEnabled()) {
                                String msg = "@PathParam parameter " + pathParamValue + " defined on the method " + this.method.getName() + " does not have corresponding path segment in @ServerEndpoint URI in Annotated endpoint " + this.method.getDeclaringClass().getName();
                                Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                            }
                            uriSegmentMatched = false;
                        }
                        PathParamDataImpl paramData = new PathParamDataImpl(pathParamValue, i, paramTypes[i], uriSegmentMatched);
                        this.methodData.getPathParams().put(i, paramData);
                        continue;
                    }
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"missing.pathparam.value", (Object[])new Object[]{((PathParam)annotation).value(), this.method.getName(), this.method.getDeclaringClass().getName()});
                    Tr.error((TraceComponent)tc, (String)"missing.pathparam.value", (Object[])new Object[]{((PathParam)annotation).value(), this.method.getName(), this.method.getDeclaringClass().getName()});
                    throw new DeploymentException(msg);
                }
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"invalid.pathparam.type", (Object[])new Object[]{((PathParam)annotation).value(), this.method.getName(), this.method.getDeclaringClass().getName()});
                Tr.error((TraceComponent)tc, (String)"invalid.pathparam.type", (Object[])new Object[]{((PathParam)annotation).value(), this.method.getName(), this.method.getDeclaringClass().getName()});
                throw new DeploymentException(msg);
            }
        }
    }

    public void processPathParameters(AnnotatedEndpoint annotatedEP, Object[] args) throws DecodeException {
        if (this.getPathParams().isEmpty()) {
            return;
        }
        String[] endpointPathParts = annotatedEP.getEndpointPath().split("/");
        String[] requestPathParts = annotatedEP.getRequestPath().split("/");
        HashMap<Integer, PathParamData> pathParams = this.getPathParams();
        for (Map.Entry<Integer, PathParamData> mapEntry : pathParams.entrySet()) {
            Integer pathParamIndex = mapEntry.getKey();
            PathParamData pathParamData = mapEntry.getValue();
            String pathParamValue = pathParamData.getAnnotationValue();
            if (!pathParamData.isURISegmentMatched()) {
                if (pathParamData.getParamType().equals(String.class)) {
                    this.convertStringToParamType(args, pathParamIndex, null, pathParamData.getParamType());
                    continue;
                }
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"missing.path.segment", (Object[])new Object[]{pathParamValue, this.method.getName(), this.method.getDeclaringClass().getName()});
                Tr.error((TraceComponent)tc, (String)"missing.path.segment", (Object[])new Object[]{pathParamValue, this.method.getName(), this.method.getDeclaringClass().getName()});
                this.decodeException = new DecodeException(pathParamValue, msg);
                continue;
            }
            for (int i = 1; i < endpointPathParts.length; ++i) {
                if (!endpointPathParts[i].equals("{" + pathParamValue + "}") && !endpointPathParts[i].equals(pathParamValue)) continue;
                this.convertStringToParamType(args, pathParamIndex, requestPathParts[i], pathParamData.getParamType());
            }
        }
        if (this.decodeException != null) {
            throw this.decodeException;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void convertStringToParamType(Object[] args, Integer pathParamIndex, String paramValue, Class<?> pathParamData) {
        try {
            if (pathParamData.equals(String.class)) {
                args[pathParamIndex.intValue()] = paramValue;
            } else if (pathParamData.equals(Character.class) || pathParamData.equals(Character.TYPE)) {
                args[pathParamIndex.intValue()] = Character.valueOf(paramValue.toCharArray()[0]);
            } else if (pathParamData.equals(Integer.class) || pathParamData.equals(Integer.TYPE)) {
                args[pathParamIndex.intValue()] = Integer.valueOf(paramValue);
            } else if (pathParamData.equals(Byte.class) || pathParamData.equals(Byte.TYPE)) {
                args[pathParamIndex.intValue()] = Byte.valueOf(paramValue);
            } else if (pathParamData.equals(Short.class) || pathParamData.equals(Short.TYPE)) {
                args[pathParamIndex.intValue()] = Short.valueOf(paramValue);
            } else if (pathParamData.equals(Long.class) || pathParamData.equals(Long.TYPE)) {
                args[pathParamIndex.intValue()] = Long.valueOf(paramValue);
            } else if (pathParamData.equals(Double.class) || pathParamData.equals(Double.TYPE)) {
                args[pathParamIndex.intValue()] = Double.valueOf(paramValue);
            } else if (pathParamData.equals(Boolean.class) || pathParamData.equals(Boolean.TYPE)) {
                args[pathParamIndex.intValue()] = Boolean.valueOf(paramValue);
            } else if (pathParamData.equals(Float.class) || pathParamData.equals(Float.TYPE)) {
                args[pathParamIndex.intValue()] = Float.valueOf(paramValue);
            }
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wsoc.EndpointMethodHelper", (String)"234", (Object)this, (Object[])new Object[]{args, pathParamIndex, paramValue, pathParamData});
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"convertStringToParamType", (Object)this);
            if (this.method.getName().equals("onError")) {
                if (pathParamData.equals(Integer.TYPE) || pathParamData.equals(Short.TYPE) || pathParamData.equals(Double.TYPE) || pathParamData.equals(Short.TYPE) || pathParamData.equals(Long.TYPE)) {
                    args[pathParamIndex.intValue()] = -1;
                } else if (pathParamData.equals(Boolean.TYPE)) {
                    args[pathParamIndex.intValue()] = false;
                }
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"mismatch.pathparam.type", (Object[])new Object[]{this.method.getName(), this.method.getDeclaringClass().getName(), pathParamIndex, pathParamData.getName()});
            Tr.error((TraceComponent)tc, (String)"mismatch.pathparam.type", (Object[])new Object[]{this.method.getName(), this.method.getDeclaringClass().getName(), pathParamIndex, pathParamData.getName()});
            this.decodeException = new DecodeException(paramValue, msg, (Throwable)e);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("@PathParam index " + pathParamIndex + " @Pathparam type " + pathParamData.getName()), (Object[])new Object[0]);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        EndpointMethodHelper clone = (EndpointMethodHelper)super.clone();
        clone.methodData = (MethodData)((MethodDataImpl)this.methodData).clone();
        return clone;
    }
}

