/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI.IIOP;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OBPortableServer.POAPolicies;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.OCI.AcceptorInfo;
import org.apache.yoko.orb.OCI.IIOP.AcceptorInfo_impl;
import org.apache.yoko.orb.OCI.IIOP.ConnectionHelper;
import org.apache.yoko.orb.OCI.IIOP.Exceptions;
import org.apache.yoko.orb.OCI.IIOP.ExtendedConnectionHelper;
import org.apache.yoko.orb.OCI.IIOP.ListenerMap;
import org.apache.yoko.orb.OCI.IIOP.Transport_impl;
import org.apache.yoko.orb.OCI.IIOP.Util;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.ProfileInfoSeqHolder;
import org.apache.yoko.orb.OCI.Transport;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.SystemException;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IOP.Codec;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHolder;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedProfile;

final class Acceptor_impl
extends LocalObject
implements Acceptor {
    static final Logger logger = Logger.getLogger(Acceptor_impl.class.getName());
    public final String[] hosts_;
    public final ServerSocket socket_;
    private final ProfileCardinality profileCardinality;
    private final int port_;
    private final boolean keepAlive_;
    private final InetAddress localAddress_;
    private final AcceptorInfo_impl info_;
    private final ListenerMap listenMap_;
    private final ConnectionHelper connectionHelper_;
    private final ExtendedConnectionHelper extendedConnectionHelper_;
    private final Codec codec_;

    @Override
    public String id() {
        return "iiop";
    }

    @Override
    public int tag() {
        return 0;
    }

    @Override
    public int handle() {
        throw new NO_IMPLEMENT();
    }

    @Override
    public void close() {
        logger.log(Level.FINE, "Closing server socket with host=" + this.localAddress_ + ", port=" + this.port_, new Exception("Stack trace"));
        this.info_._OB_destroy();
        try {
            this.socket_.close();
            logger.log(Level.FINE, "Closed server socket with host=" + this.localAddress_ + ", port=" + this.port_);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Exception closing server socket with host=" + this.localAddress_ + ", port=" + this.port_, ex);
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void listen() {
    }

    @Override
    public Transport accept(boolean block) {
        Socket socket;
        try {
            if (!block) {
                this.socket_.setSoTimeout(1);
            } else {
                this.socket_.setSoTimeout(0);
            }
            logger.fine("Accepting connection for host=" + this.localAddress_ + ", port=" + this.port_);
            socket = this.socket_.accept();
            logger.fine("Received inbound connection on socket " + socket);
        }
        catch (InterruptedIOException ex) {
            if (!block) {
                return null;
            }
            logger.log(Level.FINE, "Failure accepting connection for host=" + this.localAddress_ + ", port=" + this.port_, ex);
            throw Exceptions.asCommFailure(ex, 1095974923);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Failure accepting connection for host=" + this.localAddress_ + ", port=" + this.port_, ex);
            throw Exceptions.asCommFailure(ex, 1095974923);
        }
        try {
            socket.setTcpNoDelay(true);
            if (this.keepAlive_) {
                socket.setKeepAlive(true);
            }
        }
        catch (SocketException ex) {
            logger.log(Level.FINE, "Failure configuring server connection for host=" + this.localAddress_ + ", port=" + this.port_, ex);
            throw Exceptions.asCommFailure(ex, 1095974918);
        }
        try {
            Transport_impl tr = new Transport_impl(this, socket, this.listenMap_);
            logger.fine("Inbound connection received from " + socket.getInetAddress());
            return tr;
        }
        catch (SystemException ex) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logger.log(Level.FINE, "error creating inbound connection", ex);
            throw ex;
        }
    }

    @Override
    public Transport connect_self() {
        Socket socket = null;
        try {
            socket = this.connectionHelper_ != null ? this.connectionHelper_.createSelfConnection(this.localAddress_, this.port_) : this.extendedConnectionHelper_.createSelfConnection(this.localAddress_, this.port_);
        }
        catch (ConnectException ex) {
            logger.log(Level.FINE, "Failure making self connection for host=" + this.localAddress_ + ", port=" + this.port_, ex);
            throw Exceptions.asTransient(ex, 1095974913);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Failure making self connection for host=" + this.localAddress_ + ", port=" + this.port_, ex);
            throw Exceptions.asCommFailure(ex, 1095974917);
        }
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException ex) {
            logger.log(Level.FINE, "Failure configuring self connection for host=" + this.localAddress_ + ", port=" + this.port_, ex);
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw Exceptions.asCommFailure(ex);
        }
        try {
            return new Transport_impl(this, socket, this.listenMap_);
        }
        catch (SystemException ex) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
    }

    @Override
    public void add_profiles(ProfileInfo profileInfo, POAPolicies policies, IORHolder iorHolder) {
        if (this.port_ == 0) {
            throw new RuntimeException();
        }
        if (this.profileCardinality == ProfileCardinality.ZERO) {
            return;
        }
        IOR ior = iorHolder.value;
        Version version = new Version(profileInfo.major, profileInfo.minor);
        short port = policies.zeroPortPolicy() ? (short)0 : (short)this.port_;
        byte[] key = profileInfo.key;
        if (profileInfo.major == 1 && profileInfo.minor == 0) {
            for (String host : this.hosts_) {
                Acceptor_impl.addNewProfile_1_0(ior, version, host, port, key);
            }
        } else {
            List<TaggedComponent> piComponents = Arrays.asList(profileInfo.components);
            switch (this.profileCardinality) {
                case ONE: {
                    String mainHost = this.hosts_[0];
                    String[] alternateHosts = Arrays.copyOfRange(this.hosts_, 1, this.hosts_.length);
                    ArrayList<TaggedComponent> components = new ArrayList<TaggedComponent>(piComponents);
                    for (String host : alternateHosts) {
                        try (OutputStream out = new OutputStream();){
                            out._OB_writeEndian();
                            out.write_string(host);
                            out.write_ushort(port);
                            components.add(new TaggedComponent(3, out.copyWrittenBytes()));
                        }
                    }
                    Acceptor_impl.addNewProfile_1_1(ior, version, mainHost, port, key, components);
                    break;
                }
                case MANY: {
                    for (String host : this.hosts_) {
                        Acceptor_impl.addNewProfile_1_1(ior, version, host, port, key, piComponents);
                    }
                    break;
                }
            }
        }
    }

    private static void addNewProfile_1_0(IOR ior, Version version, String host, short port, byte[] key) {
        ProfileBody_1_0 body = new ProfileBody_1_0(version, host, port, key);
        try (OutputStream out = new OutputStream();){
            out._OB_writeEndian();
            ProfileBody_1_0Helper.write((org.omg.CORBA.portable.OutputStream)out, (ProfileBody_1_0)body);
            ior.profiles = Arrays.copyOf(ior.profiles, ior.profiles.length + 1);
            ior.profiles[ior.profiles.length - 1] = new TaggedProfile(0, out.copyWrittenBytes());
        }
    }

    private static void addNewProfile_1_1(IOR ior, Version version, String host, short port, byte[] key, List<TaggedComponent> components) {
        ProfileBody_1_1 body = new ProfileBody_1_1(version, host, port, key, components.toArray(new TaggedComponent[0]));
        try (OutputStream out = new OutputStream();){
            out._OB_writeEndian();
            ProfileBody_1_1Helper.write((org.omg.CORBA.portable.OutputStream)out, (ProfileBody_1_1)body);
            ior.profiles = Arrays.copyOf(ior.profiles, ior.profiles.length + 1);
            ior.profiles[ior.profiles.length - 1] = new TaggedProfile(0, out.copyWrittenBytes());
        }
    }

    @Override
    public ProfileInfo[] get_local_profiles(IOR ior) {
        ProfileInfoSeqHolder profileInfoSeq = new ProfileInfoSeqHolder();
        profileInfoSeq.value = new ProfileInfo[0];
        for (String s : this.hosts_) {
            Util.extractAllProfileInfos(ior, profileInfoSeq, true, s, this.port_, true, this.codec_);
        }
        return profileInfoSeq.value;
    }

    @Override
    public AcceptorInfo get_info() {
        return this.info_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Acceptor_impl(String address, String[] hosts, ProfileCardinality profileCardinality, int port, int backlog, boolean keepAlive, ConnectionHelper helper, ExtendedConnectionHelper extendedConnectionHelper, ListenerMap lm, String[] params, Codec codec) {
        Assert.ensure(helper == null ^ extendedConnectionHelper == null);
        this.hosts_ = hosts;
        this.profileCardinality = profileCardinality;
        this.keepAlive_ = keepAlive;
        this.connectionHelper_ = helper;
        this.extendedConnectionHelper_ = extendedConnectionHelper;
        this.codec_ = codec;
        this.info_ = new AcceptorInfo_impl(this);
        this.listenMap_ = lm;
        if (backlog == 0) {
            backlog = 50;
        }
        try {
            this.localAddress_ = address == null ? InetAddress.getLocalHost() : Util.getInetAddress(address);
        }
        catch (UnknownHostException ex) {
            logger.log(Level.FINE, "Host resolution failure", ex);
            throw Exceptions.asCommFailure(ex);
        }
        try {
            this.socket_ = address == null ? (this.connectionHelper_ != null ? this.connectionHelper_.createServerSocket(port, backlog) : this.extendedConnectionHelper_.createServerSocket(port, backlog, params)) : (this.connectionHelper_ != null ? this.connectionHelper_.createServerSocket(port, backlog, this.localAddress_) : this.extendedConnectionHelper_.createServerSocket(port, backlog, this.localAddress_, params));
            this.port_ = this.socket_.getLocalPort();
            logger.fine("Acceptor created using socket " + this.socket_);
        }
        catch (BindException ex) {
            logger.log(Level.FINE, "Failure creating server socket for host=" + this.localAddress_ + ", port=" + port, ex);
            throw Exceptions.asCommFailure(ex, 1095974920);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Failure creating server socket for host=" + this.localAddress_ + ", port=" + port, ex);
            throw Exceptions.asCommFailure(ex, 1095974917);
        }
        ListenerMap listenerMap = this.listenMap_;
        synchronized (listenerMap) {
            for (String s : this.hosts_) {
                this.listenMap_.add(s, (short)this.port_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        if (this.socket_ != null) {
            this.close();
        }
        ListenerMap listenerMap = this.listenMap_;
        synchronized (listenerMap) {
            for (String s : this.hosts_) {
                this.listenMap_.remove(s, (short)this.port_);
            }
        }
    }

    public String toString() {
        return "Acceptor listening on " + this.socket_;
    }

    static enum ProfileCardinality {
        ZERO,
        ONE,
        MANY;

    }
}

