/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.apache.yoko.orb.OB.IORUtil;
import org.apache.yoko.orb.OCI.AlignmentBoundary;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.WriteBuffer;
import org.apache.yoko.util.HexConverter;

public final class ReadBuffer
extends Buffer<ReadBuffer> {
    private final Buffer.Core core;

    ReadBuffer(Buffer.Core core) {
        this.core = core;
    }

    @Override
    public int length() {
        return this.core.length;
    }

    @Override
    boolean dataEquals0(ReadBuffer that) {
        return this.core.dataEquals(that.core);
    }

    public byte peekByte() {
        return this.core.data[this.position];
    }

    public byte readByte() {
        return this.core.data[this.position++];
    }

    public char readByteAsChar() {
        return (char)this.core.data[this.position++];
    }

    public void readBytes(byte[] buffer, int offset, int length) {
        if (this.available() < length) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.core.data, this.position, buffer, offset, length);
        this.position += length;
    }

    public void readBytes(WriteBuffer buffer) {
        buffer.writeBytes(this.core.data, this.position, this.available());
    }

    public byte[] copyRemainingBytes() {
        return ReadBuffer.copyOf(this.core.data, this.available());
    }

    public char peekChar() {
        return (char)(this.core.data[this.position] << 8 | this.core.data[this.position + 1] & 0xFF);
    }

    public char readChar() {
        return (char)(this.core.data[this.position++] << 8 | this.core.data[this.position++] & 0xFF);
    }

    public char readChar_LE() {
        return (char)(this.core.data[this.position++] & 0xFF | this.core.data[this.position++] << 8);
    }

    public String remainingBytesToAscii() {
        return HexConverter.octetsToAscii((byte[])this.core.data, (int)this.available());
    }

    @Override
    void dumpData(StringBuilder dump) {
        this.core.dumpTo(dump);
    }

    public String dumpRemainingData() {
        StringBuilder dump = new StringBuilder();
        dump.append(String.format("Core pos=0x%x Core len=0x%x Remaining core data=%n%n", this.position, this.core.length));
        IORUtil.dump_octets(this.core.data, this.position, this.available(), dump);
        return dump.toString();
    }

    public String dumpAllDataWithPosition() {
        StringBuilder sb = new StringBuilder();
        IORUtil.dump_octets(this.core.data, 0, this.position, sb);
        sb.append(String.format("------------------ pos = 0x%08X -------------------%n", this.position));
        IORUtil.dump_octets(this.core.data, this.position, this.available(), sb);
        return sb.toString();
    }

    public ReadBuffer writeTo(OutputStream out) throws IOException {
        try {
            out.write(this.core.data, this.position, this.available());
            out.flush();
            this.position = this.core.length;
            return this;
        }
        catch (InterruptedIOException ex) {
            this.position += ex.bytesTransferred;
            throw ex;
        }
    }

    public ReadBuffer rewindToStart() {
        this.position = 0;
        return this;
    }

    public ReadBuffer align(AlignmentBoundary boundary) {
        this.position = boundary.newIndex(this.position);
        return this;
    }

    public ReadBuffer skipBytes(int n) {
        if (this.position + n > this.core.length) {
            throw new IndexOutOfBoundsException();
        }
        this.position += n;
        return this;
    }

    public ReadBuffer skipToEnd() {
        this.position = this.core.length;
        return this;
    }
}

