/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.EndpointPolicyImpl;
import org.apache.cxf.ws.policy.PolicyEngineImpl;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.cxf.ws.policy.PolicyUtils;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyContainingAssertion;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class EffectivePolicyImpl
implements EffectivePolicy {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(EffectivePolicyImpl.class);
    private static final Logger LOG = LogUtils.getL7dLogger(EffectivePolicyImpl.class);
    protected Policy policy;
    protected Collection<Assertion> chosenAlternative;
    protected List<Interceptor<? extends Message>> interceptors;
    static final long serialVersionUID = 8057800473622582711L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EffectivePolicyImpl() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Policy getPolicy() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "getPolicy", new Object[0]);
        }
        Policy policy = this.policy;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            policy = policy;
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "getPolicy", policy);
        }
        return policy;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Interceptor<? extends Message>> getInterceptors() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "getInterceptors", new Object[0]);
        }
        List<Interceptor<? extends Message>> list = this.interceptors;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "getInterceptors", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Collection<Assertion> getChosenAlternative() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "getChosenAlternative", new Object[0]);
        }
        Collection<Assertion> collection = this.chosenAlternative;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            collection = collection;
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "getChosenAlternative", collection);
        }
        return collection;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void initialise(EndpointPolicyImpl epi, PolicyEngineImpl engine, boolean inbound) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialise", new Object[]{epi, engine, inbound});
        }
        this.initialise(epi, engine, inbound, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialise");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void initialise(EndpointPolicyImpl epi, PolicyEngineImpl engine, boolean inbound, boolean fault) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialise", new Object[]{epi, engine, inbound, fault});
        }
        this.policy = epi.getPolicy();
        this.chosenAlternative = epi.getChosenAlternative();
        if (this.chosenAlternative == null) {
            this.chooseAlternative(engine, null);
        }
        this.initialiseInterceptors(engine, inbound, fault);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialise");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void initialise(EndpointInfo ei, BindingOperationInfo boi, PolicyEngineImpl engine, Assertor assertor, boolean requestor, boolean request) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialise", new Object[]{ei, boi, engine, assertor, requestor, request});
        }
        this.initialisePolicy(ei, boi, engine, requestor, request, assertor);
        this.chooseAlternative(engine, assertor);
        this.initialiseInterceptors(engine, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialise");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void initialise(EndpointInfo ei, BindingOperationInfo boi, PolicyEngineImpl engine, Assertor assertor, boolean requestor, boolean request, List<List<Assertion>> incoming) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialise", new Object[]{ei, boi, engine, assertor, requestor, request, incoming});
        }
        this.initialisePolicy(ei, boi, engine, requestor, request, assertor);
        this.chooseAlternative(engine, assertor, incoming);
        this.initialiseInterceptors(engine, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialise");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void initialise(EndpointInfo ei, BindingOperationInfo boi, PolicyEngineImpl engine, boolean requestor, boolean request) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialise", new Object[]{ei, boi, engine, requestor, request});
        }
        Assertor assertor = this.initialisePolicy(ei, boi, engine, requestor, request, null);
        this.chooseAlternative(engine, assertor);
        this.initialiseInterceptors(engine, requestor);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialise");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void initialise(EndpointInfo ei, BindingOperationInfo boi, BindingFaultInfo bfi, PolicyEngineImpl engine, Assertor assertor) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialise", new Object[]{ei, boi, bfi, engine, assertor});
        }
        this.initialisePolicy(ei, boi, bfi, engine);
        this.chooseAlternative(engine, assertor);
        this.initialiseInterceptors(engine, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialise");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private <T> T getAssertorAs(Assertor as, Class<T> t) {
        org.apache.cxf.transport.Assertor o;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "getAssertorAs", new Object[]{as, t});
        }
        if (t.isInstance(as)) {
            T t2 = t.cast(as);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                t2 = t2;
                LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "getAssertorAs", t2);
            }
            return t2;
        }
        if (as instanceof PolicyUtils.WrappedAssertor && t.isInstance(o = ((PolicyUtils.WrappedAssertor)as).getWrappedAssertor())) {
            T t3 = t.cast(o);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                t3 = t3;
                LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "getAssertorAs", t3);
            }
            return t3;
        }
        T t4 = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t4 = t4;
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "getAssertorAs", t4);
        }
        return t4;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    Assertor initialisePolicy(EndpointInfo ei, BindingOperationInfo boi, PolicyEngineImpl engine, boolean requestor, boolean request, Assertor assertor) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialisePolicy", new Object[]{ei, boi, engine, requestor, request, assertor});
        }
        if (boi.isUnwrapped()) {
            boi = boi.getUnwrappedOperation();
        }
        BindingMessageInfo bmi = request ? boi.getInput() : boi.getOutput();
        EndpointPolicy ep = requestor ? engine.getClientEndpointPolicy(ei, this.getAssertorAs(assertor, Conduit.class)) : engine.getServerEndpointPolicy(ei, this.getAssertorAs(assertor, Destination.class));
        this.policy = ep.getPolicy();
        if (ep instanceof EndpointPolicyImpl) {
            assertor = ((EndpointPolicyImpl)ep).getAssertor();
        }
        this.policy = this.policy.merge(engine.getAggregatedOperationPolicy(boi));
        if (null != bmi) {
            this.policy = this.policy.merge(engine.getAggregatedMessagePolicy(bmi));
        }
        this.policy = this.policy.normalize(engine.getRegistry(), true);
        Assertor assertor2 = assertor;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            assertor2 = assertor2;
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialisePolicy", assertor2);
        }
        return assertor2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void initialisePolicy(EndpointInfo ei, BindingOperationInfo boi, BindingFaultInfo bfi, PolicyEngineImpl engine) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialisePolicy", new Object[]{ei, boi, bfi, engine});
        }
        this.policy = engine.getServerEndpointPolicy(ei, null).getPolicy();
        this.policy = this.policy.merge(engine.getAggregatedOperationPolicy(boi));
        if (bfi != null) {
            this.policy = this.policy.merge(engine.getAggregatedFaultPolicy(bfi));
        }
        this.policy = this.policy.normalize(engine.getRegistry(), true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialisePolicy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void chooseAlternative(PolicyEngineImpl engine, Assertor assertor) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "chooseAlternative", new Object[]{engine, assertor});
        }
        this.chooseAlternative(engine, assertor, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "chooseAlternative");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void chooseAlternative(PolicyEngineImpl engine, Assertor assertor, List<List<Assertion>> incoming) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "chooseAlternative", new Object[]{engine, assertor, incoming});
        }
        Collection<Assertion> alternative = engine.getAlternativeSelector().selectAlternative(this.policy, engine, assertor, incoming);
        if (null == alternative) {
            PolicyUtils.logPolicy(LOG, Level.FINE, "No alternative supported.", (PolicyComponent)this.getPolicy());
            throw new PolicyException(new org.apache.cxf.common.i18n.Message("NO_ALTERNATIVE_EXC", BUNDLE, new Object[0]));
        }
        this.setChosenAlternative(alternative);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "chooseAlternative");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void initialiseInterceptors(PolicyEngineImpl engine) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialiseInterceptors", new Object[]{engine});
        }
        this.initialiseInterceptors(engine, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialiseInterceptors");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void initialiseInterceptors(PolicyEngineImpl engine, boolean useIn) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialiseInterceptors", new Object[]{engine, useIn});
        }
        this.initialiseInterceptors(engine, useIn, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialiseInterceptors");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void initialiseInterceptors(PolicyEngineImpl engine, boolean useIn, boolean fault) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialiseInterceptors", new Object[]{engine, useIn, fault});
        }
        if (engine.getBus() != null) {
            PolicyInterceptorProviderRegistry reg = (PolicyInterceptorProviderRegistry)engine.getBus().getExtension(PolicyInterceptorProviderRegistry.class);
            LinkedHashSet<Interceptor<? extends Message>> out = new LinkedHashSet<Interceptor<? extends Message>>();
            for (Assertion a : this.getChosenAlternative()) {
                this.initialiseInterceptors(reg, engine, out, a, useIn, fault);
            }
            this.setInterceptors(new ArrayList<Interceptor<? extends Message>>(out));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialiseInterceptors");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Collection<Assertion> getSupportedAlternatives(PolicyEngineImpl engine, Policy p) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "getSupportedAlternatives", new Object[]{engine, p});
        }
        ArrayList<Assertion> alternatives = new ArrayList<Assertion>();
        Iterator it = p.getAlternatives();
        while (it.hasNext()) {
            List alternative = (List)it.next();
            if (!engine.supportsAlternative(alternative, null)) continue;
            alternatives.addAll(alternative);
        }
        ArrayList<Assertion> arrayList = alternatives;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "getSupportedAlternatives", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void initialiseInterceptors(PolicyInterceptorProviderRegistry reg, PolicyEngineImpl engine, Set<Interceptor<? extends Message>> out, Assertion a, boolean useIn, boolean fault) {
        Policy p;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialiseInterceptors", new Object[]{reg, engine, out, a, useIn, fault});
        }
        QName qn = a.getName();
        List<Interceptor<? extends Message>> i = null;
        if (useIn && !fault) {
            i = reg.getInInterceptorsForAssertion(qn);
        } else if (!useIn && !fault) {
            i = reg.getOutInterceptorsForAssertion(qn);
        } else if (useIn && fault) {
            i = reg.getInFaultInterceptorsForAssertion(qn);
        } else if (!useIn && fault) {
            i = reg.getOutFaultInterceptorsForAssertion(qn);
        }
        out.addAll(i);
        if (a instanceof PolicyContainingAssertion && (p = ((PolicyContainingAssertion)a).getPolicy()) != null) {
            for (Assertion a2 : this.getSupportedAlternatives(engine, p)) {
                this.initialiseInterceptors(reg, engine, out, a2, useIn, fault);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "initialiseInterceptors");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setPolicy(Policy ep) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "setPolicy", new Object[]{ep});
        }
        this.policy = ep;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "setPolicy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setChosenAlternative(Collection<Assertion> c) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "setChosenAlternative", new Object[]{c});
        }
        this.chosenAlternative = c;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "setChosenAlternative");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setInterceptors(List<Interceptor<? extends Message>> out) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.EffectivePolicyImpl", "setInterceptors", new Object[]{out});
        }
        this.interceptors = out;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.EffectivePolicyImpl", "setInterceptors");
        }
    }
}

