/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Policies;
import org.apache.cxf.annotations.Policy;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.resource.ExtendedURIResolver;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.DescriptionInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.policy.PolicyBean;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class PolicyAnnotationListener
implements FactoryBeanListener {
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyAnnotationListener.class);
    private static final String EXTRA_POLICIES = PolicyAnnotationListener.class.getName() + ".EXTRA_POLICIES";
    private Bus bus;
    static final long serialVersionUID = -6558490384512496595L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PolicyAnnotationListener(Bus bus) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyAnnotationListener", "<init>", new Object[]{bus});
        }
        this.bus = bus;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PolicyAnnotationListener() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyAnnotationListener", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleEvent(FactoryBeanListener.Event ev, AbstractServiceFactoryBean factory, Object ... args) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyAnnotationListener", "handleEvent", new Object[]{ev, factory, args});
        }
        switch (ev) {
            case INTERFACE_CREATED: {
                InterfaceInfo ii = (InterfaceInfo)args[0];
                Class cls = (Class)args[1];
                this.addPolicies(factory, ii, cls);
                break;
            }
            case ENDPOINT_SELECTED: {
                Class cls = (Class)args[2];
                Endpoint ep = (Endpoint)args[1];
                if (ep.getEndpointInfo().getInterface() == null) break;
                this.addPolicies(factory, ep, cls);
                break;
            }
            case SERVER_CREATED: {
                Class cls = (Class)args[2];
                Server server = (Server)args[0];
                if (server.getEndpoint().getEndpointInfo().getInterface() == null) break;
                this.addPolicies(factory, server, cls);
                break;
            }
            case INTERFACE_OPERATION_BOUND: {
                OperationInfo inf = (OperationInfo)args[0];
                Method m = (Method)args[1];
                this.addPolicies(factory, inf, m);
                break;
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "handleEvent");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addPolicies(AbstractServiceFactoryBean factory, OperationInfo inf, Method m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicies", new Object[]{factory, inf, m});
        }
        Policy p = m.getAnnotation(Policy.class);
        Policies ps = m.getAnnotation(Policies.class);
        if (p != null || ps != null) {
            ArrayList<Policy> list = new ArrayList<Policy>();
            if (p != null) {
                list.add(p);
            }
            if (ps != null) {
                list.addAll(Arrays.asList(ps.value()));
            }
            ListIterator it = list.listIterator();
            block6: while (it.hasNext()) {
                p = (Policy)it.next();
                Policy.Placement place = p.placement();
                if (place == Policy.Placement.DEFAULT) {
                    place = Policy.Placement.BINDING_OPERATION;
                }
                ServiceInfo service = inf.getInterface().getService();
                Class<?> cls = m.getDeclaringClass();
                switch (place) {
                    case PORT_TYPE_OPERATION: {
                        this.addPolicy((AbstractPropertiesHolder)inf, service, p, cls, inf.getName().getLocalPart() + "PortTypeOpPolicy");
                        it.remove();
                        break;
                    }
                    case PORT_TYPE_OPERATION_INPUT: {
                        this.addPolicy((AbstractPropertiesHolder)inf.getInput(), service, p, cls, inf.getName().getLocalPart() + "PortTypeOpInputPolicy");
                        it.remove();
                        break;
                    }
                    case PORT_TYPE_OPERATION_OUTPUT: {
                        this.addPolicy((AbstractPropertiesHolder)inf.getOutput(), service, p, cls, inf.getName().getLocalPart() + "PortTypeOpOutputPolicy");
                        it.remove();
                        break;
                    }
                    case PORT_TYPE_OPERATION_FAULT: {
                        for (FaultInfo f : inf.getFaults()) {
                            if (!p.faultClass().equals(f.getProperty(Class.class.getName()))) continue;
                            this.addPolicy((AbstractPropertiesHolder)f, service, p, cls, f.getName().getLocalPart() + "PortTypeOpFaultPolicy");
                            it.remove();
                        }
                        continue block6;
                    }
                }
            }
            if (!list.isEmpty()) {
                List stuff = CastUtils.cast((List)((List)inf.getProperty(EXTRA_POLICIES)));
                if (stuff != null) {
                    stuff.addAll(list);
                } else {
                    inf.setProperty(EXTRA_POLICIES, list);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicies");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addPolicies(AbstractServiceFactoryBean factory, Endpoint ep, Class<?> cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicies", new Object[]{factory, ep, cls});
        }
        List list = CastUtils.cast((List)((List)ep.getEndpointInfo().getInterface().removeProperty(EXTRA_POLICIES)));
        if (list != null) {
            this.addPolicies(factory, ep, cls, list, Policy.Placement.BINDING);
        }
        ServiceInfo service = (ServiceInfo)ep.getService().getServiceInfos().get(0);
        for (BindingOperationInfo binfo : ep.getBinding().getBindingInfo().getOperations()) {
            List later = CastUtils.cast((List)((List)binfo.getOperationInfo().removeProperty(EXTRA_POLICIES)));
            if (later == null) continue;
            block7: for (Policy p : later) {
                switch (p.placement()) {
                    case DEFAULT: 
                    case BINDING_OPERATION: {
                        this.addPolicy((AbstractPropertiesHolder)binfo, service, p, cls, binfo.getName().getLocalPart() + "BindingOpPolicy");
                        break;
                    }
                    case BINDING_OPERATION_INPUT: {
                        this.addPolicy((AbstractPropertiesHolder)binfo.getInput(), service, p, cls, binfo.getName().getLocalPart() + "BindingOpInputPolicy");
                        break;
                    }
                    case BINDING_OPERATION_OUTPUT: {
                        this.addPolicy((AbstractPropertiesHolder)binfo.getOutput(), service, p, cls, binfo.getName().getLocalPart() + "BindingOpOutputPolicy");
                        break;
                    }
                    case BINDING_OPERATION_FAULT: {
                        for (BindingFaultInfo f : binfo.getFaults()) {
                            if (!p.faultClass().equals(f.getFaultInfo().getProperty(Class.class.getName()))) continue;
                            this.addPolicy((AbstractPropertiesHolder)f, service, p, cls, f.getFaultInfo().getName().getLocalPart() + "BindingOpFaultPolicy");
                        }
                        continue block7;
                    }
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicies");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addPolicies(AbstractServiceFactoryBean factory, Server server, Class<?> cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicies", new Object[]{factory, server, cls});
        }
        ArrayList<Policy> list = CastUtils.cast((List)((List)server.getEndpoint().getEndpointInfo().getInterface().removeProperty(EXTRA_POLICIES)));
        if (list != null) {
            this.addPolicies(factory, server.getEndpoint(), cls, (List<Policy>)list, Policy.Placement.BINDING);
        }
        if (cls == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicies");
            }
            return;
        }
        Policy p = cls.getAnnotation(Policy.class);
        Policies ps = cls.getAnnotation(Policies.class);
        if (p != null || ps != null) {
            list = new ArrayList<Policy>();
            if (p != null) {
                list.add(p);
            }
            if (ps != null) {
                list.addAll(Arrays.asList(ps.value()));
            }
            this.addPolicies(factory, server.getEndpoint(), cls, list, Policy.Placement.SERVICE);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicies");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addPolicies(AbstractServiceFactoryBean factory, Endpoint endpoint, Class<?> cls, List<Policy> list, Policy.Placement defaultPlace) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicies", new Object[]{factory, endpoint, cls, list, defaultPlace});
        }
        ListIterator<Policy> it = list.listIterator();
        InterfaceInfo inf = endpoint.getEndpointInfo().getInterface();
        BindingInfo binf = endpoint.getBinding().getBindingInfo();
        ServiceInfo si = (ServiceInfo)endpoint.getService().getServiceInfos().get(0);
        while (it.hasNext()) {
            Policy p = it.next();
            Policy.Placement place = p.placement();
            if (place == Policy.Placement.DEFAULT) {
                place = defaultPlace;
            }
            switch (place) {
                case PORT_TYPE: {
                    this.addPolicy((AbstractPropertiesHolder)inf, si, p, cls, inf.getName().getLocalPart() + "PortTypePolicy");
                    it.remove();
                    break;
                }
                case BINDING: {
                    this.addPolicy((AbstractPropertiesHolder)binf, si, p, cls, binf.getName().getLocalPart() + "BindingPolicy");
                    it.remove();
                    break;
                }
                case SERVICE: {
                    this.addPolicy((AbstractPropertiesHolder)si, si, p, cls, si.getName().getLocalPart() + "ServicePolicy");
                    it.remove();
                    break;
                }
                case SERVICE_PORT: {
                    this.addPolicy((AbstractPropertiesHolder)endpoint.getEndpointInfo(), si, p, cls, endpoint.getEndpointInfo().getName().getLocalPart() + "PortPolicy");
                    it.remove();
                    break;
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicies");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addPolicies(AbstractServiceFactoryBean factory, InterfaceInfo ii, Class<?> cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicies", new Object[]{factory, ii, cls});
        }
        if (cls == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicies");
            }
            return;
        }
        Policy p = cls.getAnnotation(Policy.class);
        Policies ps = cls.getAnnotation(Policies.class);
        if (p != null || ps != null) {
            ArrayList<Policy> list = new ArrayList<Policy>();
            if (p != null) {
                list.add(p);
            }
            if (ps != null) {
                list.addAll(Arrays.asList(ps.value()));
            }
            ListIterator it = list.listIterator();
            while (it.hasNext()) {
                p = (Policy)it.next();
                Policy.Placement place = p.placement();
                if (place == Policy.Placement.DEFAULT) {
                    place = Policy.Placement.BINDING;
                }
                switch (place) {
                    case PORT_TYPE: {
                        this.addPolicy((AbstractPropertiesHolder)ii, ii.getService(), p, cls, ii.getName().getLocalPart() + "PortTypePolicy");
                        it.remove();
                        break;
                    }
                    case SERVICE: {
                        this.addPolicy((AbstractPropertiesHolder)ii.getService(), ii.getService(), p, cls, ii.getService().getName().getLocalPart() + "ServicePolicy");
                        it.remove();
                        break;
                    }
                }
            }
            if (!list.isEmpty()) {
                List stuff = CastUtils.cast((List)((List)ii.getProperty(EXTRA_POLICIES)));
                if (stuff != null) {
                    stuff.addAll(list);
                } else {
                    ii.setProperty(EXTRA_POLICIES, list);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicies");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addPolicy(AbstractPropertiesHolder place, ServiceInfo service, Policy p, Class<?> cls, String defName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicy", new Object[]{place, service, p, cls, defName});
        }
        Element el = this.addPolicy(service, p, cls, defName);
        if (el != null) {
            UnknownExtensibilityElement uee = new UnknownExtensibilityElement();
            uee.setElement(el);
            uee.setRequired(Boolean.valueOf(true));
            uee.setElementType(DOMUtils.getElementQName((Element)el));
            place.addExtensor((Object)uee);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Element addPolicy(ServiceInfo service, Policy p, Class<?> cls, String defName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicy", new Object[]{service, p, cls, defName});
        }
        String uri = p.uri();
        String ns = "http://www.w3.org/ns/ws-policy";
        if (p.includeInWSDL()) {
            Element element = this.loadPolicy(uri, defName);
            if (element == null) {
                Element element2 = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    element2 = element2;
                    LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicy", element2);
                }
                return element2;
            }
            uri = this.getPolicyId(element);
            ns = element.getNamespaceURI();
            if (service.getDescription() == null && cls != null) {
                service.setDescription(new DescriptionInfo());
                URL u = cls.getResource("/");
                if (u != null) {
                    service.getDescription().setBaseURI(u.toString());
                }
            }
            if (!this.isExistsPolicy(service, uri)) {
                UnknownExtensibilityElement uee = new UnknownExtensibilityElement();
                uee.setElement(element);
                uee.setRequired(Boolean.valueOf(true));
                uee.setElementType(DOMUtils.getElementQName((Element)element));
                service.getDescription().addExtensor((Object)uee);
            }
            uri = "#" + uri;
        }
        Document doc = DOMUtils.createDocument();
        Element el = doc.createElementNS(ns, "wsp:PolicyReference");
        Attr att = doc.createAttributeNS(null, "URI");
        att.setValue(uri);
        el.setAttributeNodeNS(att);
        Element element = el;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            element = element;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "addPolicy", element);
        }
        return element;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getPolicyId(Element element) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyAnnotationListener", "getPolicyId", new Object[]{element});
        }
        String string = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "getPolicyId", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isExistsPolicy(ServiceInfo service, String uri) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyAnnotationListener", "isExistsPolicy", new Object[]{service, uri});
        }
        Object[] exts = (Object[])service.getDescription().getExtensors().get();
        for (Object o : exts = exts == null ? new Object[]{} : exts) {
            UnknownExtensibilityElement uee;
            String uri2;
            if (!(o instanceof UnknownExtensibilityElement) || !uri.equals(uri2 = this.getPolicyId((uee = (UnknownExtensibilityElement)o).getElement()))) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "isExistsPolicy", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "isExistsPolicy", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Element loadPolicy(String uri, String defName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyAnnotationListener", "loadPolicy", new Object[]{uri, defName});
        }
        if (!uri.startsWith("#")) {
            Element element = this.loadRemotePolicy(uri, defName);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                element = element;
                LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "loadPolicy", element);
            }
            return element;
        }
        Element element = this.loadLocalPolicy(uri);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            element = element;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "loadPolicy", element);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Element loadRemotePolicy(String uri, String defName) {
        Element element;
        block12: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.ws.policy.PolicyAnnotationListener", "loadRemotePolicy", new Object[]{uri, defName});
            }
            ExtendedURIResolver resolver = new ExtendedURIResolver();
            InputSource src = null;
            try {
                src = resolver.resolve(uri, "classpath:");
            }
            catch (ConnectException | SocketTimeoutException iOException) {
                // empty catch block
            }
            if (null == src) {
                Element element2 = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    element2 = element2;
                    LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "loadRemotePolicy", element2);
                }
                return element2;
            }
            XMLStreamReader reader = null;
            try {
                reader = StaxUtils.createXMLStreamReader((InputSource)src);
                Document doc = StaxUtils.read((XMLStreamReader)reader);
                uri = this.getPolicyId(doc.getDocumentElement());
                if (StringUtils.isEmpty((String)uri)) {
                    uri = defName;
                    Attr att = doc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id");
                    att.setNodeValue(defName);
                    doc.getDocumentElement().setAttributeNodeNS(att);
                }
                Element element3 = doc.getDocumentElement();
                element = element3;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block12;
            }
            catch (XMLStreamException e) {
                LOG.log(Level.WARNING, e.getMessage());
                Element element4 = null;
                Element element5 = element4;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    element5 = element5;
                    LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "loadRemotePolicy", element5);
                }
                return element5;
            }
            finally {
                StaxUtils.close((XMLStreamReader)reader);
            }
            element = element;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "loadRemotePolicy", element);
        }
        return element;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Element loadLocalPolicy(String uri) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyAnnotationListener", "loadLocalPolicy", new Object[]{uri});
        }
        PolicyBean pb = (PolicyBean)((ConfiguredBeanLocator)this.bus.getExtension(ConfiguredBeanLocator.class)).getBeanOfType(uri.substring(1), PolicyBean.class);
        if (null != pb) {
            Element element = pb.getElement();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                element = element;
                LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "loadLocalPolicy", element);
            }
            return element;
        }
        Element element = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            element = element;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyAnnotationListener", "loadLocalPolicy", element);
        }
        return element;
    }
}

