/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.extension.BusExtension;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.factory.FactoryBeanListenerManager;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.AlternativeSelector;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.ClientPolicyInFaultInterceptor;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.EffectivePolicyImpl;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.EndpointPolicyImpl;
import org.apache.cxf.ws.policy.PolicyAnnotationListener;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyInInterceptor;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.cxf.ws.policy.PolicyOutInterceptor;
import org.apache.cxf.ws.policy.PolicyProvider;
import org.apache.cxf.ws.policy.PolicyRegistryImpl;
import org.apache.cxf.ws.policy.PolicyUtils;
import org.apache.cxf.ws.policy.PolicyVerificationInFaultInterceptor;
import org.apache.cxf.ws.policy.ServerPolicyOutFaultInterceptor;
import org.apache.cxf.ws.policy.selector.MinimalAlternativeSelector;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyOperator;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;

@NoJSR250Annotations(unlessNull={"bus"})
@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class PolicyEngineImpl
implements PolicyEngine,
BusExtension {
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyEngineImpl.class);
    private static final String POLICY_INFO_REQUEST_SERVER = "policy-engine-info-serve-request";
    private static final String POLICY_INFO_FAULT_SERVER = "policy-engine-info-serve-fault";
    private static final String POLICY_INFO_RESPONSE_SERVER = "policy-engine-info-serve-response";
    private static final String POLICY_INFO_ENDPOINT_SERVER = "policy-engine-info-serve-rendpoint";
    private static final String POLICY_INFO_REQUEST_CLIENT = "policy-engine-info-client-request";
    private static final String POLICY_INFO_FAULT_CLIENT = "policy-engine-info-client-fault";
    private static final String POLICY_INFO_RESPONSE_CLIENT = "policy-engine-info-client-response";
    private static final String POLICY_INFO_ENDPOINT_CLIENT = "policy-engine-info-client-endpoint";
    private static boolean ignoreUnsupportedPolicy;
    private Bus bus;
    private PolicyRegistry registry;
    private Collection<PolicyProvider> policyProviders;
    private Collection<PolicyProvider> preSetPolicyProviders;
    private boolean enabled;
    private Boolean ignoreUnknownAssertions;
    private boolean addedBusInterceptors;
    private AlternativeSelector alternativeSelector;
    static final long serialVersionUID = 589688570730248509L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PolicyEngineImpl() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "<init>", new Object[0]);
        }
        this.preSetPolicyProviders = new LinkedList<PolicyProvider>();
        this.enabled = true;
        this.init();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PolicyEngineImpl(boolean en) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "<init>", new Object[]{en});
        }
        this.preSetPolicyProviders = new LinkedList<PolicyProvider>();
        this.enabled = true;
        this.enabled = en;
        this.init();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PolicyEngineImpl(Bus b) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "<init>", new Object[]{b});
        }
        this.preSetPolicyProviders = new LinkedList<PolicyProvider>();
        this.enabled = true;
        this.init();
        this.setBus(b);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isEnabled() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "isEnabled", new Object[0]);
        }
        boolean bl = this.enabled;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "isEnabled", bl);
        }
        return bl;
    }

    @Resource
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final void setBus(Bus b) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "setBus", new Object[]{b});
        }
        if (this.bus == b) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "setBus");
            }
            return;
        }
        this.bus = b;
        this.addBusInterceptors();
        FactoryBeanListenerManager fblm = (FactoryBeanListenerManager)this.bus.getExtension(FactoryBeanListenerManager.class);
        if (fblm != null) {
            for (FactoryBeanListener l : fblm.getListeners()) {
                if (!(l instanceof PolicyAnnotationListener)) continue;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "setBus");
                }
                return;
            }
            fblm.addListener((FactoryBeanListener)new PolicyAnnotationListener(this.bus));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "setBus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Bus getBus() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getBus", new Object[0]);
        }
        Bus bus = this.bus;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bus = bus;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getBus", bus);
        }
        return bus;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setPolicyProviders(Collection<PolicyProvider> p) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "setPolicyProviders", new Object[]{p});
        }
        this.policyProviders = new CopyOnWriteArrayList<PolicyProvider>(p);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "setPolicyProviders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void addPolicyProvider(PolicyProvider p) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "addPolicyProvider", new Object[]{p});
        }
        if (this.policyProviders != null) {
            this.policyProviders.add(p);
        } else {
            this.preSetPolicyProviders.add(p);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "addPolicyProvider");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized Collection<PolicyProvider> getPolicyProviders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getPolicyProviders", new Object[0]);
        }
        if (this.policyProviders == null) {
            ConfiguredBeanLocator loc;
            this.policyProviders = new CopyOnWriteArrayList<PolicyProvider>();
            if (this.bus != null && (loc = (ConfiguredBeanLocator)this.bus.getExtension(ConfiguredBeanLocator.class)) != null) {
                loc.getBeansOfType(PolicyProvider.class);
            }
            this.policyProviders.addAll(this.preSetPolicyProviders);
            this.preSetPolicyProviders = null;
        }
        Collection<PolicyProvider> collection = this.policyProviders;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            collection = collection;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getPolicyProviders", collection);
        }
        return collection;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setRegistry(PolicyRegistry r) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "setRegistry", new Object[]{r});
        }
        this.registry = r;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "setRegistry");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PolicyRegistry getRegistry() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getRegistry", new Object[0]);
        }
        PolicyRegistry policyRegistry = this.registry;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            policyRegistry = policyRegistry;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getRegistry", policyRegistry);
        }
        return policyRegistry;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void setEnabled(boolean e) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "setEnabled", new Object[]{e});
        }
        this.enabled = e;
        if (this.enabled && !this.addedBusInterceptors) {
            this.addBusInterceptors();
        } else if (!this.enabled && this.addedBusInterceptors) {
            this.removeBusInterceptors();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "setEnabled");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized AlternativeSelector getAlternativeSelector() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAlternativeSelector", new Object[0]);
        }
        if (this.alternativeSelector == null && this.enabled) {
            this.alternativeSelector = new MinimalAlternativeSelector();
        }
        AlternativeSelector alternativeSelector = this.alternativeSelector;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            alternativeSelector = alternativeSelector;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAlternativeSelector", alternativeSelector);
        }
        return alternativeSelector;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setAlternativeSelector(AlternativeSelector as) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "setAlternativeSelector", new Object[]{as});
        }
        this.alternativeSelector = as;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "setAlternativeSelector");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isIgnoreUnknownAssertions() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "isIgnoreUnknownAssertions", new Object[0]);
        }
        boolean bl = this.ignoreUnknownAssertions == null ? true : this.ignoreUnknownAssertions;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "isIgnoreUnknownAssertions", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setIgnoreUnknownAssertions(boolean ignore) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "setIgnoreUnknownAssertions", new Object[]{ignore});
        }
        this.ignoreUnknownAssertions = ignore;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "setIgnoreUnknownAssertions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<?> getRegistrationType() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getRegistrationType", new Object[0]);
        }
        Class<PolicyEngine> clazz = PolicyEngine.class;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getRegistrationType", clazz);
        }
        return clazz;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EffectivePolicy getEffectiveClientRequestPolicy(EndpointInfo ei, BindingOperationInfo boi, Conduit c) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEffectiveClientRequestPolicy", new Object[]{ei, boi, c});
        }
        EffectivePolicy effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_REQUEST_CLIENT);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            Assertor assertor = PolicyUtils.createAsserter(c);
            epi.initialise(ei, boi, this, assertor, true, true);
            boi.setProperty(POLICY_INFO_REQUEST_CLIENT, (Object)epi);
            effectivePolicy = epi;
        }
        EffectivePolicy effectivePolicy2 = effectivePolicy;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            effectivePolicy2 = effectivePolicy2;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEffectiveClientRequestPolicy", effectivePolicy2);
        }
        return effectivePolicy2;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setEffectiveClientRequestPolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "setEffectiveClientRequestPolicy", new Object[]{ei, boi, ep});
        }
        boi.setProperty(POLICY_INFO_REQUEST_CLIENT, (Object)ep);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "setEffectiveClientRequestPolicy");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EffectivePolicy getEffectiveServerResponsePolicy(EndpointInfo ei, BindingOperationInfo boi, Destination d, List<List<Assertion>> incoming) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEffectiveServerResponsePolicy", new Object[]{ei, boi, d, incoming});
        }
        if (incoming == null) {
            EffectivePolicy effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_RESPONSE_SERVER);
            if (null == effectivePolicy) {
                EffectivePolicyImpl epi = this.createOutPolicyInfo();
                Assertor assertor = PolicyUtils.createAsserter(d);
                epi.initialise(ei, boi, this, assertor, false, false, incoming);
                boi.setProperty(POLICY_INFO_RESPONSE_SERVER, (Object)epi);
                effectivePolicy = epi;
            }
            EffectivePolicy effectivePolicy2 = effectivePolicy;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                effectivePolicy2 = effectivePolicy2;
                LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEffectiveServerResponsePolicy", effectivePolicy2);
            }
            return effectivePolicy2;
        }
        EffectivePolicyImpl epi = this.createOutPolicyInfo();
        Assertor assertor = PolicyUtils.createAsserter(d);
        epi.initialise(ei, boi, this, assertor, false, false, incoming);
        EffectivePolicyImpl effectivePolicyImpl = epi;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            effectivePolicyImpl = effectivePolicyImpl;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEffectiveServerResponsePolicy", effectivePolicyImpl);
        }
        return effectivePolicyImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setEffectiveServerResponsePolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "setEffectiveServerResponsePolicy", new Object[]{ei, boi, ep});
        }
        boi.setProperty(POLICY_INFO_RESPONSE_SERVER, (Object)ep);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "setEffectiveServerResponsePolicy");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EffectivePolicy getEffectiveServerFaultPolicy(EndpointInfo ei, BindingOperationInfo boi, BindingFaultInfo bfi, Destination d) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEffectiveServerFaultPolicy", new Object[]{ei, boi, bfi, d});
        }
        if (bfi == null) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            Assertor assertor = PolicyUtils.createAsserter(d);
            epi.initialise(ei, boi, bfi, this, assertor);
            EffectivePolicyImpl effectivePolicyImpl = epi;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                effectivePolicyImpl = effectivePolicyImpl;
                LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEffectiveServerFaultPolicy", effectivePolicyImpl);
            }
            return effectivePolicyImpl;
        }
        EffectivePolicy effectivePolicy = (EffectivePolicy)(bfi = this.mapToWrappedBindingFaultInfo(bfi)).getProperty(POLICY_INFO_FAULT_SERVER);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            Assertor assertor = PolicyUtils.createAsserter(d);
            epi.initialise(ei, boi, bfi, this, assertor);
            bfi.setProperty(POLICY_INFO_FAULT_SERVER, (Object)epi);
            effectivePolicy = epi;
        }
        EffectivePolicy effectivePolicy2 = effectivePolicy;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            effectivePolicy2 = effectivePolicy2;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEffectiveServerFaultPolicy", effectivePolicy2);
        }
        return effectivePolicy2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private BindingFaultInfo mapToWrappedBindingFaultInfo(BindingFaultInfo bfi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "mapToWrappedBindingFaultInfo", new Object[]{bfi});
        }
        BindingOperationInfo boi = bfi.getBindingOperation();
        if (boi != null && boi.isUnwrapped()) {
            boi = boi.getWrappedOperation();
            for (BindingFaultInfo bf2 : boi.getFaults()) {
                if (!bf2.getFaultInfo().getName().equals(bfi.getFaultInfo().getName())) continue;
                BindingFaultInfo bindingFaultInfo = bf2;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bindingFaultInfo = bindingFaultInfo;
                    LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "mapToWrappedBindingFaultInfo", bindingFaultInfo);
                }
                return bindingFaultInfo;
            }
        }
        BindingFaultInfo bindingFaultInfo = bfi;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bindingFaultInfo = bindingFaultInfo;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "mapToWrappedBindingFaultInfo", bindingFaultInfo);
        }
        return bindingFaultInfo;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setEffectiveServerFaultPolicy(EndpointInfo ei, BindingFaultInfo bfi, EffectivePolicy ep) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "setEffectiveServerFaultPolicy", new Object[]{ei, bfi, ep});
        }
        bfi.setProperty(POLICY_INFO_FAULT_SERVER, (Object)ep);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "setEffectiveServerFaultPolicy");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointPolicy getClientEndpointPolicy(EndpointInfo ei, Conduit conduit) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getClientEndpointPolicy", new Object[]{ei, conduit});
        }
        Assertor assertor = PolicyUtils.createAsserter(conduit);
        EndpointPolicy endpointPolicy = this.getEndpointPolicy(ei, true, assertor);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpointPolicy = endpointPolicy;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getClientEndpointPolicy", endpointPolicy);
        }
        return endpointPolicy;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointPolicy getServerEndpointPolicy(EndpointInfo ei, Destination destination) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getServerEndpointPolicy", new Object[]{ei, destination});
        }
        Assertor assertor = PolicyUtils.createAsserter(destination);
        EndpointPolicy endpointPolicy = this.getEndpointPolicy(ei, false, assertor);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpointPolicy = endpointPolicy;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getServerEndpointPolicy", endpointPolicy);
        }
        return endpointPolicy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private EndpointPolicy getEndpointPolicy(EndpointInfo ei, boolean isRequestor, Assertor assertor) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEndpointPolicy", new Object[]{ei, isRequestor, assertor});
        }
        EndpointPolicy ep = (EndpointPolicy)ei.getProperty(isRequestor ? POLICY_INFO_ENDPOINT_CLIENT : POLICY_INFO_ENDPOINT_SERVER);
        if (null != ep) {
            EndpointPolicy endpointPolicy = ep;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                endpointPolicy = endpointPolicy;
                LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEndpointPolicy", endpointPolicy);
            }
            return endpointPolicy;
        }
        EndpointPolicyImpl endpointPolicyImpl = this.createEndpointPolicyInfo(ei, isRequestor, assertor);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpointPolicyImpl = endpointPolicyImpl;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEndpointPolicy", endpointPolicyImpl);
        }
        return endpointPolicyImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setClientEndpointPolicy(EndpointInfo ei, EndpointPolicy ep) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "setClientEndpointPolicy", new Object[]{ei, ep});
        }
        ei.setProperty(POLICY_INFO_ENDPOINT_CLIENT, (Object)ep);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "setClientEndpointPolicy");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setServerEndpointPolicy(EndpointInfo ei, EndpointPolicy ep) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "setServerEndpointPolicy", new Object[]{ei, ep});
        }
        ei.setProperty(POLICY_INFO_ENDPOINT_SERVER, (Object)ep);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "setServerEndpointPolicy");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EffectivePolicy getEffectiveServerRequestPolicy(EndpointInfo ei, BindingOperationInfo boi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEffectiveServerRequestPolicy", new Object[]{ei, boi});
        }
        EffectivePolicy effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_REQUEST_SERVER);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            epi.initialise(ei, boi, this, false, true);
            boi.setProperty(POLICY_INFO_REQUEST_SERVER, (Object)epi);
            effectivePolicy = epi;
        }
        EffectivePolicy effectivePolicy2 = effectivePolicy;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            effectivePolicy2 = effectivePolicy2;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEffectiveServerRequestPolicy", effectivePolicy2);
        }
        return effectivePolicy2;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setEffectiveServerRequestPolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "setEffectiveServerRequestPolicy", new Object[]{ei, boi, ep});
        }
        boi.setProperty(POLICY_INFO_REQUEST_SERVER, (Object)ep);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "setEffectiveServerRequestPolicy");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EffectivePolicy getEffectiveClientResponsePolicy(EndpointInfo ei, BindingOperationInfo boi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEffectiveClientResponsePolicy", new Object[]{ei, boi});
        }
        EffectivePolicy effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_RESPONSE_CLIENT);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            epi.initialise(ei, boi, this, true, false);
            boi.setProperty(POLICY_INFO_RESPONSE_CLIENT, (Object)epi);
            effectivePolicy = epi;
        }
        EffectivePolicy effectivePolicy2 = effectivePolicy;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            effectivePolicy2 = effectivePolicy2;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEffectiveClientResponsePolicy", effectivePolicy2);
        }
        return effectivePolicy2;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setEffectiveClientResponsePolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "setEffectiveClientResponsePolicy", new Object[]{ei, boi, ep});
        }
        boi.setProperty(POLICY_INFO_RESPONSE_CLIENT, (Object)ep);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "setEffectiveClientResponsePolicy");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EffectivePolicy getEffectiveClientFaultPolicy(EndpointInfo ei, BindingOperationInfo boi, BindingFaultInfo bfi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEffectiveClientFaultPolicy", new Object[]{ei, boi, bfi});
        }
        EffectivePolicy effectivePolicy = null;
        if (bfi != null) {
            effectivePolicy = (EffectivePolicy)bfi.getProperty(POLICY_INFO_FAULT_CLIENT);
        }
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            epi.initialisePolicy(ei, boi, bfi, this);
            if (bfi != null) {
                bfi.setProperty(POLICY_INFO_FAULT_CLIENT, (Object)epi);
            }
            effectivePolicy = epi;
        }
        EffectivePolicy effectivePolicy2 = effectivePolicy;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            effectivePolicy2 = effectivePolicy2;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getEffectiveClientFaultPolicy", effectivePolicy2);
        }
        return effectivePolicy2;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setEffectiveClientFaultPolicy(EndpointInfo ei, BindingFaultInfo bfi, EffectivePolicy ep) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "setEffectiveClientFaultPolicy", new Object[]{ei, bfi, ep});
        }
        bfi.setProperty(POLICY_INFO_FAULT_CLIENT, (Object)ep);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "setEffectiveClientFaultPolicy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected final void init() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "init", new Object[0]);
        }
        this.registry = new PolicyRegistryImpl();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "init");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void removeBusInterceptors() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "removeBusInterceptors", new Object[0]);
        }
        this.bus.getInInterceptors().remove((Object)PolicyInInterceptor.INSTANCE);
        this.bus.getOutInterceptors().remove((Object)PolicyOutInterceptor.INSTANCE);
        this.bus.getInFaultInterceptors().remove((Object)ClientPolicyInFaultInterceptor.INSTANCE);
        this.bus.getOutFaultInterceptors().remove((Object)ServerPolicyOutFaultInterceptor.INSTANCE);
        this.bus.getInFaultInterceptors().remove((Object)PolicyVerificationInFaultInterceptor.INSTANCE);
        this.addedBusInterceptors = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "removeBusInterceptors");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final synchronized void addBusInterceptors() {
        AssertionBuilderRegistry abr;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "addBusInterceptors", new Object[0]);
        }
        if (null == this.bus || !this.enabled) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "addBusInterceptors");
            }
            return;
        }
        if (this.ignoreUnknownAssertions != null && null != (abr = (AssertionBuilderRegistry)this.bus.getExtension(AssertionBuilderRegistry.class))) {
            abr.setIgnoreUnknownAssertions(this.ignoreUnknownAssertions);
        }
        this.bus.getInInterceptors().add(PolicyInInterceptor.INSTANCE);
        this.bus.getOutInterceptors().add(PolicyOutInterceptor.INSTANCE);
        this.bus.getInFaultInterceptors().add(ClientPolicyInFaultInterceptor.INSTANCE);
        this.bus.getOutFaultInterceptors().add(ServerPolicyOutFaultInterceptor.INSTANCE);
        this.bus.getInFaultInterceptors().add(PolicyVerificationInFaultInterceptor.INSTANCE);
        this.addedBusInterceptors = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "addBusInterceptors");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    Policy getAggregatedServicePolicy(ServiceInfo si) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAggregatedServicePolicy", new Object[]{si});
        }
        if (si == null) {
            Policy policy = new Policy();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                policy = policy;
                LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAggregatedServicePolicy", policy);
            }
            return policy;
        }
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(si);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        Policy policy = aggregated == null ? new Policy() : aggregated;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            policy = policy;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAggregatedServicePolicy", policy);
        }
        return policy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    Policy getAggregatedEndpointPolicy(EndpointInfo ei) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAggregatedEndpointPolicy", new Object[]{ei});
        }
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(ei);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        Policy policy = aggregated == null ? new Policy() : aggregated;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            policy = policy;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAggregatedEndpointPolicy", policy);
        }
        return policy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    Policy getAggregatedOperationPolicy(BindingOperationInfo boi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAggregatedOperationPolicy", new Object[]{boi});
        }
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(boi);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        Policy policy = aggregated == null ? new Policy() : aggregated;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            policy = policy;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAggregatedOperationPolicy", policy);
        }
        return policy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    Policy getAggregatedMessagePolicy(BindingMessageInfo bmi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAggregatedMessagePolicy", new Object[]{bmi});
        }
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(bmi);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        Policy policy = aggregated == null ? new Policy() : aggregated;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            policy = policy;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAggregatedMessagePolicy", policy);
        }
        return policy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    Policy getAggregatedFaultPolicy(BindingFaultInfo bfi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAggregatedFaultPolicy", new Object[]{bfi});
        }
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(bfi);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        Policy policy = aggregated == null ? new Policy() : aggregated;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            policy = policy;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAggregatedFaultPolicy", policy);
        }
        return policy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    Collection<Assertion> getAssertions(PolicyComponent pc, boolean includeOptional) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAssertions", new Object[]{pc, includeOptional});
        }
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        if (5 == pc.getType()) {
            Assertion a = (Assertion)pc;
            if (includeOptional || !a.isOptional()) {
                assertions.add(a);
            }
        } else {
            this.addAssertions(pc, includeOptional, assertions);
        }
        ArrayList<Assertion> arrayList = assertions;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAssertions", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    Collection<Assertion> getAssertions(EffectivePolicy pc, boolean includeOptional) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAssertions", new Object[]{pc, includeOptional});
        }
        if (pc == null || pc.getChosenAlternative() == null) {
            Collection<Assertion> collection = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                collection = collection;
                LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAssertions", collection);
            }
            return collection;
        }
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        for (Assertion assertion : pc.getChosenAlternative()) {
            if (5 == assertion.getType()) {
                if (!includeOptional && assertion.isOptional()) continue;
                assertions.add(assertion);
                continue;
            }
            this.addAssertions((PolicyComponent)assertion, includeOptional, assertions);
        }
        ArrayList<Assertion> arrayList = assertions;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getAssertions", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void addAssertions(PolicyComponent pc, boolean includeOptional, Collection<Assertion> assertions) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "addAssertions", new Object[]{pc, includeOptional, assertions});
        }
        if (5 == pc.getType()) {
            Assertion a = (Assertion)pc;
            if (includeOptional || !a.isOptional()) {
                assertions.add((Assertion)pc);
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "addAssertions");
            }
            return;
        }
        if (4 == pc.getType()) {
            PolicyReference pr = (PolicyReference)pc;
            pc = pr.normalize(this.registry, false);
        }
        PolicyOperator po = (PolicyOperator)pc;
        List pcs = CastUtils.cast((List)po.getPolicyComponents(), PolicyComponent.class);
        for (PolicyComponent child : pcs) {
            this.addAssertions(child, includeOptional, assertions);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "addAssertions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    Set<QName> getVocabulary(PolicyComponent pc, boolean includeOptional) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "getVocabulary", new Object[]{pc, includeOptional});
        }
        Collection<Assertion> assertions = this.getAssertions(pc, includeOptional);
        HashSet<QName> vocabulary = new HashSet<QName>();
        for (Assertion a : assertions) {
            vocabulary.add(a.getName());
        }
        HashSet<QName> hashSet = vocabulary;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashSet = hashSet;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "getVocabulary", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    EndpointPolicyImpl createEndpointPolicyInfo(EndpointInfo ei, boolean isRequestor, Assertor assertor) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "createEndpointPolicyInfo", new Object[]{ei, isRequestor, assertor});
        }
        EndpointPolicyImpl epi = new EndpointPolicyImpl(ei, this, isRequestor, assertor);
        epi.initialize();
        ei.setProperty(isRequestor ? POLICY_INFO_ENDPOINT_CLIENT : POLICY_INFO_ENDPOINT_SERVER, (Object)epi);
        EndpointPolicyImpl endpointPolicyImpl = epi;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpointPolicyImpl = endpointPolicyImpl;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "createEndpointPolicyInfo", endpointPolicyImpl);
        }
        return endpointPolicyImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean supportsAlternative(Collection<? extends PolicyComponent> alternative, Assertor assertor) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "supportsAlternative", new Object[]{alternative, assertor});
        }
        PolicyInterceptorProviderRegistry pipr = (PolicyInterceptorProviderRegistry)this.bus.getExtension(PolicyInterceptorProviderRegistry.class);
        for (PolicyComponent policyComponent : alternative) {
            if (policyComponent instanceof Assertion) {
                Assertion a = (Assertion)policyComponent;
                if (a.isOptional() || !((Set)pipr.get(a.getName())).isEmpty() || null != assertor && assertor.canAssert(a.getName())) continue;
                LOG.fine("Alternative " + a.getName() + " is not supported");
                if (ignoreUnsupportedPolicy) {
                    LOG.fine("WARNING: Unsupported policy assertions will be ignored because property cxf.ignore.unsupported.policy is set to true.");
                    boolean bl = true;
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        bl = bl;
                        LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "supportsAlternative", bl);
                    }
                    return bl;
                }
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "supportsAlternative", bl);
                }
                return bl;
            }
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "supportsAlternative", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "supportsAlternative", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    EffectivePolicyImpl createOutPolicyInfo() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.policy.PolicyEngineImpl", "createOutPolicyInfo", new Object[0]);
        }
        EffectivePolicyImpl effectivePolicyImpl = new EffectivePolicyImpl();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            effectivePolicyImpl = effectivePolicyImpl;
            LOG.exiting("org.apache.cxf.ws.policy.PolicyEngineImpl", "createOutPolicyInfo", effectivePolicyImpl);
        }
        return effectivePolicyImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        String skipPolicyCheck = System.getProperty("cxf.ignore.unsupported.policy");
        LOG.log(Level.FINE, "cxf.ignore.unsupported.policy property is set to " + skipPolicyCheck);
        if (skipPolicyCheck != null && skipPolicyCheck.trim().length() > 0 && skipPolicyCheck.trim().equalsIgnoreCase("true")) {
            ignoreUnsupportedPolicy = true;
        }
    }
}

