/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.util.Collection;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.Extensible;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.ws.policy.attachment.external.PolicyAttachment;
import org.apache.neethi.Policy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ServiceModelPolicyUpdater {
    private EndpointInfo ei;
    static final long serialVersionUID = 411314043476316003L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ServiceModelPolicyUpdater(EndpointInfo ei) {
        this.ei = ei;
    }

    public void addPolicyAttachments(Collection<PolicyAttachment> attachments) {
        for (PolicyAttachment pa : attachments) {
            boolean policyUsed = false;
            String policyId = pa.getPolicy().getId();
            for (BindingOperationInfo boi : this.ei.getBinding().getOperations()) {
                if (!pa.appliesTo(boi)) continue;
                this.addPolicyRef((Extensible)boi, policyId);
                this.addPolicyRef((Extensible)this.ei.getInterface().getOperation(boi.getName()), policyId);
                policyUsed = true;
            }
            if (!policyUsed) continue;
            this.addPolicy(pa.getPolicy());
        }
    }

    private void addPolicyRef(Extensible ext, String policyId) {
        Document doc = DOMUtils.createDocument();
        Element el = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference");
        el.setPrefix("wsp");
        el.setAttribute("URI", "#" + policyId);
        UnknownExtensibilityElement uee = new UnknownExtensibilityElement();
        uee.setElementType(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference"));
        uee.setElement(el);
        uee.setRequired(Boolean.valueOf(true));
        ext.addExtensor((Object)uee);
    }

    private void addPolicy(Policy p) {
        try {
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
            p.serialize((XMLStreamWriter)writer);
            Element policyEl = writer.getDocument().getDocumentElement();
            policyEl.removeAttribute("xmlns:xmlns");
            UnknownExtensibilityElement uee = new UnknownExtensibilityElement();
            uee.setElementType(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy"));
            uee.setElement(policyEl);
            this.ei.getService().addExtensor((Object)uee);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Could not serialize policy", ex);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.ws.policy.ServiceModelPolicyUpdater", ServiceModelPolicyUpdater.class, null, null);
    }
}

