/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl.eventrecorder;

import com.ibm.ws.sib.jfapchannel.approxtime.QuickApproxTime;
import com.ibm.ws.sib.jfapchannel.framework.Framework;
import com.ibm.ws.sib.jfapchannel.impl.eventrecorder.ConnectionEventRecorder;
import com.ibm.ws.sib.jfapchannel.impl.eventrecorder.ConversationEventRecorder;
import com.ibm.ws.sib.jfapchannel.impl.eventrecorder.ConversationEventRecorderImpl;
import com.ibm.ws.sib.jfapchannel.impl.eventrecorder.EventRecorderImpl;
import com.ibm.ws.sib.jfapchannel.impl.eventrecorder.SequenceNumberGenerator;
import java.util.Calendar;

public class ConnectionEventRecorderImpl
extends EventRecorderImpl
implements ConnectionEventRecorder {
    private static final QuickApproxTime approxTime = Framework.getInstance().getApproximateTimeKeeper();
    private static final int DEFAULT_MAX_CONNECTION_EVENTS = 20;
    private static final int DEFAULT_MAX_CONVERSATION_EVENTS = 40;
    private static final int APPROXTIME_FREQUENCY = 100;
    private final byte[] eventTypeArray;
    private final long[] eventTimestampArray;
    private final int[] eventSequenceArray;
    private final int[] eventThreadHashcode;
    private final String[] eventDescriptionArray;
    private final int maxConnectionEvents;
    private final int maxConversationEvents;
    private int currentEvent;
    private int totalEvents;
    private final SequenceNumberGenerator sequenceNumberGenerator = new SequenceNumberGenerator();

    public ConnectionEventRecorderImpl() {
        this(20, 40);
    }

    public ConnectionEventRecorderImpl(int maxConnectionEvents) {
        this(maxConnectionEvents, 40);
    }

    public ConnectionEventRecorderImpl(int maxConnectionEvents, int maxConversationEvents) {
        this.maxConnectionEvents = maxConnectionEvents;
        this.maxConversationEvents = maxConversationEvents;
        this.eventTypeArray = new byte[maxConnectionEvents];
        this.eventTimestampArray = new long[maxConnectionEvents];
        this.eventSequenceArray = new int[maxConnectionEvents];
        this.eventThreadHashcode = new int[maxConnectionEvents];
        this.eventDescriptionArray = new String[maxConnectionEvents];
    }

    @Override
    public ConversationEventRecorder getConversationEventRecorder() {
        return new ConversationEventRecorderImpl(this, this.sequenceNumberGenerator, approxTime, this.maxConversationEvents);
    }

    @Override
    protected final synchronized void fillInNextEvent(byte type, String description) {
        this.eventTypeArray[this.currentEvent] = type;
        this.eventTimestampArray[this.currentEvent] = approxTime.getApproxTime();
        this.eventSequenceArray[this.currentEvent] = this.sequenceNumberGenerator.getNextSequenceNumber();
        this.eventThreadHashcode[this.currentEvent] = Thread.currentThread().hashCode();
        this.eventDescriptionArray[this.currentEvent] = description;
        this.currentEvent = (this.currentEvent + 1) % this.maxConnectionEvents;
        ++this.totalEvents;
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer("" + this.totalEvents);
        sb.append(" connection events recorded in total\n");
        sb.append("timestamp/sequence/thread/type/description\n");
        int eventIndex = this.totalEvents >= this.maxConnectionEvents ? this.currentEvent : 0;
        for (int eventCount = 0; this.eventTypeArray[eventIndex] != 0 && eventCount < this.maxConnectionEvents; ++eventCount) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(this.eventTimestampArray[eventIndex]);
            sb.append(calendar.get(11));
            sb.append(":");
            sb.append(calendar.get(12));
            sb.append(":");
            sb.append(calendar.get(13));
            sb.append(":");
            sb.append(calendar.get(14));
            sb.append(" ");
            sb.append(this.eventSequenceArray[eventIndex]);
            sb.append(" ");
            sb.append(Integer.toHexString(this.eventThreadHashcode[eventIndex]));
            sb.append("\t");
            sb.append((char)this.eventTypeArray[eventIndex]);
            sb.append("\t");
            sb.append(this.eventDescriptionArray[eventIndex]);
            sb.append("\n");
            eventIndex = (eventIndex + 1) % this.maxConnectionEvents;
        }
        return sb.toString();
    }

    static {
        approxTime.setInterval(100L);
    }
}

