/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.profiler;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionProfiler;

public class PerformanceMonitor
implements Serializable,
Cloneable,
SessionProfiler {
    protected static final String COUNTER = "Counter:";
    protected static final String TIMER = "Timer:";
    protected transient AbstractSession session;
    protected Map<String, Object> operationTimings = new ConcurrentHashMap<String, Object>();
    protected Map<Integer, Map<String, Long>> operationStartTimesByThread = new ConcurrentHashMap<Integer, Map<String, Long>>();
    protected long lastDumpTime = System.currentTimeMillis();
    protected long dumpTime = 60000L;
    protected int profileWeight = Integer.MAX_VALUE;

    public long getDumpTime() {
        return this.dumpTime;
    }

    public void setDumpTime(long dumpTime) {
        this.dumpTime = dumpTime;
    }

    public PerformanceMonitor clone() {
        try {
            return (PerformanceMonitor)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void checkDumpTime() {
        if (System.currentTimeMillis() - this.lastDumpTime > this.dumpTime) {
            this.dumpResults();
        }
    }

    public void dumpResults() {
        this.lastDumpTime = System.currentTimeMillis();
        StringWriter writer = new StringWriter();
        writer.write("\nPerformance Monitor:");
        writer.write(String.valueOf(this.lastDumpTime));
        writer.write("\nOperation\tValue (ns)\n");
        TreeSet<String> operations = new TreeSet<String>(this.operationTimings.keySet());
        NumberFormat formater = NumberFormat.getInstance();
        for (String operation : operations) {
            Object value = this.operationTimings.get(operation);
            if (value == null) {
                value = 0L;
            }
            writer.write(operation);
            writer.write("\t");
            if (value instanceof Long) {
                writer.write(formater.format(value));
            } else {
                writer.write(value.toString());
            }
            writer.write("\n");
        }
        try {
            this.session.getLog().write(writer.toString());
            this.session.getLog().flush();
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endOperationProfile(String operationName) {
        if (this.profileWeight < 10) {
            return;
        }
        long endTime = System.nanoTime();
        Long startTime = this.getOperationStartTimes().get(operationName);
        if (startTime == null) {
            return;
        }
        long time = endTime - startTime;
        Map<String, Object> map = this.operationTimings;
        synchronized (map) {
            Long totalTime = (Long)this.operationTimings.get(operationName);
            if (totalTime == null) {
                this.operationTimings.put(operationName, time);
            } else {
                this.operationTimings.put(operationName, totalTime + time);
            }
        }
    }

    @Override
    public void endOperationProfile(String operationName, DatabaseQuery query, int weight) {
        if (this.profileWeight < weight) {
            return;
        }
        this.endOperationProfile(operationName);
        if (query != null) {
            this.endOperationProfile(TIMER + query.getMonitorName() + ":" + operationName.substring(TIMER.length(), operationName.length()));
        }
    }

    protected Map<String, Long> getOperationStartTimes() {
        Integer threadId = Thread.currentThread().hashCode();
        Map<String, Long> times = this.operationStartTimesByThread.get(threadId);
        if (times == null) {
            times = new Hashtable<String, Long>();
            this.operationStartTimesByThread.put(threadId, times);
        }
        return times;
    }

    protected Map<Integer, Map<String, Long>> getOperationStartTimesByThread() {
        return this.operationStartTimesByThread;
    }

    public Object getOperationTime(String operation) {
        return this.operationTimings.get(operation);
    }

    public Map<String, Object> getOperationTimings() {
        return this.operationTimings;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    @Override
    public Object profileExecutionOfQuery(DatabaseQuery query, Record row, AbstractSession session) {
        if (this.profileWeight < 10) {
            return session.internalExecuteQuery(query, (AbstractRecord)row);
        }
        this.startOperationProfile(TIMER + query.getMonitorName());
        this.startOperationProfile(TIMER + query.getClass().getSimpleName());
        this.occurred(COUNTER + query.getClass().getSimpleName(), session);
        this.occurred(COUNTER + query.getMonitorName(), session);
        try {
            Object object = session.internalExecuteQuery(query, (AbstractRecord)row);
            return object;
        }
        finally {
            this.endOperationProfile(TIMER + query.getMonitorName());
            this.endOperationProfile(TIMER + query.getClass().getSimpleName());
            this.checkDumpTime();
        }
    }

    @Override
    public void setSession(Session session) {
        this.session = (AbstractSession)session;
    }

    @Override
    public void startOperationProfile(String operationName) {
        this.getOperationStartTimes().put(operationName, System.nanoTime());
    }

    @Override
    public void startOperationProfile(String operationName, DatabaseQuery query, int weight) {
        if (this.profileWeight < weight) {
            return;
        }
        this.startOperationProfile(operationName);
        if (query != null) {
            this.startOperationProfile(TIMER + query.getMonitorName() + ":" + operationName.substring(TIMER.length(), operationName.length()));
        }
    }

    @Override
    public void update(String operationName, Object value) {
        this.operationTimings.put(operationName, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void occurred(String operationName, AbstractSession session) {
        if (this.profileWeight < 5) {
            return;
        }
        Map<String, Object> map = this.operationTimings;
        synchronized (map) {
            Long occurred = (Long)this.operationTimings.get(operationName);
            if (occurred == null) {
                this.operationTimings.put(operationName, 1L);
            } else {
                this.operationTimings.put(operationName, occurred + 1L);
            }
        }
    }

    @Override
    public void occurred(String operationName, DatabaseQuery query, AbstractSession session) {
        if (this.profileWeight < 5) {
            return;
        }
        this.occurred(operationName, session);
        this.occurred(COUNTER + query.getMonitorName() + ":" + operationName.substring(COUNTER.length(), operationName.length()), session);
    }

    @Override
    public void setProfileWeight(int profileWeight) {
        this.profileWeight = profileWeight;
    }

    @Override
    public int getProfileWeight() {
        return this.profileWeight;
    }

    @Override
    public void initialize() {
    }
}

