/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.io.smallrye.graphql.component;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIServiceUtils;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.io.smallrye.graphql.component.TracingInterceptor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import org.eclipse.microprofile.graphql.GraphQLApi;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"api.classes=org.eclipse.microprofile.graphql.GraphQLApi", "bean.defining.annotations=org.eclipse.microprofile.graphql.GraphQLApi", "service.vendor=IBM"})
public class GraphQLExtension
implements Extension,
WebSphereCDIExtension {
    private static final Logger LOG = Logger.getLogger(GraphQLExtension.class.getName());
    static Map<ClassLoader, BeanManager> beanManagers = new WeakHashMap<ClassLoader, BeanManager>();
    static Map<ClassLoader, Set<Bean<?>>> graphQLApiBeans = new WeakHashMap();
    private static final boolean SECURITY_MANAGER_ENABLED = System.getSecurityManager() != null;
    static final long serialVersionUID = 5462629813108094108L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public GraphQLExtension() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.io.smallrye.graphql.component.GraphQLExtension", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("com.ibm.ws.io.smallrye.graphql.component.GraphQLExtension", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.io.smallrye.graphql.component.GraphQLExtension", "beforeBeanDiscovery", new Object[]{beforeBeanDiscovery, beanManager});
        }
        AnnotatedType bindingType = beanManager.createAnnotatedType(GraphQLApi.class);
        beforeBeanDiscovery.addInterceptorBinding(bindingType);
        AnnotatedType interceptorType = beanManager.createAnnotatedType(TracingInterceptor.class);
        beforeBeanDiscovery.addAnnotatedType(interceptorType, CDIServiceUtils.getAnnotatedTypeIdentifier((AnnotatedType)interceptorType, this.getClass()));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("com.ibm.ws.io.smallrye.graphql.component.GraphQLExtension", "beforeBeanDiscovery");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <X> void detectGraphQLComponent(@Observes ProcessBean<X> event, BeanManager beanManager) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.io.smallrye.graphql.component.GraphQLExtension", "detectGraphQLComponent", new Object[]{event, beanManager});
        }
        Annotated annotated = event.getAnnotated();
        if (annotated.isAnnotationPresent(GraphQLApi.class)) {
            Bean bean = event.getBean();
            Class beanClass = bean.getBeanClass();
            ClassLoader loader = GraphQLExtension.getContextClassLoader();
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("class, " + beanClass + " loaded by TCCL " + loader + " has beanManager, " + beanManager);
            }
            beanManagers.put(loader, beanManager);
            graphQLApiBeans.computeIfAbsent(loader, k -> new HashSet()).add(bean);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("com.ibm.ws.io.smallrye.graphql.component.GraphQLExtension", "detectGraphQLComponent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void registerGraphQLBeans(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.io.smallrye.graphql.component.GraphQLExtension", "registerGraphQLBeans", new Object[]{afterBeanDiscovery, beanManager});
        }
        ClassLoader tccl = GraphQLExtension.getContextClassLoader();
        Set<Bean<?>> beans = null;
        Map<ClassLoader, Set<Bean<?>>> map = graphQLApiBeans;
        synchronized (map) {
            beans = graphQLApiBeans.get(tccl);
        }
        if (beans != null) {
            for (Bean bean : beans) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("adding Bean, " + bean + " to afterBeanDiscovery");
                }
                afterBeanDiscovery.addBean(bean);
            }
        } else if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Attempting to register GraphQLApi beans for unknown app classloader: " + tccl);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("com.ibm.ws.io.smallrye.graphql.component.GraphQLExtension", "registerGraphQLBeans");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static BeanManager getBeanManager() {
        BeanManager beanManager;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.io.smallrye.graphql.component.GraphQLExtension", "getBeanManager", new Object[0]);
        }
        BeanManager beanManager2 = beanManager = beanManagers.get(GraphQLExtension.getContextClassLoader());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            beanManager2 = beanManager2;
            LOG.exiting("com.ibm.ws.io.smallrye.graphql.component.GraphQLExtension", "getBeanManager", beanManager2);
        }
        return beanManager2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static ClassLoader getContextClassLoader() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.io.smallrye.graphql.component.GraphQLExtension", "getContextClassLoader", new Object[0]);
        }
        if (SECURITY_MANAGER_ENABLED) {
            ClassLoader classLoader = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                classLoader = classLoader;
                LOG.exiting("com.ibm.ws.io.smallrye.graphql.component.GraphQLExtension", "getContextClassLoader", classLoader);
            }
            return classLoader;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classLoader = classLoader;
            LOG.exiting("com.ibm.ws.io.smallrye.graphql.component.GraphQLExtension", "getContextClassLoader", classLoader);
        }
        return classLoader;
    }
}

