/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.execution.datafetcher.ReflectionDataFetcher;
import io.smallrye.graphql.execution.datafetcher.helper.FieldHelper;
import io.smallrye.graphql.schema.model.Field;
import java.text.ParseException;
import java.time.DateTimeException;
import org.eclipse.microprofile.graphql.GraphQLException;
import org.jboss.logging.Logger;

public class PropertyDataFetcher
extends graphql.schema.PropertyDataFetcher {
    private static final Logger LOG = Logger.getLogger((String)ReflectionDataFetcher.class.getName());
    private final FieldHelper fieldHelper;

    public PropertyDataFetcher(Field field) {
        super(field.getPropertyName());
        this.fieldHelper = new FieldHelper(field);
    }

    public Object get(DataFetchingEnvironment environment) {
        Object resultFromMethodCall = super.get(environment);
        try {
            return this.fieldHelper.transformResponse(resultFromMethodCall);
        }
        catch (NumberFormatException | ParseException | DateTimeException | GraphQLException ex) {
            LOG.warn((Object)ex.getMessage());
            return resultFromMethodCall;
        }
    }
}

