/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionPath;
import graphql.language.SourceLocation;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.execution.datafetcher.DataFetcherException;
import io.smallrye.graphql.execution.datafetcher.decorator.DataFetcherDecorator;
import io.smallrye.graphql.execution.datafetcher.helper.ArgumentHelper;
import io.smallrye.graphql.execution.datafetcher.helper.FieldHelper;
import io.smallrye.graphql.execution.error.GraphQLExceptionWhileDataFetching;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.spi.ClassloadingService;
import io.smallrye.graphql.spi.LookupService;
import io.smallrye.graphql.transformation.TransformException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.microprofile.graphql.GraphQLException;

public class ReflectionDataFetcher
implements DataFetcher {
    private final LookupService lookupService = LookupService.load();
    private final ClassloadingService classloadingService = ClassloadingService.load();
    private final Operation operation;
    private final FieldHelper fieldHelper;
    private final ArgumentHelper argumentHelper;
    private final Collection<DataFetcherDecorator> decorators;
    private List<Class> parameterClasses;

    public ReflectionDataFetcher(Operation operation) {
        this(operation, Collections.emptyList());
    }

    public ReflectionDataFetcher(Operation operation, Collection<DataFetcherDecorator> decorators) {
        this.operation = operation;
        this.fieldHelper = new FieldHelper(operation);
        this.argumentHelper = new ArgumentHelper(operation.getArguments());
        this.decorators = decorators;
    }

    public Object get(DataFetchingEnvironment dfe) throws Exception {
        this.decorators.forEach(decorator -> decorator.before(dfe));
        Class<?> operationClass = this.classloadingService.loadClass(this.operation.getClassName());
        Object declaringObject = this.lookupService.getInstance(operationClass);
        try {
            Object m;
            Class<?> cdiClass = declaringObject.getClass();
            Object resultFromMethodCall = null;
            if (this.operation.hasArguments()) {
                m = cdiClass.getMethod(this.operation.getMethodName(), this.getParameterClasses());
                List transformedArguments = this.argumentHelper.getArguments(dfe);
                resultFromMethodCall = ((Method)m).invoke(declaringObject, transformedArguments.toArray());
            } else {
                m = cdiClass.getMethod(this.operation.getMethodName(), new Class[0]);
                resultFromMethodCall = ((Method)m).invoke(declaringObject, new Object[0]);
            }
            m = this.fieldHelper.transformResponse(resultFromMethodCall);
            return m;
        }
        catch (TransformException pe) {
            DataFetcherResult<Object> resultFromMethodCall = pe.getDataFetcherResult(dfe);
            return resultFromMethodCall;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | GraphQLException ex) {
            Throwable throwable = ex.getCause();
            if (throwable == null) {
                throw new DataFetcherException(this.operation, (Exception)ex);
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof GraphQLException) {
                GraphQLException graphQLException = (GraphQLException)throwable;
                DataFetcherResult<Object> dataFetcherResult = this.getPartialResult(dfe, graphQLException);
                return dataFetcherResult;
            }
            throw (Exception)throwable;
        }
        finally {
            this.decorators.forEach(decorator -> decorator.after(dfe));
        }
    }

    private DataFetcherResult<Object> getPartialResult(DataFetchingEnvironment dfe, GraphQLException graphQLException) {
        DataFetcherExceptionHandlerParameters handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment(dfe).exception((Throwable)graphQLException).build();
        SourceLocation sourceLocation = handlerParameters.getSourceLocation();
        ExecutionPath path = handlerParameters.getPath();
        GraphQLExceptionWhileDataFetching error = new GraphQLExceptionWhileDataFetching(path, graphQLException, sourceLocation);
        return DataFetcherResult.newResult().data(graphQLException.getPartialResults()).error((GraphQLError)error).build();
    }

    private Class[] getParameterClasses() {
        if (this.operation.hasArguments()) {
            if (this.parameterClasses == null) {
                LinkedList<Class> cl = new LinkedList<Class>();
                for (Field field : this.operation.getArguments()) {
                    Class<?> clazz;
                    if (field.hasArray()) {
                        clazz = this.classloadingService.loadClass(field.getArray().getClassName());
                        cl.add(clazz);
                        continue;
                    }
                    clazz = this.classloadingService.loadClass(field.getReference().getClassName());
                    cl.add(clazz);
                }
                this.parameterClasses = cl;
            }
            return this.parameterClasses.toArray(new Class[0]);
        }
        return null;
    }
}

