/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.error;

import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.ExecutionPath;
import graphql.language.SourceLocation;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.execution.error.ExceptionLists;
import io.smallrye.graphql.execution.error.GraphQLExceptionWhileDataFetching;
import org.jboss.logging.Logger;

public class ExceptionHandler
implements DataFetcherExceptionHandler {
    private static final Logger LOG = Logger.getLogger((String)ExceptionHandler.class.getName());
    private final Config config;
    private final ExceptionLists exceptionLists;

    public ExceptionHandler(Config config) {
        this.config = config;
        this.exceptionLists = new ExceptionLists(config.getBlackList(), config.getWhiteList());
    }

    public DataFetcherExceptionHandlerResult onException(DataFetcherExceptionHandlerParameters handlerParameters) {
        Throwable throwable = handlerParameters.getException();
        SourceLocation sourceLocation = handlerParameters.getSourceLocation();
        ExecutionPath path = handlerParameters.getPath();
        ExceptionWhileDataFetching error = this.getExceptionWhileDataFetching(throwable, sourceLocation, path);
        if (this.config.isPrintDataFetcherException()) {
            LOG.log(Logger.Level.ERROR, (Object)"Data Fetching Error", throwable);
        }
        return DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)error).build();
    }

    private ExceptionWhileDataFetching getExceptionWhileDataFetching(Throwable throwable, SourceLocation sourceLocation, ExecutionPath path) {
        if (throwable instanceof RuntimeException) {
            if (this.exceptionLists.isWhitelisted(throwable)) {
                return new GraphQLExceptionWhileDataFetching(path, throwable, sourceLocation);
            }
            return new GraphQLExceptionWhileDataFetching(this.config.getDefaultErrorMessage(), path, throwable, sourceLocation);
        }
        if (this.exceptionLists.isBlacklisted(throwable)) {
            return new GraphQLExceptionWhileDataFetching(this.config.getDefaultErrorMessage(), path, throwable, sourceLocation);
        }
        return new GraphQLExceptionWhileDataFetching(path, throwable, sourceLocation);
    }
}

