/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.error;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ExceptionLists {
    private final List<String> blackList;
    private final List<String> whiteList;

    public ExceptionLists(Optional<List<String>> maybeBlackList, Optional<List<String>> maybeWhiteList) {
        this.blackList = maybeBlackList.isPresent() ? maybeBlackList.get() : Collections.EMPTY_LIST;
        this.whiteList = maybeWhiteList.isPresent() ? maybeWhiteList.get() : Collections.EMPTY_LIST;
    }

    boolean isBlacklisted(Throwable throwable) {
        return this.isListed(throwable, this.blackList);
    }

    boolean isWhitelisted(Throwable throwable) {
        return this.isListed(throwable, this.whiteList);
    }

    private boolean isListed(Throwable throwable, List<String> classNames) {
        if (classNames == null || classNames.isEmpty() || throwable == null) {
            return false;
        }
        return this.isListed(throwable.getClass(), classNames);
    }

    private boolean isListed(Class throwableClass, List<String> classNames) {
        if (classNames == null || classNames.isEmpty() || throwableClass == null || throwableClass.getName().equals(Object.class.getName())) {
            return false;
        }
        if (classNames.contains(throwableClass.getName())) {
            return true;
        }
        return this.isListed(throwableClass.getSuperclass(), classNames);
    }
}

